/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.builder;

import eu.stork.mw.messages.saml.STORKAuthnRequest;
import eu.stork.mw.messages.saml.STORKResponse;
import eu.stork.vidp.messages.saml.STORKAttribute;
import eu.stork.vidp.messages.saml.STORKAttributeValue;
import eu.stork.vidp.messages.saml.STORKExtensions;
import eu.stork.vidp.messages.saml.STORKRequestedAttribute;
import eu.stork.vidp.messages.stork.AuthenticationAttributes;
import eu.stork.vidp.messages.stork.CitizenCountryCode;
import eu.stork.vidp.messages.stork.EIDCrossBorderShare;
import eu.stork.vidp.messages.stork.EIDCrossSectorShare;
import eu.stork.vidp.messages.stork.EIDSectorShare;
import eu.stork.vidp.messages.stork.QualityAuthenticationAssuranceLevel;
import eu.stork.vidp.messages.stork.RequestedAttributes;
import eu.stork.vidp.messages.stork.SPAuthRequest;
import eu.stork.vidp.messages.stork.SPCertEnc;
import eu.stork.vidp.messages.stork.SPCertSig;
import eu.stork.vidp.messages.stork.SPCertType;
import eu.stork.vidp.messages.stork.SPID;
import eu.stork.vidp.messages.stork.SPInformation;
import eu.stork.vidp.messages.stork.SpApplication;
import eu.stork.vidp.messages.stork.SpCountry;
import eu.stork.vidp.messages.stork.SpInstitution;
import eu.stork.vidp.messages.stork.SpSector;
import eu.stork.vidp.messages.stork.VIDPAuthenticationAttributes;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.Audience;
import org.opensaml.saml2.core.AudienceRestriction;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.OneTimeUse;
import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.StatusDetail;
import org.opensaml.saml2.core.StatusMessage;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml2.core.SubjectLocality;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.ws.soap.common.SOAPObject;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSAnyBuilder;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class STORKMessagesBuilder {
    static final Logger log = LoggerFactory.getLogger(STORKMessagesBuilder.class);

    public static <T extends XMLObject> T buildXMLObject(QName objectQName) {
        try {
            XMLObjectBuilder builder = Configuration.getBuilderFactory().getBuilder(objectQName);
            return (T)builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
        }
        catch (Exception e) {
            log.error("Cannot build XML Object {}: {}", (Object)objectQName.getLocalPart(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T extends SOAPObject> T buildSOAPObject(QName objectQName) {
        try {
            SOAPObjectBuilder builder = (SOAPObjectBuilder)Configuration.getBuilderFactory().getBuilder(objectQName);
            return (T)builder.buildObject();
        }
        catch (Exception e) {
            log.error("Cannot build SOAP Object {}: {}", (Object)objectQName.getLocalPart(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T extends SAMLObject> T buildSAMLObject(QName objectQName) {
        try {
            SAMLObjectBuilder builder = (SAMLObjectBuilder)Configuration.getBuilderFactory().getBuilder(objectQName);
            return (T)builder.buildObject();
        }
        catch (Exception e) {
            log.error("Cannot build SAML Object {}: {}", (Object)objectQName.getLocalPart(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static Issuer buildIssuer(String issuerValue) {
        if (StringUtils.isEmpty((String)issuerValue)) {
            return null;
        }
        Issuer issuer = (Issuer)STORKMessagesBuilder.buildXMLObject(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(issuerValue);
        issuer.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:entity");
        return issuer;
    }

    public static QualityAuthenticationAssuranceLevel buildQualityAuthenticationAssuranceLevel(int qaaValue) {
        if (qaaValue < 1 || qaaValue > 4) {
            log.error("QAA Level must be between 1 and 4.");
            return null;
        }
        QualityAuthenticationAssuranceLevel qaaLevel = (QualityAuthenticationAssuranceLevel)STORKMessagesBuilder.buildXMLObject(QualityAuthenticationAssuranceLevel.DEFAULT_ELEMENT_NAME);
        qaaLevel.setValue(qaaValue);
        return qaaLevel;
    }

    public static RequestedAttribute buildRequestedAttribute(String name, boolean isRequired, String value) {
        RequestedAttribute reqAttribute = (RequestedAttribute)STORKMessagesBuilder.buildXMLObject(STORKRequestedAttribute.DEFAULT_ELEMENT_NAME);
        reqAttribute.setName(name);
        reqAttribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        reqAttribute.setIsRequired(Boolean.valueOf(isRequired));
        if (!StringUtils.isEmpty((String)value)) {
            XSString stringValue = STORKMessagesBuilder.buildXSString(STORKAttributeValue.DEFAULT_ELEMENT_NAME);
            stringValue.setValue(value);
            reqAttribute.getAttributeValues().add(stringValue);
        }
        return reqAttribute;
    }

    public static XSString buildXSString(QName qname) {
        XSStringBuilder stringBuilder = (XSStringBuilder)Configuration.getBuilderFactory().getBuilder(XSString.TYPE_NAME);
        return (XSString)stringBuilder.buildObject(qname, XSString.TYPE_NAME);
    }

    public static XSAny buildXSAny(QName qname) {
        XSAnyBuilder anyBuilder = (XSAnyBuilder)Configuration.getBuilderFactory().getBuilder(XSAny.TYPE_NAME);
        return (XSAny)anyBuilder.buildObject(qname, XSAny.TYPE_NAME);
    }

    public static RequestedAttributes buildRequestedAttributes(RequestedAttribute ... requestedAttributeArguments) {
        if (requestedAttributeArguments == null) {
            return null;
        }
        RequestedAttributes reqAttributes = (RequestedAttributes)STORKMessagesBuilder.buildXMLObject(RequestedAttributes.DEFAULT_ELEMENT_NAME);
        for (RequestedAttribute reqAttr : requestedAttributeArguments) {
            reqAttributes.getRequestedAttributes().add(reqAttr);
        }
        return reqAttributes;
    }

    public static RequestedAttributes buildRequestedAttributes(List<RequestedAttribute> requestedAttributeList) {
        if (requestedAttributeList == null) {
            return null;
        }
        RequestedAttributes reqAttributes = (RequestedAttributes)STORKMessagesBuilder.buildXMLObject(RequestedAttributes.DEFAULT_ELEMENT_NAME);
        reqAttributes.getRequestedAttributes().addAll(requestedAttributeList);
        return reqAttributes;
    }

    public static CitizenCountryCode buildCitizenCountryCode(String ccc) {
        if (StringUtils.isEmpty((String)ccc)) {
            log.error("CitizenCountryCode must have a value.");
            return null;
        }
        CitizenCountryCode citizenCountryCode = (CitizenCountryCode)STORKMessagesBuilder.buildXMLObject(CitizenCountryCode.DEFAULT_ELEMENT_NAME);
        citizenCountryCode.setValue(ccc);
        return citizenCountryCode;
    }

    public static SPID buildSPID(String spIDString) {
        if (StringUtils.isEmpty((String)spIDString)) {
            log.error("SPID must have a value.");
            return null;
        }
        SPID spID = (SPID)STORKMessagesBuilder.buildXMLObject(SPID.DEFAULT_ELEMENT_NAME);
        spID.setValue(spIDString);
        return spID;
    }

    private static SPCertType buildSPCertType(java.security.cert.X509Certificate cert) {
        SPCertType spCertType = (SPCertType)STORKMessagesBuilder.buildXMLObject(SPCertType.TYPE_NAME);
        KeyInfo keyInfo = (KeyInfo)STORKMessagesBuilder.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        X509Data x509DataElem = (X509Data)STORKMessagesBuilder.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
        X509Certificate x509CertElem = (X509Certificate)STORKMessagesBuilder.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
        try {
            x509CertElem.setValue(Base64.encodeBytes((byte[])cert.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            log.error("Cannot encode certificate.", (Throwable)e);
            throw new RuntimeException(e);
        }
        x509DataElem.getX509Certificates().add(x509CertElem);
        keyInfo.getX509Datas().add(x509DataElem);
        spCertType.setKeyInfo(keyInfo);
        return spCertType;
    }

    public static SPCertSig buildSPCertSig(java.security.cert.X509Certificate cert) {
        return (SPCertSig)STORKMessagesBuilder.buildSPCertType(cert);
    }

    public static SPCertEnc buildSPCertEnc(java.security.cert.X509Certificate cert) {
        return (SPCertEnc)STORKMessagesBuilder.buildSPCertType(cert);
    }

    public static SPAuthRequest buildSPAuthRequest(XMLObject xmlObject) {
        SPAuthRequest authRequest = (SPAuthRequest)STORKMessagesBuilder.buildXMLObject(SPAuthRequest.DEFAULT_ELEMENT_NAME);
        authRequest.getUnknownXMLObjects().add(xmlObject);
        return authRequest;
    }

    public static SPInformation buildSPInformation(String spIDString, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest) {
        SPInformation spInformation = (SPInformation)STORKMessagesBuilder.buildXMLObject(SPInformation.DEFAULT_ELEMENT_NAME);
        SPID spID = STORKMessagesBuilder.buildSPID(spIDString);
        spInformation.setSPID(spID);
        if (sigCert != null) {
            SPCertSig spCertSig = STORKMessagesBuilder.buildSPCertSig(sigCert);
            spInformation.setSPCertSig(spCertSig);
        }
        if (encCert != null) {
            SPCertEnc spCertEnc = STORKMessagesBuilder.buildSPCertEnc(encCert);
            spInformation.setSPCertEnc(spCertEnc);
        }
        if (spAuthRequest != null) {
            SPAuthRequest spAuthRequestElem = STORKMessagesBuilder.buildSPAuthRequest(spAuthRequest);
            spInformation.setSPAuthRequest(spAuthRequestElem);
        }
        return spInformation;
    }

    public static VIDPAuthenticationAttributes buildVIDPAuthenticationAttributes(String ccc, String spIDString, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest) {
        VIDPAuthenticationAttributes vidpAuthenticationAttributes = (VIDPAuthenticationAttributes)STORKMessagesBuilder.buildXMLObject(VIDPAuthenticationAttributes.DEFAULT_ELEMENT_NAME);
        CitizenCountryCode citizenCountryCode = STORKMessagesBuilder.buildCitizenCountryCode(ccc);
        SPInformation spInformation = STORKMessagesBuilder.buildSPInformation(spIDString, sigCert, encCert, spAuthRequest);
        vidpAuthenticationAttributes.setCitizenCountryCode(citizenCountryCode);
        vidpAuthenticationAttributes.setSPInformation(spInformation);
        return vidpAuthenticationAttributes;
    }

    public static AuthenticationAttributes buildAuthenticationAttributes(String ccc, String spIDString, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest) {
        AuthenticationAttributes authenticationAttributes = (AuthenticationAttributes)STORKMessagesBuilder.buildXMLObject(AuthenticationAttributes.DEFAULT_ELEMENT_NAME);
        VIDPAuthenticationAttributes vidpAuthenticationAttributes = STORKMessagesBuilder.buildVIDPAuthenticationAttributes(ccc, spIDString, sigCert, encCert, spAuthRequest);
        authenticationAttributes.setVIDPAuthenticationAttributes(vidpAuthenticationAttributes);
        return authenticationAttributes;
    }

    public static SpSector buildSpSector(String spSectorValue) {
        SpSector spSector = (SpSector)STORKMessagesBuilder.buildXMLObject(SpSector.DEFAULT_ELEMENT_NAME);
        spSector.setValue(spSectorValue);
        return spSector;
    }

    public static SpInstitution buildSpInstitution(String spInstitutionValue) {
        SpInstitution spInstitution = (SpInstitution)STORKMessagesBuilder.buildXMLObject(SpInstitution.DEFAULT_ELEMENT_NAME);
        spInstitution.setValue(spInstitutionValue);
        return spInstitution;
    }

    public static SpApplication buildSpApplication(String spApplicationValue) {
        SpApplication spApplication = (SpApplication)STORKMessagesBuilder.buildXMLObject(SpApplication.DEFAULT_ELEMENT_NAME);
        spApplication.setValue(spApplicationValue);
        return spApplication;
    }

    public static SpCountry buildSpCountry(String spCountryValue) {
        SpCountry spCountry = (SpCountry)STORKMessagesBuilder.buildXMLObject(SpCountry.DEFAULT_ELEMENT_NAME);
        spCountry.setValue(spCountryValue);
        return spCountry;
    }

    public static String generateID() {
        try {
            SecureRandomIdentifierGenerator idGenerator = new SecureRandomIdentifierGenerator();
            return idGenerator.generateIdentifier();
        }
        catch (NoSuchAlgorithmException e) {
            log.error("Cannot generate id", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static STORKAuthnRequest buildSTORKAuthnRequest(String destination, String acsURL, String providerName, String issuerValue, QualityAuthenticationAssuranceLevel qaaLevel, RequestedAttributes requestedAttributes, String spSector, String spInstitution, String spApplication, String spCountry) {
        String consent = "urn:oasis:names:tc:SAML:2.0:consent:unspecified";
        boolean forceAuthn = true;
        boolean isPassive = false;
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        boolean eIDSectorShare = true;
        boolean eIDCrossSectorShare = true;
        boolean eIDCrossBorderShare = false;
        STORKAuthnRequest authnRequest = (STORKAuthnRequest)STORKMessagesBuilder.buildXMLObject(STORKAuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setID(STORKMessagesBuilder.generateID());
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setConsent(consent);
        authnRequest.setForceAuthn(forceAuthn);
        authnRequest.setIsPassive(isPassive);
        authnRequest.setProtocolBinding(binding);
        authnRequest.setDestination(destination);
        authnRequest.setAssertionConsumerServiceURL(acsURL);
        authnRequest.setProviderName(providerName);
        authnRequest.setIssuer(STORKMessagesBuilder.buildIssuer(issuerValue));
        STORKExtensions extensions = STORKMessagesBuilder.buildSTORKExtensions();
        authnRequest.setQAALevel(qaaLevel.getValue());
        extensions.setQAALevel(qaaLevel);
        authnRequest.setRequestedAttributes(requestedAttributes.getRequestedAttributes());
        extensions.setRequestedAttributes(requestedAttributes);
        EIDSectorShare eidSectorShareObj = (EIDSectorShare)STORKMessagesBuilder.buildXMLObject(EIDSectorShare.DEFAULT_ELEMENT_NAME);
        eidSectorShareObj.setValue(eIDSectorShare);
        EIDCrossSectorShare eidCrossSectorShareObj = (EIDCrossSectorShare)STORKMessagesBuilder.buildXMLObject(EIDCrossSectorShare.DEFAULT_ELEMENT_NAME);
        eidCrossSectorShareObj.setValue(eIDCrossSectorShare);
        EIDCrossBorderShare eidCrossBorderShareObj = (EIDCrossBorderShare)STORKMessagesBuilder.buildXMLObject(EIDCrossBorderShare.DEFAULT_ELEMENT_NAME);
        eidCrossBorderShareObj.setValue(eIDCrossBorderShare);
        SpSector spSectorObj = STORKMessagesBuilder.buildSpSector(spSector);
        SpInstitution spInstitutionObj = STORKMessagesBuilder.buildSpInstitution(spInstitution);
        SpApplication spApplicationObj = STORKMessagesBuilder.buildSpApplication(spApplication);
        SpCountry spCountryObj = STORKMessagesBuilder.buildSpCountry(spCountry);
        extensions.getUnknownXMLObjects().add(qaaLevel);
        extensions.getUnknownXMLObjects().add(spSectorObj);
        extensions.getUnknownXMLObjects().add(spInstitutionObj);
        extensions.getUnknownXMLObjects().add(spApplicationObj);
        extensions.getUnknownXMLObjects().add(spCountryObj);
        extensions.getUnknownXMLObjects().add(eidSectorShareObj);
        extensions.getUnknownXMLObjects().add(eidCrossSectorShareObj);
        extensions.getUnknownXMLObjects().add(eidCrossBorderShareObj);
        extensions.getUnknownXMLObjects().add(requestedAttributes);
        authnRequest.setExtensions(extensions);
        return authnRequest;
    }

    public static STORKAuthnRequest buildSTORKAuthnRequest(String destination, String acsURL, String providerName, String issuerValue, int qaaLevel, List<RequestedAttribute> requestedAttributeList, String ccc, String spID, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest, String spSector, String spInstitution, String spApplication, String spCountry) {
        String consent = "urn:oasis:names:tc:SAML:2.0:consent:unspecified";
        boolean forceAuthn = true;
        boolean isPassive = false;
        String binding = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
        boolean eIDSectorShare = true;
        boolean eIDCrossSectorShare = true;
        boolean eIDCrossBorderShare = false;
        return STORKMessagesBuilder.buildSTORKAuthnRequest(consent, forceAuthn, isPassive, binding, eIDSectorShare, eIDCrossSectorShare, eIDCrossBorderShare, destination, acsURL, providerName, issuerValue, qaaLevel, requestedAttributeList, ccc, spID, sigCert, encCert, spAuthRequest, spSector, spInstitution, spApplication, spCountry);
    }

    public static STORKAuthnRequest buildSTORKAuthnRequest(String consent, boolean forceAuthn, boolean isPassive, String binding, boolean eIDSectorShare, boolean eIDCrossSectorShare, boolean eIDCrossBorderShare, String destination, String acsURL, String providerName, String issuerValue, int qaaLevel, List<RequestedAttribute> requestedAttributeList, String ccc, String spID, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest, String spSector, String spInstitution, String spApplication, String spCountry) {
        STORKAuthnRequest authnRequest = (STORKAuthnRequest)STORKMessagesBuilder.buildXMLObject(STORKAuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setVersion(SAMLVersion.VERSION_20);
        authnRequest.setID(STORKMessagesBuilder.generateID());
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setDestination(destination);
        authnRequest.setAssertionConsumerServiceURL(acsURL);
        authnRequest.setProviderName(providerName);
        authnRequest.setIssuer(STORKMessagesBuilder.buildIssuer(issuerValue));
        authnRequest.setQAALevel(qaaLevel);
        authnRequest.setRequestedAttributes(requestedAttributeList);
        authnRequest.setCitizenCountryCode(ccc);
        authnRequest.setSPID(spID);
        authnRequest.setSPCertSig(sigCert);
        authnRequest.setSPCertEnc(encCert);
        authnRequest.setOriginalSPAuthRequest(spAuthRequest);
        authnRequest.setConsent(consent);
        authnRequest.setForceAuthn(forceAuthn);
        authnRequest.setIsPassive(isPassive);
        authnRequest.setProtocolBinding(binding);
        STORKMessagesBuilder.addSTORKExtensionsToAuthnRequest(authnRequest, qaaLevel, requestedAttributeList, ccc, spID, sigCert, encCert, spAuthRequest, eIDSectorShare, eIDCrossSectorShare, eIDCrossBorderShare, spSector, spInstitution, spApplication, spCountry);
        return authnRequest;
    }

    public static void addSTORKExtensionsToAuthnRequest(STORKAuthnRequest authnRequest, int qaaLevel, List<RequestedAttribute> requestedAttributeList, String ccc, String spID, java.security.cert.X509Certificate sigCert, java.security.cert.X509Certificate encCert, XMLObject spAuthRequest, boolean eIDSectorShare, boolean eIDCrossSectorShare, boolean eIDCrossBorderShare, String spSector, String spInstitution, String spApplication, String spCountry) {
        STORKExtensions extensions = STORKMessagesBuilder.buildSTORKExtensions();
        authnRequest.setRequestedAttributes(requestedAttributeList);
        QualityAuthenticationAssuranceLevel qaaLevelObj = STORKMessagesBuilder.buildQualityAuthenticationAssuranceLevel(qaaLevel);
        RequestedAttributes requestedAttributesObj = STORKMessagesBuilder.buildRequestedAttributes(requestedAttributeList);
        AuthenticationAttributes authenticationAttributesObj = STORKMessagesBuilder.buildAuthenticationAttributes(ccc, spID, sigCert, encCert, spAuthRequest);
        EIDSectorShare eidSectorShareObj = (EIDSectorShare)STORKMessagesBuilder.buildXMLObject(EIDSectorShare.DEFAULT_ELEMENT_NAME);
        eidSectorShareObj.setValue(eIDSectorShare);
        EIDCrossSectorShare eidCrossSectorShareObj = (EIDCrossSectorShare)STORKMessagesBuilder.buildXMLObject(EIDCrossSectorShare.DEFAULT_ELEMENT_NAME);
        eidCrossSectorShareObj.setValue(eIDCrossSectorShare);
        EIDCrossBorderShare eidCrossBorderShareObj = (EIDCrossBorderShare)STORKMessagesBuilder.buildXMLObject(EIDCrossBorderShare.DEFAULT_ELEMENT_NAME);
        eidCrossBorderShareObj.setValue(eIDCrossBorderShare);
        SpSector spSectorObj = STORKMessagesBuilder.buildSpSector(spSector);
        SpApplication spApplicationObj = STORKMessagesBuilder.buildSpApplication(spApplication);
        SpCountry spCountryObj = STORKMessagesBuilder.buildSpCountry(spCountry);
        extensions.setQAALevel(qaaLevelObj);
        extensions.setRequestedAttributes(requestedAttributesObj);
        extensions.setAuthenticationAttributes(authenticationAttributesObj);
        extensions.getUnknownXMLObjects().add(qaaLevelObj);
        extensions.getUnknownXMLObjects().add(spSectorObj);
        extensions.getUnknownXMLObjects().add(spApplicationObj);
        extensions.getUnknownXMLObjects().add(spCountryObj);
        extensions.getUnknownXMLObjects().add(eidSectorShareObj);
        extensions.getUnknownXMLObjects().add(eidCrossSectorShareObj);
        extensions.getUnknownXMLObjects().add(eidCrossBorderShareObj);
        extensions.getUnknownXMLObjects().add(requestedAttributesObj);
        extensions.getUnknownXMLObjects().add(authenticationAttributesObj);
        authnRequest.setExtensions(extensions);
    }

    public static STORKExtensions buildSTORKExtensions() {
        QName samlProtocolExtensions = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Extensions", "saml2p");
        return (STORKExtensions)STORKMessagesBuilder.buildXMLObject(samlProtocolExtensions);
    }

    public static STORKResponse buildSTORKResponse(String destination, String inResponseTo, Issuer issuer, Status status, Assertion assertion) {
        STORKResponse response = (STORKResponse)STORKMessagesBuilder.buildXMLObject(STORKResponse.DEFAULT_ELEMENT_NAME);
        response.setDestination(destination);
        response.setInResponseTo(inResponseTo);
        response.setConsent("urn:oasis:names:tc:SAML:2.0:consent:obtained");
        response.setID(STORKMessagesBuilder.generateID());
        response.setIssueInstant(new DateTime());
        response.setVersion(SAMLVersion.VERSION_20);
        response.setIssuer(issuer);
        response.setStatus(status);
        response.getAssertions().add(assertion);
        return response;
    }

    public static STORKResponse buildSTORKResponse(String destination, String inResponseTo, String issuerString, String statusCode, String statusMessage, Assertion assertion) {
        Status status = STORKMessagesBuilder.buildStatus(statusCode, statusMessage);
        Issuer issuer = STORKMessagesBuilder.buildIssuer(issuerString);
        return STORKMessagesBuilder.buildSTORKResponse(destination, inResponseTo, issuer, status, assertion);
    }

    public static STORKResponse buildSTORKErrorResponse(String destination, String inResponseTo, String issuerString, String statusCode, String statusMessage) {
        return STORKMessagesBuilder.buildSTORKResponse(destination, inResponseTo, issuerString, statusCode, statusMessage, null);
    }

    public static Status buildStatus(String statusCodeValue, String statusMessageValue) {
        return STORKMessagesBuilder.buildStatus(statusCodeValue, statusMessageValue, null);
    }

    public static Status buildStatus(String statusCodeValue, String statusMessageValue, XMLObject detail) {
        StatusCode statusCode = (StatusCode)STORKMessagesBuilder.buildXMLObject(StatusCode.DEFAULT_ELEMENT_NAME);
        statusCode.setValue(statusCodeValue);
        StatusMessage statusMessage = (StatusMessage)STORKMessagesBuilder.buildXMLObject(StatusMessage.DEFAULT_ELEMENT_NAME);
        statusMessage.setMessage(statusMessageValue);
        StatusDetail statusDetail = (StatusDetail)STORKMessagesBuilder.buildXMLObject(StatusDetail.DEFAULT_ELEMENT_NAME);
        statusDetail.getUnknownXMLObjects().add(detail);
        Status status = (Status)STORKMessagesBuilder.buildXMLObject(Status.DEFAULT_ELEMENT_NAME);
        status.setStatusCode(statusCode);
        status.setStatusMessage(statusMessage);
        return status;
    }

    public static Assertion buildAssertion(Issuer issuer, Subject subject, Conditions conditions, AuthnStatement authnStatement, AttributeStatement attributeStatement) {
        Assertion assertion = (Assertion)STORKMessagesBuilder.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID(STORKMessagesBuilder.generateID());
        assertion.setVersion(SAMLVersion.VERSION_20);
        assertion.setIssueInstant(new DateTime());
        assertion.setIssuer(issuer);
        assertion.setSubject(subject);
        assertion.setConditions(conditions);
        assertion.getAuthnStatements().add(authnStatement);
        assertion.getAttributeStatements().add(attributeStatement);
        return assertion;
    }

    public static Assertion buildAssertion(String issuerValue, String nameQualifier, String spNameQualifier, String spProviderID, String ipAddress, String inResponseTo, DateTime notBefore, DateTime notOnOrAfter, String recipient, List<Attribute> attributeList) {
        Issuer issuer = STORKMessagesBuilder.buildIssuer(issuerValue);
        NameID nameID = STORKMessagesBuilder.buildNameID("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", nameQualifier, spNameQualifier, spProviderID, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        SubjectConfirmationData scData = STORKMessagesBuilder.buildSubjectConfirmationData(ipAddress, inResponseTo, notOnOrAfter, recipient);
        SubjectConfirmation subjectConfirmation = STORKMessagesBuilder.buildSubjectConfirmation("urn:oasis:names:tc:SAML:2.0:cm:bearer", scData);
        Subject subject = STORKMessagesBuilder.buildSubject(nameID, subjectConfirmation);
        List<Audience> audienceList = STORKMessagesBuilder.buildAudienceList(recipient);
        Conditions conditions = STORKMessagesBuilder.buildConditions(notBefore, notOnOrAfter, audienceList);
        AuthnStatement authnStatement = STORKMessagesBuilder.buildAuthnStatement(ipAddress);
        AttributeStatement attributeStatement = STORKMessagesBuilder.buildAttributeStatement(attributeList);
        return STORKMessagesBuilder.buildAssertion(issuer, subject, conditions, authnStatement, attributeStatement);
    }

    public static List<Audience> buildAudienceList(String ... audiences) {
        ArrayList<Audience> audienceList = new ArrayList<Audience>();
        for (String audienceString : audiences) {
            Audience audience = (Audience)STORKMessagesBuilder.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
            audience.setAudienceURI(audienceString);
            audienceList.add(audience);
        }
        return audienceList;
    }

    public static NameID buildNameID(String format, String nameQualifier, String spNameQualifier, String spProviderID, String value) {
        NameID nameID = (NameID)STORKMessagesBuilder.buildXMLObject(NameID.DEFAULT_ELEMENT_NAME);
        nameID.setFormat(format);
        nameID.setNameQualifier(nameQualifier);
        nameID.setSPNameQualifier(spNameQualifier);
        nameID.setSPProvidedID(spProviderID);
        nameID.setValue(value);
        return nameID;
    }

    public static SubjectConfirmation buildSubjectConfirmation(String method, SubjectConfirmationData scData) {
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)STORKMessagesBuilder.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod(method);
        subjectConfirmation.setSubjectConfirmationData(scData);
        return subjectConfirmation;
    }

    public static SubjectConfirmationData buildSubjectConfirmationData(String ipAddress, String inResponseTo, DateTime notOnOrAfter, String recipient) {
        SubjectConfirmationData scData = (SubjectConfirmationData)STORKMessagesBuilder.buildXMLObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        scData.setAddress(ipAddress);
        scData.setInResponseTo(inResponseTo);
        scData.setNotOnOrAfter(notOnOrAfter);
        scData.setRecipient(recipient);
        return scData;
    }

    public static Subject buildSubject(NameID nameID, SubjectConfirmation subjectConfirmation) {
        Subject subject = (Subject)STORKMessagesBuilder.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        subject.setNameID(nameID);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    public static Conditions buildConditions(DateTime notBefore, DateTime notOnOrAfter, List<Audience> audienceList) {
        Conditions conditions = (Conditions)STORKMessagesBuilder.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notOnOrAfter);
        AudienceRestriction audienceRestriction = (AudienceRestriction)STORKMessagesBuilder.buildXMLObject(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        audienceRestriction.getAudiences().addAll(audienceList);
        conditions.getAudienceRestrictions().add(audienceRestriction);
        OneTimeUse oneTimeUse = (OneTimeUse)STORKMessagesBuilder.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME);
        conditions.getConditions().add(oneTimeUse);
        return conditions;
    }

    public static AuthnStatement buildAuthnStatement(DateTime authInstant, SubjectLocality subjectLocality, AuthnContext authnContext) {
        AuthnStatement authnStatement = (AuthnStatement)STORKMessagesBuilder.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnInstant(authInstant);
        authnStatement.setSubjectLocality(subjectLocality);
        authnStatement.setAuthnContext(authnContext);
        return authnStatement;
    }

    public static AuthnStatement buildAuthnStatement(String ipAddress) {
        AuthnStatement authnStatement = (AuthnStatement)STORKMessagesBuilder.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnInstant(new DateTime());
        SubjectLocality subjectLocality = (SubjectLocality)STORKMessagesBuilder.buildXMLObject(SubjectLocality.DEFAULT_ELEMENT_NAME);
        subjectLocality.setAddress(ipAddress);
        authnStatement.setSubjectLocality(subjectLocality);
        AuthnContext authnContext = (AuthnContext)STORKMessagesBuilder.buildXMLObject(AuthnContext.DEFAULT_ELEMENT_NAME);
        authnStatement.setAuthnContext(authnContext);
        return authnStatement;
    }

    public static AttributeStatement buildAttributeStatement() {
        return (AttributeStatement)STORKMessagesBuilder.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
    }

    public static AttributeStatement buildAttributeStatement(List<Attribute> attributeList) {
        AttributeStatement attributeStatement = (AttributeStatement)STORKMessagesBuilder.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        attributeStatement.getAttributes().addAll(attributeList);
        return attributeStatement;
    }

    public static Attribute buildSTORKStringAttribute(String name, String friendlyName, String value, String status) {
        XSString xsString = STORKMessagesBuilder.buildXSString(AttributeValue.DEFAULT_ELEMENT_NAME);
        xsString.setValue(value);
        return STORKMessagesBuilder.buildAttribute(name, friendlyName, status, (XMLObject)xsString);
    }

    public static Attribute buildSTORKXMLAttribute(String name, String friendlyName, XMLObject value, String status) {
        XSAny xsAny = (XSAny)STORKMessagesBuilder.buildXMLObject(AttributeValue.DEFAULT_ELEMENT_NAME);
        xsAny.getUnknownXMLObjects().add(value);
        return STORKMessagesBuilder.buildAttribute(name, friendlyName, status, (XMLObject)xsAny);
    }

    public static Attribute buildAttribute(String name, String friendlyName, String status, XMLObject attributeValue) {
        Attribute attribute = (Attribute)STORKMessagesBuilder.buildXMLObject(STORKAttribute.DEFAULT_ELEMENT_NAME);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        attribute.setFriendlyName(friendlyName);
        attribute.setName(name);
        attribute.getUnknownAttributes().put(STORKAttribute.DEFAULT_STORK_ATTRIBUTE_QNAME, status);
        attribute.getAttributeValues().add(attributeValue);
        return attribute;
    }

    public static Attribute buildStringAttribute(String name, String friendlyName, String status, String attributeValue) {
        Attribute attribute = (Attribute)STORKMessagesBuilder.buildXMLObject(STORKAttribute.DEFAULT_ELEMENT_NAME);
        attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        attribute.setFriendlyName(friendlyName);
        attribute.setName(name);
        attribute.getUnknownAttributes().put(STORKAttribute.DEFAULT_STORK_ATTRIBUTE_QNAME, status);
        XSString xsString = STORKMessagesBuilder.buildXSString(AttributeValue.DEFAULT_ELEMENT_NAME);
        xsString.setValue(attributeValue);
        attribute.getAttributeValues().add(xsString);
        return attribute;
    }

    public static String buildSignatureRequestString(String textToBeSigned, String mimeType) {
        String sigRequestString = "<dss:SignRequest xmlns:dss=\"urn:oasis:names:tc:dss:1.0:core:schema\" RequestID=\"" + STORKMessagesBuilder.generateID() + "\">" + "<dss:InputDocuments>" + "<dss:Document>" + "<dss:Base64Data MimeType=\"" + mimeType + "\">" + Base64.encodeBytes((byte[])textToBeSigned.getBytes()) + "</dss:Base64Data>" + "</dss:Document>" + "</dss:InputDocuments>" + "</dss:SignRequest>";
        return sigRequestString;
    }

    public static RequestedAttribute buildSignatureRequestRequestedAttribute(String textToBeSigned, String mimeType, boolean isRequired) {
        return STORKMessagesBuilder.buildRequestedAttribute("http://www.stork.gov.eu/1.0/signedDoc", isRequired, STORKMessagesBuilder.buildSignatureRequestString(textToBeSigned, mimeType));
    }

    public static void addRequestedAttribute(STORKAuthnRequest authnRequest, RequestedAttribute reqAttr) {
        if (authnRequest != null) {
            RequestedAttributes requestedAttributes = (RequestedAttributes)authnRequest.getExtensions().getUnknownXMLObjects(RequestedAttributes.DEFAULT_ELEMENT_NAME).get(0);
            requestedAttributes.getRequestedAttributes().add(reqAttr);
        }
    }

    public static void addRequestedAttributes(STORKAuthnRequest authnRequest, RequestedAttribute ... reqAttrs) {
        for (RequestedAttribute reqAttr : reqAttrs) {
            STORKMessagesBuilder.addRequestedAttribute(authnRequest, reqAttr);
        }
    }

    public static void buildAndAddSignatureRequestToAuthnRequest(STORKAuthnRequest authnRequest, String textToBeSigned, String mimeType, boolean isRequired) {
        if (authnRequest != null && !StringUtils.isEmpty((String)textToBeSigned)) {
            STORKMessagesBuilder.addRequestedAttribute(authnRequest, STORKMessagesBuilder.buildSignatureRequestRequestedAttribute(textToBeSigned, mimeType, isRequired));
        }
    }

    public static void addSignatureRequestToAuthnRequest(STORKAuthnRequest authnRequest, String dssSignatureRequest, boolean isRequired) {
        if (authnRequest != null && !StringUtils.isEmpty((String)dssSignatureRequest)) {
            STORKMessagesBuilder.addRequestedAttribute(authnRequest, STORKMessagesBuilder.buildRequestedAttribute("http://www.stork.gov.eu/1.0/signedDoc", isRequired, dssSignatureRequest));
        }
    }

    public static void addAttribute(Assertion assertion, Attribute attr) {
        if (assertion != null && !assertion.getAttributeStatements().isEmpty()) {
            ((AttributeStatement)assertion.getAttributeStatements().get(0)).getAttributes().add(attr);
        }
    }

    public static void addAttributes(Assertion assertion, Attribute ... attrs) {
        for (Attribute attr : attrs) {
            STORKMessagesBuilder.addAttribute(assertion, attr);
        }
    }

    public static void addAttribute(STORKResponse response, Attribute ... attrs) {
        if (response != null && !response.getAssertions().isEmpty()) {
            STORKMessagesBuilder.addAttributes((Assertion)response.getAssertions().get(0), attrs);
        }
    }
}

