/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.saml.impl;

import eu.stork.mw.messages.saml.STORKAuthnRequest;
import eu.stork.vidp.messages.saml.STORKExtensions;
import eu.stork.vidp.messages.stork.SPCertEnc;
import eu.stork.vidp.messages.stork.SPCertSig;
import eu.stork.vidp.messages.stork.SPCertType;
import eu.stork.vidp.messages.stork.SPInformation;
import eu.stork.vidp.messages.stork.VIDPAuthenticationAttributes;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.opensaml.saml2.core.impl.AuthnRequestUnmarshaller;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.util.Base64;

public class STORKAuthnRequestUnmarshaller
extends AuthnRequestUnmarshaller {
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        STORKAuthnRequest req = (STORKAuthnRequest)parentSAMLObject;
        if (childSAMLObject instanceof STORKExtensions) {
            VIDPAuthenticationAttributes vidpAuthAttributes;
            STORKExtensions ext = (STORKExtensions)childSAMLObject;
            req.setExtensions(ext);
            if (ext.getQAALevel() != null) {
                req.setQAALevel(ext.getQAALevel().getValue());
            }
            if (ext.getRequestedAttributes() != null) {
                req.setRequestedAttributes(ext.getRequestedAttributes().getRequestedAttributes());
            }
            if (ext.getAuthenticationAttributes() != null && (vidpAuthAttributes = ext.getAuthenticationAttributes().getVIDPAuthenticationAttributes()) != null) {
                SPInformation spInformation;
                if (vidpAuthAttributes.getCitizenCountryCode() != null) {
                    req.setCitizenCountryCode(vidpAuthAttributes.getCitizenCountryCode().getValue());
                }
                if ((spInformation = vidpAuthAttributes.getSPInformation()) != null) {
                    if (spInformation.getSPID() != null) {
                        req.setSPID(spInformation.getSPID().getValue());
                    }
                    if (spInformation.getSPCertSig() != null) {
                        SPCertSig spCertSig = spInformation.getSPCertSig();
                        try {
                            req.setSPCertSig(this.getCertificateFromX509Data(spCertSig));
                        }
                        catch (Exception e) {
                            throw new UnmarshallingException("Error reading SP signing certificate");
                        }
                    }
                    if (spInformation.getSPCertEnc() != null) {
                        SPCertEnc spCertEnc = spInformation.getSPCertEnc();
                        try {
                            req.setSPCertEnc(this.getCertificateFromX509Data(spCertEnc));
                        }
                        catch (Exception e) {
                            throw new UnmarshallingException("Error reading SP encryption certificate");
                        }
                    }
                    if (spInformation.getSPAuthRequest() != null) {
                        req.setOriginalSPAuthRequest((XMLObject)spInformation.getSPAuthRequest());
                    }
                }
            }
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    private java.security.cert.X509Certificate getCertificateFromX509Data(SPCertType spCert) throws CertificateException {
        X509Certificate samlX509Cert;
        X509Data samlX509Data;
        if (spCert.getKeyInfo() != null && !spCert.getKeyInfo().getX509Datas().isEmpty() && (samlX509Data = (X509Data)spCert.getKeyInfo().getX509Datas().get(0)) != null && !samlX509Data.getX509Certificates().isEmpty() && (samlX509Cert = (X509Certificate)samlX509Data.getX509Certificates().get(0)) != null && samlX509Cert.getValue() != null && samlX509Cert.getValue().length() != 0) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(Base64.decode((String)samlX509Cert.getValue()));
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(inStream);
            return cert;
        }
        return null;
    }
}

