/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.util;

import eu.stork.vidp.messages.builder.STORKMessagesBuilder;
import eu.stork.vidp.messages.exception.SAMLException;
import eu.stork.vidp.messages.exception.SAMLValidationException;
import eu.stork.vidp.messages.saml.STORKAttribute;
import java.util.ArrayList;
import java.util.List;
import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.ValidatorSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SAMLUtil {
    private static final Logger log = LoggerFactory.getLogger(SAMLUtil.class);

    public static void signSAMLObject(SignableSAMLObject samlObject, Credential signingCredential) throws SAMLException {
        log.trace("Signing " + samlObject.getElementQName());
        Signature signature = (Signature)STORKMessagesBuilder.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(signingCredential);
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            SecurityHelper.prepareSignatureParams((Signature)signature, (Credential)signingCredential, null, null);
        }
        catch (SecurityException e) {
            throw new SAMLException("Error preparing signature for signing", e);
        }
        samlObject.setSignature(signature);
        Marshaller assertionMarshaller = Configuration.getMarshallerFactory().getMarshaller((XMLObject)samlObject);
        try {
            assertionMarshaller.marshall((XMLObject)samlObject);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException e) {
            throw new SAMLException("Unable to marshall " + samlObject.getElementQName() + " for signing", e);
        }
        catch (SignatureException e) {
            throw new SAMLException("Unable to sign " + samlObject.getElementQName(), e);
        }
    }

    public static void verifySAMLObjectStandardValidation(SignableSAMLObject samlObject, String validatorSuiteConfig) throws SAMLValidationException {
        ValidatorSuite validatorSuite = Configuration.getValidatorSuite((String)validatorSuiteConfig);
        try {
            validatorSuite.validate((XMLObject)samlObject);
        }
        catch (ValidationException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SAMLValidationException("Could not validate " + samlObject.getElementQName(), (Exception)((Object)e));
        }
    }

    public static String getStatusFromAttribute(Attribute attribute) {
        return attribute.getUnknownAttributes().get((Object)STORKAttribute.DEFAULT_STORK_ATTRIBUTE_QNAME);
    }

    public static String getStringValueFromXMLObject(XMLObject xmlObj) {
        if (xmlObj instanceof XSString) {
            return ((XSString)xmlObj).getValue();
        }
        if (xmlObj instanceof XSAny) {
            return ((XSAny)xmlObj).getTextContent();
        }
        return null;
    }

    public static String getAttributeStringValue(List<? extends Attribute> attrList, String name) {
        XMLObject xmlObj = SAMLUtil.getAttributeValue(attrList, name);
        return SAMLUtil.getStringValueFromXMLObject(xmlObj);
    }

    public static String getAttributeStringValue(Attribute attribute) {
        return ((XSString)attribute.getAttributeValues().get(0)).getValue();
    }

    public static XSAny getAttributeXSAnyValue(Attribute attribute) {
        return (XSAny)attribute.getAttributeValues().get(0);
    }

    public static XSAny getXSAnyAttributeValue(List<Attribute> attrList, String name) {
        return (XSAny)SAMLUtil.getAttributeValue(attrList, name);
    }

    public static XMLObject getAttributeValue(List<? extends Attribute> attrList, String name) {
        Attribute attribute = SAMLUtil.getAttribute(attrList, name);
        return attribute != null && !attribute.getAttributeValues().isEmpty() ? (XMLObject)attribute.getAttributeValues().get(0) : null;
    }

    public static Attribute getAttribute(List<? extends Attribute> attrList, String name) {
        for (Attribute attribute : attrList) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public static String getAttributeStringValueAndRemove(List<? extends Attribute> attrList, String name) {
        Attribute attribute = SAMLUtil.getAttribute(attrList, name);
        String value = SAMLUtil.getAttributeStringValue(attrList, name);
        attrList.remove(attribute);
        return value;
    }

    public static boolean containsAttribute(Assertion storkAssertion, String attributeName) {
        AttributeStatement attrStatement = (AttributeStatement)storkAssertion.getAttributeStatements().get(0);
        for (Attribute attribute : attrStatement.getAttributes()) {
            if (!attribute.getName().equals(attributeName) || SAMLUtil.getStatusFromAttribute(attribute) != null && !SAMLUtil.getStatusFromAttribute(attribute).equals("Available")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAttribute(List<? extends Attribute> attributeList, String attributeName) {
        for (Attribute attribute : attributeList) {
            if (!attribute.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public static void removeAttribute(List<? extends Attribute> attributeList, String attributeName) {
        if (SAMLUtil.containsAttribute(attributeList, attributeName)) {
            attributeList.remove(SAMLUtil.getAttribute(attributeList, attributeName));
        }
    }

    public static String getXSStringValueFromXMLObject(XMLObject xmlObj) {
        if (xmlObj instanceof XSString) {
            return ((XSString)xmlObj).getValue();
        }
        return null;
    }

    public static Element marshallMessage(XMLObject message) {
        try {
            Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(message);
            if (marshaller == null) {
                log.error("Unable to marshall message, no marshaller registered for message object: " + message.getElementQName());
            }
            Element messageElem = marshaller.marshall(message);
            return messageElem;
        }
        catch (MarshallingException e) {
            log.error("Encountered error marshalling message to its DOM representation", (Throwable)e);
            throw new RuntimeException("Encountered error marshalling message into its DOM representation", e);
        }
    }

    public static XMLObject unmarshallMessage(Element element) throws MessageEncodingException {
        try {
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(element);
            if (unmarshaller == null) {
                log.error("Unable to unmarshall element, no unmarshaller registered for message element: " + element.getNodeName());
            }
            return unmarshaller.unmarshall(element);
        }
        catch (UnmarshallingException e) {
            log.error("Encountered error unmarshalling element to its XMLObject representation", (Throwable)e);
            throw new MessageEncodingException("Encountered error unmarshalling element to its XMLObject representation", (Exception)((Object)e));
        }
    }

    public static List<? extends XMLObject> releaseDOM(List<? extends XMLObject> xmlObjList) {
        ArrayList<XMLObject> newXMLObjList = new ArrayList<XMLObject>();
        for (XMLObject xMLObject : xmlObjList) {
            xMLObject.detach();
            newXMLObjList.add(xMLObject);
        }
        return newXMLObjList;
    }

    public static List<RequestedAttribute> buildRequestedAttributesUnion(List<RequestedAttribute> priorityList, List<RequestedAttribute> list) {
        ArrayList<RequestedAttribute> reqAttrList = new ArrayList<RequestedAttribute>();
        if (priorityList == null || list == null) {
            return reqAttrList;
        }
        if (priorityList == null || priorityList.isEmpty()) {
            if (list == null || list.isEmpty()) {
                return reqAttrList;
            }
            reqAttrList.addAll(SAMLUtil.releaseDOM(list));
            return reqAttrList;
        }
        if (list == null || list.isEmpty()) {
            reqAttrList.addAll(SAMLUtil.releaseDOM(priorityList));
            return reqAttrList;
        }
        reqAttrList.addAll(SAMLUtil.releaseDOM(priorityList));
        for (RequestedAttribute reqAttr : list) {
            boolean found = false;
            for (RequestedAttribute prioReqAttr : priorityList) {
                if (prioReqAttr.getName().equals(reqAttr.getName())) continue;
                found = true;
            }
            if (found) continue;
            reqAttr.detach();
            reqAttrList.add(reqAttr);
            log.debug("Adding additional requested attribute: {} , isRequired: {}", (Object)reqAttr.getName(), (Object)reqAttr.isRequired());
        }
        return reqAttrList;
    }

    public static void validateSignatureReferences(SignableSAMLObject signableObject) throws ValidationException {
        SAMLSignatureProfileValidator sigValidator = new SAMLSignatureProfileValidator();
        sigValidator.validate(signableObject.getSignature());
    }
}

