/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static Element stringToDOM(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        StringReader reader = new StringReader(xmlString);
        InputSource src = new InputSource(reader);
        Document domDoc = builder.parse(src);
        return domDoc.getDocumentElement();
    }

    public static Document createNewDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        return builder.newDocument();
    }

    public static String printXML(Node node) {
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            Transformer serializer = tfactory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("encoding", "UTF-8");
            StringWriter output = new StringWriter();
            serializer.transform(new DOMSource(node), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeXmlFile(Element doc, String filename) {
        try {
            DOMSource source = new DOMSource(doc);
            File file = new File(filename);
            StreamResult result = new StreamResult(file);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getFirstTextValueFromNodeList(NodeList nList) {
        if (nList != null && nList.getLength() != 0) {
            return nList.item(0).getTextContent();
        }
        return null;
    }

    public static Element getFirstElement(Node parent) {
        Node n;
        for (n = parent.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        if (n == null) {
            return null;
        }
        return (Element)n;
    }
}

