/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.validator.AssertionSchemaValidator;
import org.opensaml.xml.validation.ValidationException;

public class StorkAssertionValidator
extends AssertionSchemaValidator {
    public void validate(Assertion assertion) throws ValidationException {
        super.validate(assertion);
        if (assertion.getID() == null) {
            throw new ValidationException("ID is required.");
        }
        if (assertion.getVersion() == null || !assertion.getVersion().equals(SAMLVersion.VERSION_20)) {
            throw new ValidationException("Version of assertion not present or invalid.");
        }
        if (assertion.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant is required.");
        }
        if (assertion.getSubject() == null) {
            throw new ValidationException("Subject is required.");
        }
        if (assertion.getConditions() == null) {
            throw new ValidationException("Conditions is required.");
        }
        if (assertion.getAuthnStatements() == null || assertion.getAuthnStatements().size() != 1) {
            throw new ValidationException("Incorrect number of AuthnStatements.");
        }
        if (assertion.getAttributeStatements() != null && assertion.getAttributeStatements().size() != 0 && assertion.getAttributeStatements().size() != 1) {
            throw new ValidationException("Incorrect number of AttributeStatements.");
        }
    }
}

