/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import eu.stork.vidp.messages.saml.STORKAttribute;
import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.validator.AttributeSchemaValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.util.AttributeMap;
import org.opensaml.xml.validation.ValidationException;

public class StorkAttributeValidator
extends AttributeSchemaValidator {
    private static final String PATTERN_EIDENTIFIER = "^[A-Z]{2}/[A-Z]{2}/[A-Za-z0-9+/=\r\n]+$";
    private static final String PATTERN_GENDER = "^[MF]{1}$";
    private static final String PATTERN_COUNTRYCODEOFBIRTH = "^[A-Z]{2}|[A-Z]{4}$";
    private static final String PATTERN_COUNTRYCODE = "^[A-Z]{2}$";
    private static final String PATTERN_MARTIALSTATUS = "^[SMPDW]{1}$";
    private static final String PATTERN_EMAIL = "^[-+.\\w]{1,64}@[-.\\w]{1,64}\\.[-.\\w]{2,6}$";
    private static final String PATTERN_AGE = "^[0-9]{1,3}$";
    private static final int MAX_AGE = 120;
    private static final String PATTERN_ISAGEOVER = "^[0-9]{1,3}$";
    private static final String PATTERN_CITIZENQAALEVEL = "^[1-4]{1}$";

    public void validate(Attribute attr) throws ValidationException {
        String value;
        super.validate(attr);
        if (attr.getName() == null) {
            throw new ValidationException("Name is required.");
        }
        if (attr.getNameFormat() == null) {
            throw new ValidationException("NameFormat is required.");
        }
        if (attr.getUnknownAttributes() != null) {
            AttributeMap map = attr.getUnknownAttributes();
            value = map.get((Object)STORKAttribute.DEFAULT_STORK_ATTRIBUTE_QNAME);
            if (value == null || value.equals("Available")) {
                if (attr.getAttributeValues().isEmpty() && !attr.getName().equals("http://www.stork.gov.eu/1.0/isAgeOver")) {
                    throw new ValidationException("AttributeStatus indicates that attribute is available but no AttributeValue is present.");
                }
            } else if (!(value.equals("Available") || value.equals("NotAvailable") || value.equals("Withheld"))) {
                throw new ValidationException("AttributeStatus is invalid.");
            }
        }
        if (!attr.getAttributeValues().isEmpty()) {
            XMLObject attrValueObject = (XMLObject)attr.getAttributeValues().get(0);
            if (!(attrValueObject instanceof XSString)) {
                return;
            }
            value = ((XSString)attr.getAttributeValues().get(0)).getValue();
            String attrName = attr.getName();
            if (value == null) {
                if (attrName.equals("http://www.stork.gov.eu/1.0/isAgeOver")) {
                    return;
                }
                throw new ValidationException("Provided AttributeValue is empty");
            }
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/eIdentifier", PATTERN_EIDENTIFIER);
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/gender", PATTERN_GENDER);
            if (attrName.equals("http://www.stork.gov.eu/1.0/dateOfBirth")) {
                StorkAttributeValidator.verifyDate(value);
            }
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/countryCodeOfBirth", PATTERN_COUNTRYCODEOFBIRTH);
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/nationalityCode", PATTERN_COUNTRYCODE);
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/maritalStatus", PATTERN_MARTIALSTATUS);
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/eMail", PATTERN_EMAIL);
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/age", "^[0-9]{1,3}$");
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/isAgeOver", "^[0-9]{1,3}$");
            if ((attr.getName().equals("http://www.stork.gov.eu/1.0/age") || attr.getName().equals("http://www.stork.gov.eu/1.0/isAgeOver")) && Integer.valueOf(((XSString)attr.getAttributeValues().get(0)).getValue()) > 120) {
                throw new ValidationException("Maximum age reached");
            }
            this.validateAttributeValueFormat(value, attrName, "http://www.stork.gov.eu/1.0/citizenQAALevel", PATTERN_CITIZENQAALEVEL);
        }
    }

    private void validateAttributeValueFormat(String value, String currentAttrName, String attrNameToTest, String pattern) throws ValidationException {
        if (currentAttrName.equals(attrNameToTest) && !Pattern.matches(pattern, value)) {
            throw new ValidationException(attrNameToTest + " has incorrect format.");
        }
    }

    private static void verifyDate(String pepsDate) throws ValidationException {
        DateTimeFormatter fmt = null;
        switch (pepsDate.length()) {
            case 4: {
                fmt = DateTimeFormat.forPattern((String)"yyyy");
                break;
            }
            case 6: {
                fmt = DateTimeFormat.forPattern((String)"yyyyMM");
                break;
            }
            case 8: {
                fmt = DateTimeFormat.forPattern((String)"yyyyMMdd");
                break;
            }
            default: {
                throw new ValidationException("Date has wrong format");
            }
        }
        try {
            fmt.parseDateTime(pepsDate);
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException("Date has wrong format");
        }
    }
}

