/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import eu.stork.mw.messages.saml.STORKAuthnRequest;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.validator.AuthnRequestSchemaValidator;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Node;

public class StorkAuthnRequestValidator
extends AuthnRequestSchemaValidator {
    private static final String ALLOWED_CONSENT = "urn:oasis:names:tc:SAML:2.0:consent:unspecified";
    private static final String ALLOWED_PROTOCOL_BINDING_1 = "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST";
    private static final String ALLOWED_PROTOCOL_BINDING_2 = "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
    private static final int MAX_SIZE = 131072;

    public void validate(AuthnRequest req) throws ValidationException {
        if (XMLHelper.prettyPrintXML((Node)req.getDOM()).getBytes().length > 131072) {
            throw new ValidationException("SAML AuthnRequest exceeds max size.");
        }
        super.validate(req);
        STORKAuthnRequest request = (STORKAuthnRequest)req;
        if (request.getID() == null) {
            throw new ValidationException("ID is required.");
        }
        if (request.getVersion() == null) {
            throw new ValidationException("Version is required.");
        }
        if (!request.getVersion().equals(SAMLVersion.VERSION_20)) {
            throw new ValidationException("Version is invalid.");
        }
        if (request.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant is required.");
        }
        if (request.getConsent() != null && !request.getConsent().equals(ALLOWED_CONSENT)) {
            throw new ValidationException("Consent is invalid.");
        }
        if (request.isForceAuthn() == null) {
            throw new ValidationException("ForceAuthn is required.");
        }
        if (!request.isForceAuthn().booleanValue()) {
            throw new ValidationException("ForceAuthn is invalid.");
        }
        if (request.isPassive() == null) {
            throw new ValidationException("IsPassive is required.");
        }
        if (request.isPassive().booleanValue()) {
            throw new ValidationException("IsPassive is invalid.");
        }
        if (request.getProtocolBinding() == null) {
            throw new ValidationException("ProtocolBinding is required.");
        }
        if (!request.getProtocolBinding().equals(ALLOWED_PROTOCOL_BINDING_1) && !request.getProtocolBinding().equals(ALLOWED_PROTOCOL_BINDING_2)) {
            throw new ValidationException("ProtocolBinding is invalid.");
        }
        if (request.getAssertionConsumerServiceURL() == null) {
            throw new ValidationException("AssertionConsumerServiceURL is required.");
        }
        if (request.getProviderName() == null) {
            throw new ValidationException("ProviderName is required.");
        }
    }
}

