/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import eu.stork.vidp.messages.common.STORKConstants;
import java.util.regex.Pattern;
import org.opensaml.saml2.metadata.RequestedAttribute;
import org.opensaml.saml2.metadata.validator.RequestedAttributeSchemaValidator;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.validation.ValidationException;

public class StorkRequestedAttributeValidator
extends RequestedAttributeSchemaValidator {
    private static final String PATTERN_ISAGEOVER = "^[0-9]{1,3}$";

    public void validate(RequestedAttribute attr) throws ValidationException {
        super.validate(attr);
        if (attr.getName() == null) {
            throw new ValidationException("Name is required.");
        }
        if (attr.getNameFormat() == null) {
            throw new ValidationException("NameFormat is required.");
        }
        if (!STORKConstants.FULL_STORK_ATTRIBUTE_SET.contains(attr.getName()) && attr.isRequired().booleanValue()) {
            throw new ValidationException("Unknown attribute " + attr.getName() + " requested mandatory.");
        }
        if (attr.getName().equals("http://www.stork.gov.eu/1.0/isAgeOver")) {
            if (attr.getAttributeValues().isEmpty()) {
                throw new ValidationException("isAgeOver requires attribute value");
            }
            XMLObject attrValueObject = (XMLObject)attr.getAttributeValues().get(0);
            if (attrValueObject instanceof XSString) {
                if (!Pattern.matches(PATTERN_ISAGEOVER, ((XSString)attr.getAttributeValues().get(0)).getValue())) {
                    throw new ValidationException("Value for isAgeOver has incorrect format.");
                }
            } else if (attrValueObject instanceof XSAny) {
                if (!Pattern.matches(PATTERN_ISAGEOVER, ((XSAny)attrValueObject).getTextContent())) {
                    throw new ValidationException("Value for isAgeOver has incorrect format.");
                }
            } else {
                throw new ValidationException("Value for isAgeOver has incorrect format.");
            }
        }
    }
}

