/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import eu.stork.mw.messages.saml.STORKResponse;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.StatusCode;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.validator.ResponseSchemaValidator;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Node;

public class StorkResponseValidator
extends ResponseSchemaValidator {
    private static final String CONSENT_ALLOWED_VALUE_1 = "urn:oasis:names:tc:SAML:2.0:consent:obtained";
    private static final String CONSENT_ALLOWED_VALUE_2 = "urn:oasis:names:tc:SAML:2.0:consent:prior";
    private static final String CONSENT_ALLOWED_VALUE_3 = "urn:oasis:names:tc:SAML:2.0:consent:curent-implicit";
    private static final String CONSENT_ALLOWED_VALUE_4 = "urn:oasis:names:tc:SAML:2.0:consent:curent-explicit";
    private static final String CONSENT_ALLOWED_VALUE_5 = "urn:oasis:names:tc:SAML:2.0:consent:unspecified";
    private static final int MAX_SIZE = 131072;

    public void validate(Response response) throws ValidationException {
        String consent;
        if (XMLHelper.prettyPrintXML((Node)response.getDOM()).getBytes().length > 131072) {
            throw new ValidationException("SAML Response exceeds max size.");
        }
        super.validate(response);
        STORKResponse resp = (STORKResponse)response;
        if (resp.getID() == null) {
            throw new ValidationException("ID is required");
        }
        if (resp.getInResponseTo() == null) {
            throw new ValidationException("InResponseTo is required");
        }
        if (resp.getVersion() == null) {
            throw new ValidationException("Version is required.");
        }
        if (!resp.getVersion().equals(SAMLVersion.VERSION_20)) {
            throw new ValidationException("Version is invalid.");
        }
        if (resp.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant is required");
        }
        if (resp.getDestination() == null) {
            throw new ValidationException("Destination is required");
        }
        if (!(resp.getConsent() == null || (consent = resp.getConsent()).equals(CONSENT_ALLOWED_VALUE_1) || consent.equals(CONSENT_ALLOWED_VALUE_2) || consent.equals(CONSENT_ALLOWED_VALUE_3) || consent.equals(CONSENT_ALLOWED_VALUE_4) || consent.equals(CONSENT_ALLOWED_VALUE_5))) {
            throw new ValidationException("Consent is invalid.");
        }
        if (resp.getIssuer() == null) {
            throw new ValidationException("Issuer is required.");
        }
        if (resp.getStatus() == null) {
            throw new ValidationException("Status is required.");
        }
        if (resp.getSignature() == null) {
            throw new ValidationException("Signature is required.");
        }
        if (resp.getStatus().getStatusCode().getValue().equals(StatusCode.SUCCESS) && (resp.getAssertions() == null || resp.getAssertions().size() == 0)) {
            throw new ValidationException("Assertion is required");
        }
    }
}

