/*
 * Decompiled with CFR 0.152.
 */
package eu.stork.vidp.messages.validation;

import org.opensaml.saml2.core.Status;
import org.opensaml.saml2.core.StatusCode;
import org.opensaml.saml2.core.validator.StatusCodeSchemaValidator;
import org.opensaml.xml.validation.ValidationException;

public class StorkStatusCodeValidator
extends StatusCodeSchemaValidator {
    private static String[] ALLOWED_FIRST_LEVEL_STATUS_CODE_VALUES = new String[]{"urn:oasis:names:tc:SAML:2.0:status:Success", "urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch"};
    private static String[] ALLOWED_SECOND_LEVEL_STATUS_CODE_VALUES = new String[]{"urn:oasis:names:tc:SAML:2.0:status:AuthnFailed", "urn:oasis:names:tc:SAML:2.0:status:InvalidAttrNameOrValue", "urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", "urn:oasis:names:tc:SAML:2.0:status:NoAuthnContext", "urn:oasis:names:tc:SAML:2.0:status:NoAvailableIDP", "urn:oasis:names:tc:SAML:2.0:status:NoPassive", "urn:oasis:names:tc:SAML:2.0:status:NoSupportedIDP", "urn:oasis:names:tc:SAML:2.0:status:PartialLogout", "urn:oasis:names:tc:SAML:2.0:status:ProxyCountExceeded", "urn:oasis:names:tc:SAML:2.0:status:RequestDenied", "urn:oasis:names:tc:SAML:2.0:status:RequestUnsupported", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionDeprecated", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooHigh", "urn:oasis:names:tc:SAML:2.0:status:RequestVersionTooLow", "urn:oasis:names:tc:SAML:2.0:status:ResourceNotRecognized", "urn:oasis:names:tc:SAML:2.0:status:TooManyResponses", "urn:oasis:names:tc:SAML:2.0:status:UnknownAttrProfile", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", "urn:oasis:names:tc:SAML:2.0:status:UnsupportedBinding", "http://www.stork.gov.eu/saml20/statusCodes/QAANotSupported"};

    public void validate(StatusCode statusCode) throws ValidationException {
        super.validate(statusCode);
        if (statusCode.getValue() == null) {
            throw new ValidationException("StatusCode is required");
        }
        boolean valid = false;
        if (statusCode.getParent() instanceof Status) {
            String value = statusCode.getValue();
            for (String allowedVal : ALLOWED_FIRST_LEVEL_STATUS_CODE_VALUES) {
                if (!value.equals(allowedVal)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new ValidationException("First Level StatusCode has an invalid value.");
            }
        } else if (statusCode != null) {
            valid = false;
            String subVal = statusCode.getValue();
            for (String allowedVal : ALLOWED_SECOND_LEVEL_STATUS_CODE_VALUES) {
                if (!subVal.equals(allowedVal)) continue;
                valid = true;
                break;
            }
            if (!valid) {
                throw new ValidationException("Second Level StatusCode has an invalid value.");
            }
        }
    }
}

