package edu.internet2.middleware.grouperClient.ws.beans;


/**
 * <pre>
 * results for the get members call.
 * 
 * result code:
 * code of the result for this group overall
 * SUCCESS: means everything ok
 * GROUP_NOT_FOUND: cant find the group
 * INVALID_QUERY: bad inputs
 * EXCEPTION: something bad happened
 * </pre>
 * @author mchyzer
 */
public class WsGetMembersResult implements ResultMetadataHolder{

  /** group that we are checking */
  private WsGroup wsGroup;

  /**
   * results for each assignment sent in
   */
  private WsSubject[] wsSubjects;

  /**
   * results for each assignment sent in
   * @return the results
   */
  public WsSubject[] getWsSubjects() {
    return this.wsSubjects;
  }

  /**
   * results for each assignment sent in
   * @param results1 the results to set
   */
  public void setWsSubjects(WsSubject[] results1) {
    this.wsSubjects = results1;
  }

  /**
   * @return the wsGroup
   */
  public WsGroup getWsGroup() {
    return this.wsGroup;
  }

  /**
   * @param wsGroup1 the wsGroup to set
   */
  public void setWsGroup(WsGroup wsGroup1) {
    this.wsGroup = wsGroup1;
  }

  /**
   * metadata about the result
   */
  private WsResultMeta resultMetadata = new WsResultMeta();

  /**
   * @return the resultMetadata
   */
  public WsResultMeta getResultMetadata() {
    return this.resultMetadata;
  }

  /**
   * @param resultMetadata1 the resultMetadata to set
   */
  public void setResultMetadata(WsResultMeta resultMetadata1) {
    this.resultMetadata = resultMetadata1;
  }

}
