/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GcTransactionType;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsDeleteMemberResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestDeleteMemberRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcDeleteMember {
    private String clientVersion;
    private String groupName;
    private String groupUuid;
    private List<WsSubjectLookup> subjectLookups = new ArrayList<WsSubjectLookup>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private String fieldName;
    private GcTransactionType txType;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();

    public GcDeleteMember assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcDeleteMember assignGroupName(String theGroupName) {
        this.groupName = theGroupName;
        return this;
    }

    public GcDeleteMember addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcDeleteMember addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcDeleteMember addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcDeleteMember addSubjectId(String subjectId) {
        this.subjectLookups.add(new WsSubjectLookup(subjectId, null, null));
        return this;
    }

    public GcDeleteMember addSubjectIdentifier(String subjectIdentifier) {
        this.subjectLookups.add(new WsSubjectLookup(null, null, subjectIdentifier));
        return this;
    }

    public GcDeleteMember assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (GrouperClientUtils.isBlank(this.groupName) && GrouperClientUtils.isBlank(this.groupUuid)) {
            throw new RuntimeException("Group name or uuid is required: " + this);
        }
        if (GrouperClientUtils.isNotBlank(this.groupName) && GrouperClientUtils.isNotBlank(this.groupUuid)) {
            throw new RuntimeException("Group name and uuid cannot both be filled in: " + this);
        }
        if (GrouperClientUtils.length(this.subjectLookups) == 0) {
            throw new RuntimeException("Need at least one subject to add to group: " + this);
        }
    }

    public GcDeleteMember assignFieldName(String theFieldName) {
        this.fieldName = theFieldName;
        return this;
    }

    public GcDeleteMember assignTxType(GcTransactionType gcTransactionType) {
        this.txType = gcTransactionType;
        return this;
    }

    public GcDeleteMember addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcDeleteMember assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcDeleteMember assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsDeleteMemberResults execute() {
        this.validate();
        WsDeleteMemberResults wsDeleteMemberResults = null;
        try {
            WsRestDeleteMemberRequest deleteMember = new WsRestDeleteMemberRequest();
            deleteMember.setActAsSubjectLookup(this.actAsSubject);
            deleteMember.setFieldName(this.fieldName);
            deleteMember.setTxType(this.txType == null ? null : this.txType.name());
            if (this.includeGroupDetail != null) {
                deleteMember.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                deleteMember.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            WsGroupLookup wsGroupLookup = new WsGroupLookup();
            wsGroupLookup.setGroupName(this.groupName);
            wsGroupLookup.setUuid(this.groupUuid);
            deleteMember.setWsGroupLookup(wsGroupLookup);
            if (this.subjectAttributeNames.size() > 0) {
                deleteMember.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            WsSubjectLookup[] subjectLookupsResults = GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class);
            deleteMember.setSubjectLookups(subjectLookupsResults);
            if (this.params.size() > 0) {
                deleteMember.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            String urlSuffix = "groups";
            wsDeleteMemberResults = (WsDeleteMemberResults)grouperClientWs.executeService(urlSuffix, deleteMember, "deleteMember", this.clientVersion, false);
            String resultMessage = wsDeleteMemberResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsDeleteMemberResults, wsDeleteMemberResults.getResults(), resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsDeleteMemberResults;
    }

    public GcDeleteMember assignGroupUuid(String theGroupUuid) {
        this.groupUuid = theGroupUuid;
        return this;
    }
}

