/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.api;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.ws.GrouperClientWs;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsAttributeDefNameLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsGetPermissionAssignmentsResults;
import edu.internet2.middleware.grouperClient.ws.beans.WsGroupLookup;
import edu.internet2.middleware.grouperClient.ws.beans.WsParam;
import edu.internet2.middleware.grouperClient.ws.beans.WsPermissionEnvVar;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestGetPermissionAssignmentsRequest;
import edu.internet2.middleware.grouperClient.ws.beans.WsSubjectLookup;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class GcGetPermissionAssignments {
    private boolean immediateOnly;
    private String permissionType;
    private String permissionProcessor;
    private List<WsPermissionEnvVar> permissionEnvVars = new ArrayList<WsPermissionEnvVar>();
    private String enabled;
    private Set<WsSubjectLookup> subjectLookups = new LinkedHashSet<WsSubjectLookup>();
    private String clientVersion;
    private Boolean includeAssignmentsOnAssignments;
    private Timestamp pointInTimeFrom;
    private Timestamp pointInTimeTo;
    private Set<String> actions = new LinkedHashSet<String>();
    private Set<String> roleNames = new LinkedHashSet<String>();
    private Set<String> roleUuids = new LinkedHashSet<String>();
    private List<WsParam> params = new ArrayList<WsParam>();
    private WsSubjectLookup actAsSubject;
    private Boolean includeGroupDetail;
    private Boolean includeSubjectDetail;
    private Set<String> subjectAttributeNames = new LinkedHashSet<String>();
    private Set<String> attributeDefNames = new LinkedHashSet<String>();
    private Set<String> attributeDefUuids = new LinkedHashSet<String>();
    private Set<String> attributeDefNameNames = new LinkedHashSet<String>();
    private Set<String> attributeDefNameUuids = new LinkedHashSet<String>();
    private Boolean includeAttributeAssignments;
    private Boolean includeAttributeDefNames;
    private Boolean includePermissionAssignDetail;

    public GcGetPermissionAssignments assignImmediateOnly(boolean theImmediateOnly) {
        this.immediateOnly = theImmediateOnly;
        return this;
    }

    public GcGetPermissionAssignments assignPermissionType(String thePermissionType) {
        this.permissionType = thePermissionType;
        return this;
    }

    public GcGetPermissionAssignments assignPermissionProcessor(String thePermissionProcessor) {
        this.permissionProcessor = thePermissionProcessor;
        return this;
    }

    public GcGetPermissionAssignments addPermissionEnvVar(WsPermissionEnvVar wsPermissionEnvVar) {
        this.permissionEnvVars.add(wsPermissionEnvVar);
        return this;
    }

    public GcGetPermissionAssignments addPermissionEnvVar(String envVarName, String envVarValue, String envVarType) {
        this.permissionEnvVars.add(new WsPermissionEnvVar(envVarName, envVarValue, envVarType));
        return this;
    }

    public GcGetPermissionAssignments assignPointInTimeFrom(Timestamp pointInTimeFrom) {
        this.pointInTimeFrom = pointInTimeFrom;
        return this;
    }

    public GcGetPermissionAssignments assignPointInTimeTo(Timestamp pointInTimeTo) {
        this.pointInTimeTo = pointInTimeTo;
        return this;
    }

    public GcGetPermissionAssignments assignIncludeAssignmentsOnAssignments(Boolean theIncludeAssignmentsOnAssignments) {
        this.includeAssignmentsOnAssignments = theIncludeAssignmentsOnAssignments;
        return this;
    }

    public GcGetPermissionAssignments addAction(String action) {
        this.actions.add(action);
        return this;
    }

    public GcGetPermissionAssignments assignClientVersion(String theClientVersion) {
        this.clientVersion = theClientVersion;
        return this;
    }

    public GcGetPermissionAssignments addRoleName(String theRoleName) {
        this.roleNames.add(theRoleName);
        return this;
    }

    public GcGetPermissionAssignments addSubjectLookup(WsSubjectLookup wsSubjectLookup) {
        this.subjectLookups.add(wsSubjectLookup);
        return this;
    }

    public GcGetPermissionAssignments addRoleUuid(String theRoleUuid) {
        this.roleUuids.add(theRoleUuid);
        return this;
    }

    public GcGetPermissionAssignments addParam(String paramName, String paramValue) {
        this.params.add(new WsParam(paramName, paramValue));
        return this;
    }

    public GcGetPermissionAssignments addParam(WsParam wsParam) {
        this.params.add(wsParam);
        return this;
    }

    public GcGetPermissionAssignments assignActAsSubject(WsSubjectLookup theActAsSubject) {
        this.actAsSubject = theActAsSubject;
        return this;
    }

    private void validate() {
        if (this.pointInTimeFrom != null || this.pointInTimeTo != null) {
            if (this.includeGroupDetail != null && this.includeGroupDetail.booleanValue()) {
                throw new RuntimeException("Cannot specify includeGroupDetail for point in time queries.");
            }
            if (this.enabled != null && !this.enabled.equals("T")) {
                throw new RuntimeException("Cannot search for disabled memberships for point in time queries.");
            }
        }
    }

    public GcGetPermissionAssignments assignIncludeAttributeAssignments(Boolean theIncludeAttributeAssignments) {
        this.includeAttributeAssignments = theIncludeAttributeAssignments;
        return this;
    }

    public GcGetPermissionAssignments assignIncludeAttributeDefNames(Boolean theIncludeAttributeDefNames) {
        this.includeAttributeDefNames = theIncludeAttributeDefNames;
        return this;
    }

    public GcGetPermissionAssignments assignIncludePermissionAssignDetail(Boolean theIncludePermissionAssignDetail) {
        this.includePermissionAssignDetail = theIncludePermissionAssignDetail;
        return this;
    }

    public GcGetPermissionAssignments addSubjectAttributeName(String subjectAttributeName) {
        this.subjectAttributeNames.add(subjectAttributeName);
        return this;
    }

    public GcGetPermissionAssignments assignIncludeGroupDetail(Boolean theIncludeGroupDetail) {
        this.includeGroupDetail = theIncludeGroupDetail;
        return this;
    }

    public GcGetPermissionAssignments assignIncludeSubjectDetail(Boolean theIncludeSubjectDetail) {
        this.includeSubjectDetail = theIncludeSubjectDetail;
        return this;
    }

    public WsGetPermissionAssignmentsResults execute() {
        this.validate();
        WsGetPermissionAssignmentsResults wsGetPermissionAssignmentsResults = null;
        try {
            WsRestGetPermissionAssignmentsRequest getPermissionAssignments = new WsRestGetPermissionAssignmentsRequest();
            getPermissionAssignments.setActAsSubjectLookup(this.actAsSubject);
            getPermissionAssignments.setEnabled(this.enabled);
            ArrayList<WsAttributeDefLookup> attributeDefLookups = new ArrayList<WsAttributeDefLookup>();
            for (String attributeDefName : this.attributeDefNames) {
                attributeDefLookups.add(new WsAttributeDefLookup(attributeDefName, null));
            }
            for (String attributeDefUuid : this.attributeDefUuids) {
                attributeDefLookups.add(new WsAttributeDefLookup(null, attributeDefUuid));
            }
            if (GrouperClientUtils.length(attributeDefLookups) > 0) {
                getPermissionAssignments.setWsAttributeDefLookups(GrouperClientUtils.toArray(attributeDefLookups, WsAttributeDefLookup.class));
            }
            ArrayList<WsAttributeDefNameLookup> attributeDefNameLookups = new ArrayList<WsAttributeDefNameLookup>();
            for (String attributeDefNameName : this.attributeDefNameNames) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(attributeDefNameName, null));
            }
            for (String attributeDefNameUuid : this.attributeDefNameUuids) {
                attributeDefNameLookups.add(new WsAttributeDefNameLookup(null, attributeDefNameUuid));
            }
            if (GrouperClientUtils.length(attributeDefNameLookups) > 0) {
                getPermissionAssignments.setWsAttributeDefNameLookups(GrouperClientUtils.toArray(attributeDefNameLookups, WsAttributeDefNameLookup.class));
            }
            ArrayList<WsGroupLookup> roleLookups = new ArrayList<WsGroupLookup>();
            for (String ownerGroupName : this.roleNames) {
                roleLookups.add(new WsGroupLookup(ownerGroupName, null));
            }
            for (String ownerGroupUuid : this.roleUuids) {
                roleLookups.add(new WsGroupLookup(null, ownerGroupUuid));
            }
            if (GrouperClientUtils.length(roleLookups) > 0) {
                getPermissionAssignments.setRoleLookups(GrouperClientUtils.toArray(roleLookups, WsGroupLookup.class));
            }
            if (GrouperClientUtils.length(this.subjectLookups) > 0) {
                getPermissionAssignments.setWsSubjectLookups(GrouperClientUtils.toArray(this.subjectLookups, WsSubjectLookup.class));
            }
            if (this.includeAssignmentsOnAssignments != null) {
                getPermissionAssignments.setIncludeAssignmentsOnAssignments(this.includeAssignmentsOnAssignments != false ? "T" : "F");
            }
            if (this.includeAttributeAssignments != null) {
                getPermissionAssignments.setIncludeAttributeAssignments(this.includeAttributeAssignments != false ? "T" : "F");
            }
            if (this.includeAttributeDefNames != null) {
                getPermissionAssignments.setIncludeAttributeDefNames(this.includeAttributeDefNames != false ? "T" : "F");
            }
            if (this.includeGroupDetail != null) {
                getPermissionAssignments.setIncludeGroupDetail(this.includeGroupDetail != false ? "T" : "F");
            }
            if (this.includePermissionAssignDetail != null) {
                getPermissionAssignments.setIncludePermissionAssignDetail(this.includePermissionAssignDetail != false ? "T" : "F");
            }
            if (this.includeSubjectDetail != null) {
                getPermissionAssignments.setIncludeSubjectDetail(this.includeSubjectDetail != false ? "T" : "F");
            }
            if (this.params.size() > 0) {
                getPermissionAssignments.setParams(GrouperClientUtils.toArray(this.params, WsParam.class));
            }
            if (this.subjectAttributeNames.size() > 0) {
                getPermissionAssignments.setSubjectAttributeNames(GrouperClientUtils.toArray(this.subjectAttributeNames, String.class));
            }
            if (GrouperClientUtils.length(this.actions) > 0) {
                getPermissionAssignments.setActions(GrouperClientUtils.toArray(this.actions, String.class));
            }
            getPermissionAssignments.setPointInTimeFrom(GrouperClientUtils.dateToString(this.pointInTimeFrom));
            getPermissionAssignments.setPointInTimeTo(GrouperClientUtils.dateToString(this.pointInTimeTo));
            if (this.immediateOnly) {
                getPermissionAssignments.setImmediateOnly(this.immediateOnly ? "T" : "F");
            }
            if (!GrouperClientUtils.isBlank(this.permissionType)) {
                getPermissionAssignments.setPermissionType(this.permissionType);
            }
            if (!GrouperClientUtils.isBlank(this.permissionProcessor)) {
                getPermissionAssignments.setPermissionProcessor(this.permissionProcessor);
            }
            if (this.permissionEnvVars.size() > 0) {
                getPermissionAssignments.setLimitEnvVars(GrouperClientUtils.toArray(this.permissionEnvVars, WsPermissionEnvVar.class));
            }
            GrouperClientWs grouperClientWs = new GrouperClientWs();
            wsGetPermissionAssignmentsResults = (WsGetPermissionAssignmentsResults)grouperClientWs.executeService("permissionAssignments", getPermissionAssignments, "getPermissionAssignments", this.clientVersion, true);
            String resultMessage = wsGetPermissionAssignmentsResults.getResultMetadata().getResultMessage();
            grouperClientWs.handleFailure(wsGetPermissionAssignmentsResults, null, resultMessage);
        }
        catch (Exception e) {
            GrouperClientUtils.convertToRuntimeException(e);
        }
        return wsGetPermissionAssignmentsResults;
    }

    public GcGetPermissionAssignments assignEnabled(String theEnabled) {
        this.enabled = theEnabled;
        return this;
    }

    public GcGetPermissionAssignments addAttributeDefName(String theAttributeDefName) {
        this.attributeDefNames.add(theAttributeDefName);
        return this;
    }

    public GcGetPermissionAssignments addAttributeDefUuid(String theAttributeDefUuid) {
        this.attributeDefUuids.add(theAttributeDefUuid);
        return this;
    }

    public GcGetPermissionAssignments addAttributeDefNameName(String theAttributeDefNameName) {
        this.attributeDefNameNames.add(theAttributeDefNameName);
        return this;
    }

    public GcGetPermissionAssignments addAttributeDefNameUuid(String theAttributeDefNameUuid) {
        this.attributeDefNameUuids.add(theAttributeDefNameUuid);
        return this;
    }
}

