/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.examples;

import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapExample {
    public static DirContext context(String url, String user, String pass) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=" + user + ",ou=entities,dc=upenn,dc=edu");
        env.put("java.naming.security.credentials", pass);
        InitialDirContext context = new InitialDirContext(env);
        return context;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("This program runs queries against ldap and web services");
            System.err.println("The system exit code will be 0 for success, and not 0 for failure");
            System.err.println("Output data is printed to stdout, error messages are printed to stderr");
            System.err.println("\npennname to pennid usage: java -jar grouperClient --user=kerberosPrincipal --pass=thePass --operation=pennnameToPennid --pennnameToDecode=pennname");
            System.err.println("  e.g.: java -jar grouperClient --user=penngroups/medley.isc-seo.upenn.edu --pass=xxxxxx --operation=pennnameToPennid --pennnameToDecode=jsmith");
            System.err.println("  output: pennid: 12341234");
            System.err.println("\npennid to pennname usage: java -jar grouperClient --user=kerberosPrincipal --pass=thePass --operation=pennidToPennkey --pennidToDecode=pennid");
            System.err.println("  e.g.: java -jar grouperClient --user=penngroups/medley.isc-seo.upenn.edu --pass=xxxxxx --operation=pennidToPennkey --pennidToDecode=12341234");
            System.err.println("  output: pennname: jsmith");
            System.err.println("\nis in group usage: java -jar grouperClient --user=kerberosPrincipal --pass=thePass --engine=ldap --operation=isInGroup --groupName=groupName --pennnameToCheck=pennkey");
            System.err.println("  e.g.: java -jar grouperClient --user=penngroups/medley.isc-seo.upenn.edu --pass=xxxxxx --engine=ldap --operation=isInGroup --groupName=penn:myfolder:mygroup --pennnameToCheck=jsmith");
            System.err.println("  output: isInGroup: true");
            System.err.println("\ngroup list usage: java -jar grouperClient --user=kerberosPrincipal --pass=thePass --engine=ldap --operation=groupList --groupName=groupName");
            System.err.println("  e.g.: java -jar grouperClient --user=penngroups/medley.isc-seo.upenn.edu --pass=xxxxxx --engine=ldap --operation=groupList --groupName=penn:myfolder:mygroup");
            System.err.println("  output: groupList: jsmith, tsmith, msmith");
            System.err.println("  note: extremely large group lists might not display (e.g. over 20k members)");
            System.exit(1);
        }
        Map<String, String> argMap = GrouperClientUtils.argMap(args);
        HashMap<String, String> argMapNotUsed = new HashMap<String, String>(argMap);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        Properties properties = GrouperClientUtils.propertiesFromResourceName("grouper.client.properties", true, true, GrouperClientUtils.class, null);
        String ldapUrl = GrouperClientUtils.propertiesValue(properties, "grouperClient.ldap.url");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        String user = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "user", true);
        env.put("java.naming.security.principal", "uid=" + user + ",ou=entities,dc=upenn,dc=edu");
        String pass = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "pass", true);
        env.put("java.naming.security.credentials", pass);
        InitialDirContext context = new InitialDirContext(env);
        String operation = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "operation", true);
        if (GrouperClientUtils.equals(operation, "pennnameToPennid")) {
            String pennnameToDecode = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "pennnameToDecode", true);
            String pennid = LdapExample.pennnameToPennid(context, pennnameToDecode);
            System.out.println("pennid: " + GrouperClientUtils.defaultString(pennid));
        } else if (GrouperClientUtils.equals(operation, "pennidToPennname")) {
            String pennidToDecode = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "pennidToDecode", true);
            String pennname = LdapExample.pennidToPennname(context, pennidToDecode);
            System.out.println("pennname: " + GrouperClientUtils.defaultString(pennname));
        } else if (GrouperClientUtils.equals(operation, "isInGroup")) {
            String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", true);
            String pennnameToCheck = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "pennnameToCheck", true);
            boolean isInGroup = LdapExample.isInGroup(context, groupName, pennnameToCheck);
            System.out.println("isInGroup: " + isInGroup);
        } else if (GrouperClientUtils.equals(operation, "groupList")) {
            String groupName = GrouperClientUtils.argMapString(argMap, argMapNotUsed, "groupName", true);
            List<String> results = LdapExample.groupList(context, groupName);
            System.out.print("groupList: ");
            for (int i = 0; i < GrouperClientUtils.length(results); ++i) {
                if (i != 0) {
                    System.out.print(", ");
                }
                System.out.print(results.get(i));
            }
            System.out.println("");
        } else {
            System.err.println("Unexpected operation: '" + operation + "'");
            System.exit(1);
        }
    }

    public static String pennnameToPennid(DirContext context, String pennname) throws Exception {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"pennid"});
        searchControls.setReturningObjFlag(false);
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = context.search("ou=pennnames", "name=" + pennname, searchControls);
        return LdapExample.retrieveAttributeStringValue(namingEnumeration, "pennid");
    }

    public static String pennidToPennname(DirContext context, String pennid) throws Exception {
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"pennname"});
        searchControls.setReturningObjFlag(false);
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration = context.search("ou=pennnames", "pennid=" + pennid, searchControls);
        return LdapExample.retrieveAttributeStringValue(namingEnumeration, "pennname");
    }

    public static boolean isInGroup(DirContext context, String groupName, String pennname) throws NamingException {
        BasicAttributes searchAttributes = new BasicAttributes();
        searchAttributes.put(new BasicAttribute("cn", groupName));
        searchAttributes.put(new BasicAttribute("hasMember", pennname));
        NamingEnumeration<SearchResult> namingEnumeration = context.search("ou=groups", (Attributes)searchAttributes, new String[]{"cn"});
        String cn = LdapExample.retrieveAttributeStringValue(namingEnumeration, "cn");
        boolean isInGroup = GrouperClientUtils.equals(groupName, cn);
        return isInGroup;
    }

    public static List<String> groupList(DirContext context, String groupName) throws NamingException {
        BasicAttributes searchAttributes = new BasicAttributes();
        searchAttributes.put(new BasicAttribute("cn", groupName));
        NamingEnumeration<SearchResult> namingEnumeration = context.search("ou=groups", (Attributes)searchAttributes, new String[]{"hasMember"});
        List<String> members = LdapExample.retrieveAttributeStringListValue(namingEnumeration, "hasMember");
        return members;
    }

    private static void testLdap() throws NamingException, Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldaps://penngroups.upenn.edu/dc=upenn,dc=edu");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", "uid=penngroups/medley.isc-seo.upenn.edu,ou=entities,dc=upenn,dc=edu");
        env.put("java.naming.security.credentials", "xxxxxxxxx");
        InitialDirContext ctx = new InitialDirContext(env);
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(new String[]{"pennid"});
        searchControls.setReturningObjFlag(false);
        searchControls.setSearchScope(1);
        NamingEnumeration<SearchResult> namingEnumeration3 = ctx.search("ou=pennnames", "name=jorj", searchControls);
        LdapExample.printNamingEnumeration(namingEnumeration3);
        System.out.println("Group: ");
        Attributes attributes = ctx.getAttributes("cn=penn:isc:ait:apps:fast:pennCommunity,ou=groups", new String[]{"hasMember"});
        NamingEnumeration<? extends Attribute> namingEnumeration2 = attributes.getAll();
        LdapExample.printNamingEnumeration(namingEnumeration2);
        System.out.println("Group2: ");
        attributes = ctx.getAttributes("cn=penn:isc:ait:apps:fast:pennCommunity,ou=groups");
        namingEnumeration2 = attributes.getAll();
        LdapExample.printNamingEnumeration(namingEnumeration2);
        System.out.println("Group by hasMember: ");
        BasicAttributes searchAttributes = new BasicAttributes();
        searchAttributes.put(new BasicAttribute("cn", "penn:isc:ait:apps:fast:pennCommunity"));
        searchAttributes.put(new BasicAttribute("hasMember", "mchyzer1"));
        NamingEnumeration<SearchResult> namingEnumeration7 = ctx.search("ou=groups", (Attributes)searchAttributes, new String[]{"cn"});
        LdapExample.printNamingEnumeration(namingEnumeration7);
    }

    public static void printAttributes(Attributes attributes) throws NamingException {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        LdapExample.printNamingEnumeration(namingEnumeration);
    }

    public static void printNamingEnumeration(NamingEnumeration namingEnumeration) throws NamingException {
        while (namingEnumeration.hasMore()) {
            Object nextElement = namingEnumeration.next();
            if (nextElement instanceof Attribute) {
                Attribute attribute = (Attribute)nextElement;
                LdapExample.printAttribute(attribute);
                continue;
            }
            if (nextElement instanceof SearchResult) {
                SearchResult searchResult = (SearchResult)nextElement;
                System.out.println("Search result: " + searchResult.getNameInNamespace());
                Attributes attributes = searchResult.getAttributes();
                LdapExample.printAttributes(attributes);
                continue;
            }
            if (nextElement instanceof NameClassPair) {
                NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                System.out.println("Name class pair: " + nameClassPair.getClassName() + ", " + nameClassPair.getNameInNamespace());
                continue;
            }
            throw new RuntimeException("Not expecting type: " + nextElement);
        }
    }

    public static String retrieveAttributeStringValue(Object object, String attributeName) throws NamingException {
        if (object == null) {
            return null;
        }
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            if (GrouperClientUtils.equals(attribute.getID(), attributeName)) {
                return (String)attribute.get();
            }
            return null;
        }
        if (object instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)object;
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute = attributes.get(attributeName);
            return LdapExample.retrieveAttributeStringValue(attribute, attributeName);
        }
        if (object instanceof NamingEnumeration) {
            NamingEnumeration namingEnumeration = (NamingEnumeration)object;
            if (!namingEnumeration.hasMore()) {
                return null;
            }
            Object next = namingEnumeration.next();
            if (namingEnumeration.hasMore()) {
                throw new RuntimeException("Expecting one result");
            }
            return LdapExample.retrieveAttributeStringValue(next, attributeName);
        }
        throw new RuntimeException("Not expecting type: " + object);
    }

    public static List<String> retrieveAttributeStringListValue(Object object, String attributeName) throws NamingException {
        if (object == null) {
            return null;
        }
        if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            return LdapExample.retrieveAttributeStringListValue(namingEnumeration, attributeName);
        }
        if (object instanceof SearchResult) {
            SearchResult searchResult = (SearchResult)object;
            Attributes attributes = searchResult.getAttributes();
            Attribute attribute = attributes.get(attributeName);
            return LdapExample.retrieveAttributeStringListValue(attribute, attributeName);
        }
        if (object instanceof NamingEnumeration) {
            int size = 0;
            NamingEnumeration namingEnumeration = (NamingEnumeration)object;
            ArrayList<String> resultList = new ArrayList<String>();
            while (namingEnumeration.hasMore()) {
                Object next = namingEnumeration.next();
                if (next instanceof SearchResult) {
                    if (size == 0 && !namingEnumeration.hasMore()) {
                        return LdapExample.retrieveAttributeStringListValue(next, attributeName);
                    }
                    throw new RuntimeException("Error: multiple search results found!");
                }
                resultList.add((String)next);
                ++size;
            }
            if (size == 0) {
                return null;
            }
            return resultList;
        }
        throw new RuntimeException("Not expecting type: " + object);
    }

    public static void printAttribute(Attribute attribute) throws NamingException {
        System.out.print("Attribute: " + attribute.getID() + ": ");
        NamingEnumeration<?> namingEnumeration3 = attribute.getAll();
        while (namingEnumeration3.hasMore()) {
            System.out.print((String)namingEnumeration3.next() + ", ");
        }
        System.out.println("");
    }
}

