/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.util;

import edu.internet2.middleware.grouperClient.util.ExpirableValue;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpirableCache<K, V>
implements Serializable {
    static long MAX_TIME_TO_LIVE_MILLIS = 86400000L;
    long defaultTimeToLiveInMillis = MAX_TIME_TO_LIVE_MILLIS;
    static long TIME_BETWEEN_EVICTIONS_MILLIS = 120000L;
    long lastEvictionCheck = System.currentTimeMillis();
    private Map<K, ExpirableValue<V>> cache = new HashMap<K, ExpirableValue<V>>();
    private int cacheInserts = 0;
    private int cacheHits = 0;
    private int cacheEvictions = 0;
    private static int globalCacheInserts = 0;
    private static int globalCacheHits = 0;
    private static int globalCacheEvictions = 0;
    private static long lastClearStatic = -1L;
    private long lastClear = System.currentTimeMillis();

    public ExpirableCache() {
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public ExpirableCache(int defaultTimeToLiveInMinutes) {
        GrouperClientUtils.assertion(defaultTimeToLiveInMinutes > 0, "Time to live in minutes must be greater than 0");
        long newTimeToLiveMillis = defaultTimeToLiveInMinutes * 60 * 1000;
        if (newTimeToLiveMillis < MAX_TIME_TO_LIVE_MILLIS) {
            this.defaultTimeToLiveInMillis = newTimeToLiveMillis;
        }
    }

    public ExpirableCache(ExpirableCacheUnit expirableCacheUnit, int defaultTimeToLive) {
        GrouperClientUtils.assertion(defaultTimeToLive > 0, "Time to live in minutes must be greater than 0");
        long newTimeToLiveMillis = expirableCacheUnit.defaultTimeToLiveMillis(defaultTimeToLive);
        if (newTimeToLiveMillis < MAX_TIME_TO_LIVE_MILLIS) {
            this.defaultTimeToLiveInMillis = newTimeToLiveMillis;
        }
    }

    public long getDefaultTimeToLiveInMillis() {
        return this.defaultTimeToLiveInMillis;
    }

    public synchronized void put(K key, V value) {
        this.putHelper(key, value, this.defaultTimeToLiveInMillis);
    }

    public synchronized void put(K key, V value, int timeToLiveInMinutes) {
        if (timeToLiveInMinutes == -1) {
            this.put(key, value);
            return;
        }
        GrouperClientUtils.assertion(timeToLiveInMinutes > 0, "Time to live in minutes must be greater than 0");
        this.putHelper(key, value, timeToLiveInMinutes * 60 * 1000);
    }

    synchronized void putHelper(K key, V value, long proposedTimeToLiveInMillis) {
        this.checkForEvictions(true);
        long newTimeToLiveInMillis = this.defaultTimeToLiveInMillis;
        if (proposedTimeToLiveInMillis > 0L && proposedTimeToLiveInMillis <= MAX_TIME_TO_LIVE_MILLIS) {
            newTimeToLiveInMillis = proposedTimeToLiveInMillis;
        }
        ExpirableValue<V> expirableValue = new ExpirableValue<V>(value, newTimeToLiveInMillis);
        this.cache.put(key, expirableValue);
        ++this.cacheInserts;
        ++globalCacheInserts;
    }

    public static void clearAll() {
        lastClearStatic = System.currentTimeMillis();
    }

    public synchronized void checkForEvictions(boolean onlyCheckIfNeeded) {
        long now = System.currentTimeMillis();
        if (lastClearStatic > this.lastClear) {
            this.clear();
            this.lastClear = now;
            return;
        }
        if (onlyCheckIfNeeded && now - this.lastEvictionCheck < TIME_BETWEEN_EVICTIONS_MILLIS) {
            return;
        }
        Set<K> keySet = this.cache.keySet();
        Iterator<K> keyIterator = keySet.iterator();
        while (keyIterator.hasNext()) {
            K key = keyIterator.next();
            ExpirableValue<V> expirableValue = this.cache.get(key);
            if (!expirableValue.expired()) continue;
            keyIterator.remove();
            ++this.cacheEvictions;
            ++globalCacheEvictions;
        }
        this.lastEvictionCheck = now;
    }

    public synchronized V get(K key) {
        this.checkForEvictions(true);
        return this.getHelper(key);
    }

    private synchronized V getHelper(K key) {
        ExpirableValue<V> value = this.cache.get(key);
        if (value == null) {
            this.cache.remove(key);
            return null;
        }
        if (value.expired()) {
            ++this.cacheEvictions;
            ++globalCacheEvictions;
            this.cache.remove(key);
            return null;
        }
        V content = value.getContent();
        ++this.cacheHits;
        ++globalCacheHits;
        return content;
    }

    public synchronized int size(boolean evictEvictables) {
        if (evictEvictables) {
            this.checkForEvictions(false);
        }
        return this.cache.size();
    }

    public int getCacheInserts() {
        return this.cacheInserts;
    }

    public int getCacheEvictions() {
        return this.cacheEvictions;
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public String toString() {
        this.checkForEvictions(true);
        return this.getClass().getSimpleName() + ": size: " + this.size(false) + ", cacheHits: " + this.getCacheHits() + ", cacheInserts: " + this.getCacheInserts() + ", cacheEvictions: " + this.cacheEvictions;
    }

    public static String staticToString() {
        return "ExpirableCacheGlobal, cacheHits: " + globalCacheHits + ", cacheInserts: " + globalCacheInserts + ", cacheEvictions: " + globalCacheEvictions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpirableCacheUnit {
        MINUTE{

            public long defaultTimeToLiveMillis(int input) {
                return input * 60 * 1000;
            }
        }
        ,
        SECOND{

            public long defaultTimeToLiveMillis(int input) {
                return input * 1000;
            }
        };


        public abstract long defaultTimeToLiveMillis(int var1);
    }
}

