/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.grouperClient.ws;

import edu.internet2.middleware.grouperClient.GrouperClientWsException;
import edu.internet2.middleware.grouperClient.discovery.DiscoveryClient;
import edu.internet2.middleware.grouperClient.failover.FailoverClient;
import edu.internet2.middleware.grouperClient.failover.FailoverConfig;
import edu.internet2.middleware.grouperClient.failover.FailoverLogic;
import edu.internet2.middleware.grouperClient.failover.FailoverLogicBean;
import edu.internet2.middleware.grouperClient.util.GrouperClientLog;
import edu.internet2.middleware.grouperClient.util.GrouperClientUtils;
import edu.internet2.middleware.grouperClient.util.GrouperClientXstreamUtils;
import edu.internet2.middleware.grouperClient.ws.GcWebServiceError;
import edu.internet2.middleware.grouperClient.ws.beans.ResultMetadataHolder;
import edu.internet2.middleware.grouperClient.ws.beans.WsRestResultProblem;
import edu.internet2.middleware.grouperClient.ws.beans.WsResultMeta;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.XStream;
import edu.internet2.middleware.grouperClientExt.com.thoughtworks.xstream.io.xml.CompactWriter;
import edu.internet2.middleware.grouperClientExt.edu.internet2.middleware.morphString.Crypto;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.Header;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpClient;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.HttpStatus;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.UsernamePasswordCredentials;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.auth.AuthScope;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods.PostMethod;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.methods.StringRequestEntity;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.params.DefaultHttpParams;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.protocol.Protocol;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import edu.internet2.middleware.grouperClientExt.org.apache.commons.logging.Log;
import java.io.File;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Properties;

public class GrouperClientWs {
    private XStream xStream = GrouperClientXstreamUtils.retrieveXstream();
    private PostMethod method;
    private String response;
    private boolean success = false;
    private String resultCode = null;
    private String contentType = null;
    private Object result = null;
    private static Log LOG = GrouperClientUtils.retrieveLog(GrouperClientWs.class);
    public static String mostRecentRequest = null;
    public static String mostRecentResponse = null;
    private static Long lastFailoverConfigure = null;
    private static Integer configureEverySeconds = null;
    private static File lastDiscoveryConfigFile = null;
    public static final String READ_ONLY_FAILOVER_CONFIG_NAME = "grouperWsReadOnly";
    public static final String READ_WRITE_FAILOVER_CONFIG_NAME = "grouperWsReadWrite";

    public void copyFrom(GrouperClientWs grouperClientWs) {
        this.contentType = grouperClientWs.contentType;
        this.method = grouperClientWs.method;
        this.response = grouperClientWs.response;
        this.resultCode = grouperClientWs.resultCode;
        this.success = grouperClientWs.success;
        this.xStream = grouperClientWs.xStream;
    }

    public GrouperClientWs assignContentType(String theContentType) {
        this.contentType = theContentType;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureFailoverClient() {
        int cacheForSeconds;
        LinkedHashMap<String, Object> debugLog;
        LinkedHashMap<String, Object> linkedHashMap = debugLog = LOG.isDebugEnabled() ? new LinkedHashMap<String, Object>() : null;
        if (debugLog != null) {
            debugLog.put("method", "GrouperClientWs.configureFailoverClient");
        }
        if (configureEverySeconds == null && (configureEverySeconds = Integer.valueOf((cacheForSeconds = GrouperClientUtils.propertiesValueInt("grouperClient.cacheDiscoveryPropertiesForSeconds", 120, false)) / 5)) < 20) {
            configureEverySeconds = 20;
        }
        boolean needsReconfigure = GrouperClientWs.needsReconfigure();
        if (debugLog != null) {
            debugLog.put("needsReconfigure", needsReconfigure);
        }
        if (needsReconfigure) {
            try {
                Class<GrouperClientWs> clazz = GrouperClientWs.class;
                synchronized (GrouperClientWs.class) {
                    if (GrouperClientWs.needsReconfigure()) {
                        File discoveryFile;
                        String fileName = "grouper.client.discovery.properties";
                        String directoryName = GrouperClientUtils.propertiesValue("grouperClient.discoveryGrouperClientPropertiesDirectory", false);
                        if (!GrouperClientUtils.isBlank(directoryName)) {
                            directoryName = GrouperClientUtils.stripLastSlashIfExists(directoryName);
                            fileName = directoryName + "/" + fileName;
                        }
                        if ((discoveryFile = DiscoveryClient.retrieveFile(fileName, false)) == null) {
                            if (debugLog != null) {
                                if (DiscoveryClient.hasDiscovery()) {
                                    debugLog.put("discoveryFile", "not found");
                                } else {
                                    debugLog.put("discoveryFile", "not configured to use");
                                }
                            }
                            if (lastFailoverConfigure != null) {
                                needsReconfigure = false;
                            }
                            if (DiscoveryClient.hasDiscovery()) {
                                LOG.error("Cant find discovery file: '" + fileName + "'!!!!!!!");
                            }
                        } else {
                            if (debugLog != null) {
                                debugLog.put("discoveryFile", discoveryFile.getAbsolutePath());
                            }
                            if (lastDiscoveryConfigFile != null && lastDiscoveryConfigFile.equals(discoveryFile)) {
                                needsReconfigure = false;
                            }
                        }
                        if (debugLog != null) {
                            debugLog.put("needsReconfigureFile", needsReconfigure);
                        }
                        if (needsReconfigure) {
                            String readOnlyUrl;
                            String readWriteUrl;
                            int i;
                            FailoverConfig.FailoverStrategy failoverStrategy;
                            String readOnlyUrl2;
                            String readWriteUrl2;
                            int i2;
                            FailoverConfig failoverConfig = new FailoverConfig();
                            boolean foundOne = false;
                            ArrayList<String> readWriteUrls = new ArrayList<String>();
                            for (i2 = 0; i2 < 100 && !GrouperClientUtils.isBlank(readWriteUrl2 = GrouperClientUtils.propertiesValue("grouperClient.discoveryDefault.webService.readWrite." + i2 + ".url", false)); ++i2) {
                                foundOne = true;
                                if (GrouperClientUtils.isBlank(readWriteUrl2)) continue;
                                readWriteUrls.add(readWriteUrl2);
                            }
                            if (foundOne) {
                                failoverConfig.setConnectionNames(readWriteUrls);
                            }
                            foundOne = false;
                            ArrayList<String> readOnlyUrls = new ArrayList<String>();
                            for (i2 = 0; i2 < 100 && !GrouperClientUtils.isBlank(readOnlyUrl2 = GrouperClientUtils.propertiesValue("grouperClient.discoveryDefault.webService.readOnly." + i2 + ".url", false)); ++i2) {
                                foundOne = true;
                                if (GrouperClientUtils.isBlank(readOnlyUrl2)) continue;
                                readOnlyUrls.add(readOnlyUrl2);
                            }
                            if (foundOne) {
                                failoverConfig.setConnectionNamesSecondTier(readOnlyUrls);
                            }
                            if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientUtils.propertiesValue("grouperClient.discoveryDefault.webService.loadBalancing", false), false)) != null) {
                                failoverConfig.setFailoverStrategy(failoverStrategy);
                            }
                            boolean preferReadWrite = true;
                            preferReadWrite = GrouperClientUtils.propertiesValueBoolean("grouperClient.discoveryDefault.webService.preferReadWrite", preferReadWrite, false);
                            int affinitySeconds = failoverConfig.getAffinitySeconds();
                            affinitySeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryDefault.webService.affinitySeconds", affinitySeconds, false);
                            failoverConfig.setAffinitySeconds(affinitySeconds);
                            int lowerConnectionPriorityOnErrorForMinutes = failoverConfig.getMinutesToKeepErrors();
                            lowerConnectionPriorityOnErrorForMinutes = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryDefault.webService.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes, false);
                            failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                            int timeoutSeconds = failoverConfig.getTimeoutSeconds();
                            timeoutSeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryDefault.webService.timeoutSeconds", timeoutSeconds, false);
                            failoverConfig.setTimeoutSeconds(timeoutSeconds);
                            int extraTimeoutSeconds = failoverConfig.getExtraTimeoutSeconds();
                            extraTimeoutSeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryDefault.webService.extraTimeoutSeconds", extraTimeoutSeconds, false);
                            failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            if (discoveryFile != null) {
                                String readOnlyUrl3;
                                String readWriteUrl3;
                                int i3;
                                Properties properties = GrouperClientUtils.propertiesFromFile(discoveryFile);
                                boolean foundOne2 = false;
                                ArrayList<String> readWriteUrls2 = new ArrayList<String>();
                                for (i3 = 0; i3 < 100 && !GrouperClientUtils.isBlank(readWriteUrl3 = GrouperClientUtils.propertiesValue(properties, "grouperClient.discovery.webService.readWrite." + i3 + ".url")); ++i3) {
                                    foundOne2 = true;
                                    if (GrouperClientUtils.isBlank(readWriteUrl3)) continue;
                                    readWriteUrls2.add(readWriteUrl3);
                                }
                                if (foundOne2) {
                                    failoverConfig.setConnectionNames(readWriteUrls2);
                                }
                                foundOne2 = false;
                                ArrayList<String> readOnlyUrls2 = new ArrayList<String>();
                                for (i3 = 0; i3 < 100 && !GrouperClientUtils.isBlank(readOnlyUrl3 = GrouperClientUtils.propertiesValue(properties, "grouperClient.discovery.webService.readOnly." + i3 + ".url")); ++i3) {
                                    foundOne2 = true;
                                    if (GrouperClientUtils.isBlank(readOnlyUrl3)) continue;
                                    readOnlyUrls2.add(readOnlyUrl3);
                                }
                                if (foundOne2) {
                                    failoverConfig.setConnectionNamesSecondTier(readOnlyUrls2);
                                }
                                if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientUtils.propertiesValue(properties, "grouperClient.discovery.webService.loadBalancing"), false)) != null) {
                                    failoverConfig.setFailoverStrategy(failoverStrategy);
                                }
                                preferReadWrite = GrouperClientUtils.propertiesValueBoolean(properties, "grouperClient.discovery.webService.preferReadWrite", preferReadWrite);
                                affinitySeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.webService.affinitySeconds", affinitySeconds);
                                failoverConfig.setAffinitySeconds(affinitySeconds);
                                lowerConnectionPriorityOnErrorForMinutes = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.webService.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes);
                                failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                                timeoutSeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.webService.timeoutSeconds", timeoutSeconds);
                                failoverConfig.setTimeoutSeconds(timeoutSeconds);
                                extraTimeoutSeconds = GrouperClientUtils.propertiesValueInt(properties, null, "grouperClient.discovery.webService.extraTimeoutSeconds", extraTimeoutSeconds);
                                failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            }
                            boolean foundOne3 = false;
                            ArrayList<String> readWriteUrls3 = new ArrayList<String>();
                            for (i = 0; i < 100 && !GrouperClientUtils.isBlank(readWriteUrl = GrouperClientUtils.propertiesValue("grouperClient.discoveryOverride.webService.readWrite." + i + ".url", false)); ++i) {
                                foundOne3 = true;
                                if (GrouperClientUtils.isBlank(readWriteUrl)) continue;
                                readWriteUrls3.add(readWriteUrl);
                            }
                            if (foundOne3) {
                                failoverConfig.setConnectionNames(readWriteUrls3);
                            }
                            foundOne3 = false;
                            ArrayList<String> readOnlyUrls3 = new ArrayList<String>();
                            for (i = 0; i < 100 && !GrouperClientUtils.isBlank(readOnlyUrl = GrouperClientUtils.propertiesValue("grouperClient.discoveryOverride.webService.readOnly." + i + ".url", false)); ++i) {
                                foundOne3 = true;
                                if (GrouperClientUtils.isBlank(readOnlyUrl)) continue;
                                readOnlyUrls3.add(readOnlyUrl);
                            }
                            if (foundOne3) {
                                failoverConfig.setConnectionNamesSecondTier(readOnlyUrls3);
                            }
                            if ((failoverStrategy = FailoverConfig.FailoverStrategy.valueOfIgnoreCase(GrouperClientUtils.propertiesValue("grouperClient.discoveryOverride.webService.loadBalancing", false), false)) != null) {
                                failoverConfig.setFailoverStrategy(failoverStrategy);
                            }
                            preferReadWrite = GrouperClientUtils.propertiesValueBoolean("grouperClient.discoveryOverride.webService.preferReadWrite", preferReadWrite, false);
                            affinitySeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryOverride.webService.affinitySeconds", affinitySeconds, false);
                            failoverConfig.setAffinitySeconds(affinitySeconds);
                            lowerConnectionPriorityOnErrorForMinutes = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryOverride.webService.lowerConnectionPriorityOnErrorForMinutes", lowerConnectionPriorityOnErrorForMinutes, false);
                            failoverConfig.setMinutesToKeepErrors(lowerConnectionPriorityOnErrorForMinutes);
                            timeoutSeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryOverride.webService.timeoutSeconds", timeoutSeconds, false);
                            failoverConfig.setTimeoutSeconds(timeoutSeconds);
                            extraTimeoutSeconds = GrouperClientUtils.propertiesValueInt("grouperClient.discoveryOverride.webService.extraTimeoutSeconds", extraTimeoutSeconds, false);
                            failoverConfig.setExtraTimeoutSeconds(extraTimeoutSeconds);
                            if (debugLog != null) {
                                int i4 = 0;
                                for (String readWriteUrl4 : GrouperClientUtils.nonNull(failoverConfig.getConnectionNames())) {
                                    debugLog.put("readWriteUrl." + i4, readWriteUrl4);
                                    ++i4;
                                }
                                i4 = 0;
                                for (String readOnlyUrl4 : GrouperClientUtils.nonNull(failoverConfig.getConnectionNamesSecondTier())) {
                                    debugLog.put("readOnlyUrl." + i4, readOnlyUrl4);
                                    ++i4;
                                }
                                debugLog.put("affinitySeconds", failoverConfig.getAffinitySeconds());
                                debugLog.put("extraTimeoutSeconds", failoverConfig.getExtraTimeoutSeconds());
                                debugLog.put("errorsForMinutes", failoverConfig.getMinutesToKeepErrors());
                                debugLog.put("failoverStrategy", (Object)failoverConfig.getFailoverStrategy());
                                debugLog.put("preferReadWrite", preferReadWrite);
                                debugLog.put("timeoutSeconds", failoverConfig.getTimeoutSeconds());
                            }
                            FailoverConfig failoverConfigReadWrite = new FailoverConfig();
                            failoverConfigReadWrite.copyFromArgument(failoverConfig);
                            failoverConfigReadWrite.setConnectionNamesSecondTier(null);
                            if (GrouperClientUtils.length(failoverConfigReadWrite.getConnectionNames()) == 0) {
                                failoverConfigReadWrite.setConnectionNames(GrouperClientUtils.toList(GrouperClientUtils.propertiesValue("grouperClient.webService.url", true)));
                            }
                            failoverConfigReadWrite.setConnectionType(READ_WRITE_FAILOVER_CONFIG_NAME);
                            FailoverClient.initFailoverClient(failoverConfigReadWrite);
                            FailoverConfig failoverConfigReadOnly = new FailoverConfig();
                            failoverConfigReadOnly.copyFromArgument(failoverConfig);
                            if (!preferReadWrite && GrouperClientUtils.length(failoverConfig.getConnectionNamesSecondTier()) > 0) {
                                if (failoverConfigReadOnly.getConnectionNames() == null) {
                                    failoverConfigReadOnly.setConnectionNames(new ArrayList<String>());
                                }
                                failoverConfigReadOnly.getConnectionNames().addAll(failoverConfigReadOnly.getConnectionNamesSecondTier());
                                failoverConfigReadOnly.setConnectionNamesSecondTier(null);
                            }
                            if (GrouperClientUtils.length(failoverConfigReadOnly.getConnectionNames()) == 0 && GrouperClientUtils.length(failoverConfigReadOnly.getConnectionNamesSecondTier()) == 0) {
                                failoverConfigReadOnly.setConnectionNames(GrouperClientUtils.toList(GrouperClientUtils.propertiesValue("grouperClient.webService.url", true)));
                            }
                            failoverConfigReadOnly.setConnectionType(READ_ONLY_FAILOVER_CONFIG_NAME);
                            FailoverClient.initFailoverClient(failoverConfigReadOnly);
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            finally {
                if (debugLog != null) {
                    LOG.debug(GrouperClientUtils.mapToString(debugLog));
                }
            }
        }
        {
            return;
        }
    }

    private static boolean needsReconfigure() {
        boolean needsReconfigure;
        boolean bl = needsReconfigure = lastFailoverConfigure == null || (System.currentTimeMillis() - lastFailoverConfigure) / 1000L > (long)configureEverySeconds.intValue();
        if (!DiscoveryClient.hasDiscovery() && lastFailoverConfigure != null) {
            needsReconfigure = false;
        }
        return needsReconfigure;
    }

    public Object executeService(final String urlSuffix, final Object toSend, final String labelForLog, final String clientVersion, boolean readOnly) {
        GrouperClientWs.configureFailoverClient();
        String connectionType = readOnly ? READ_ONLY_FAILOVER_CONFIG_NAME : READ_WRITE_FAILOVER_CONFIG_NAME;
        GrouperClientWs grouperClientWs = FailoverClient.failoverLogic(connectionType, new FailoverLogic<GrouperClientWs>(){

            @Override
            public GrouperClientWs logic(FailoverLogicBean failoverLogicBean) {
                return GrouperClientWs.executeServiceHelper(failoverLogicBean.getConnectionName(), urlSuffix, toSend, labelForLog, clientVersion, !failoverLogicBean.isLastConnection());
            }
        });
        if (grouperClientWs != null) {
            this.copyFrom(grouperClientWs);
            return grouperClientWs.result;
        }
        return null;
    }

    private static GrouperClientWs executeServiceHelper(String url, String urlSuffix, Object toSend, String labelForLog, String clientVersion, boolean exceptionOnNonSuccess) {
        String resultObject;
        String successString;
        GrouperClientWs grouperClientWs = new GrouperClientWs();
        String logDir = GrouperClientUtils.propertiesValue("grouperClient.logging.webService.documentDir", false);
        File requestFile = null;
        File responseFile = null;
        if (!GrouperClientUtils.isBlank(logDir)) {
            logDir = GrouperClientUtils.stripEnd(logDir, "/");
            logDir = GrouperClientUtils.stripEnd(logDir, "\\");
            Date date = new Date();
            String logName = logDir + File.separator + "wsLog_" + new SimpleDateFormat("yyyy_MM").format(date) + File.separator + "day_" + new SimpleDateFormat("dd" + File.separator + "HH_mm_ss_SSS").format(date) + "_" + (int)(1000.0 * Math.random()) + "_" + labelForLog;
            requestFile = new File(logName + "_request.log");
            responseFile = new File(logName + "_response.log");
            GrouperClientUtils.mkdirs(requestFile.getParentFile());
        }
        int[] responseCode = new int[1];
        grouperClientWs.method = grouperClientWs.postMethod(url, grouperClientWs.xStream, urlSuffix, toSend, requestFile, responseCode, clientVersion);
        Header successHeader = grouperClientWs.method.getResponseHeader("X-Grouper-success");
        String string = successString = successHeader == null ? null : successHeader.getValue();
        if (GrouperClientUtils.isBlank(successString)) {
            if (LOG.isDebugEnabled()) {
                String theResponse = null;
                try {
                    theResponse = GrouperClientUtils.responseBodyAsString(grouperClientWs.method);
                }
                catch (Exception e) {
                    // empty catch block
                }
                LOG.debug("Response: " + theResponse);
            }
            throw new RuntimeException("Web service did not even respond! " + url);
        }
        grouperClientWs.success = "T".equals(successString);
        grouperClientWs.resultCode = grouperClientWs.method.getResponseHeader("X-Grouper-resultCode").getValue();
        mostRecentResponse = grouperClientWs.response = GrouperClientUtils.responseBodyAsString(grouperClientWs.method);
        if (responseFile != null || GrouperClientLog.debugToConsole()) {
            if (responseFile != null) {
                LOG.debug("WebService: logging response to: " + GrouperClientUtils.fileCanonicalPath(responseFile));
            }
            String theResponse = grouperClientWs.response;
            Exception indentException = null;
            boolean isIndent = GrouperClientUtils.propertiesValueBoolean("grouperClient.logging.webService.indent", true, true);
            if (isIndent) {
                try {
                    theResponse = GrouperClientUtils.indent(theResponse, true);
                }
                catch (Exception e) {
                    indentException = e;
                }
            }
            StringBuilder headers = new StringBuilder();
            headers.append("HTTP/1.1 ").append(responseCode[0]).append(" ").append(HttpStatus.getStatusText(responseCode[0])).append("\n");
            for (Header header : grouperClientWs.method.getResponseHeaders()) {
                String name = header.getName();
                String value = header.getValue();
                if (GrouperClientUtils.equals(name, "Set-Cookie")) {
                    value = value.replaceAll("JSESSIONID=(.*)?;", "JSESSIONID=xxxxxxxxxxxx;");
                }
                headers.append(name).append(": ").append(value).append("\n");
            }
            headers.append("\n");
            String theResponseTotal = headers + theResponse;
            if (responseFile != null) {
                GrouperClientUtils.saveStringIntoFile(responseFile, theResponseTotal);
            }
            if (GrouperClientLog.debugToConsole()) {
                System.err.println("\n################ RESPONSE START " + (isIndent ? "(indented) " : "") + "###############\n");
                System.err.println(theResponseTotal);
                System.err.println("\n################ RESPONSE END ###############\n\n");
            }
            if (indentException != null) {
                throw new RuntimeException("Problems indenting xml (is it valid?), turn off the indenting in the grouper.client.properties: grouperClient.logging.webService.indent", indentException);
            }
        }
        String string2 = resultObject = toSend instanceof String ? grouperClientWs.response : grouperClientWs.xStream.fromXML(grouperClientWs.response);
        if (resultObject instanceof WsRestResultProblem) {
            throw new GrouperClientWsException((Object)resultObject, ((WsRestResultProblem)((Object)resultObject)).getResultMetadata().getResultMessage());
        }
        if (exceptionOnNonSuccess && !grouperClientWs.success) {
            throw new GrouperClientWsException((Object)resultObject, "Result code: " + grouperClientWs.resultCode + ", on url: " + url);
        }
        grouperClientWs.result = resultObject;
        return grouperClientWs;
    }

    public void handleFailure(Object responseContainer, ResultMetadataHolder[] resultMetadataHolders, String resultMessage) {
        if (!this.success) {
            StringBuilder error = new StringBuilder("Bad response from web service: resultCode: " + this.resultCode + ", " + resultMessage);
            int errorIndex = 0;
            for (int i = 0; i < GrouperClientUtils.length(resultMetadataHolders); ++i) {
                try {
                    WsResultMeta resultMetadata = resultMetadataHolders[i].getResultMetadata();
                    if (GrouperClientUtils.equals(resultMetadata.getSuccess(), "T")) continue;
                    error.append("\nError ").append(errorIndex).append(", result index: ").append(i).append(", code: ").append(resultMetadata.getResultCode()).append(", message: ").append(resultMetadata.getResultMessage());
                    ++errorIndex;
                    continue;
                }
                catch (Exception e) {
                    LOG.debug("issue with error message: ", e);
                }
            }
            throw new GcWebServiceError(responseContainer, error.toString());
        }
    }

    private static HttpClient httpClient() {
        String httpsSocketFactoryName = GrouperClientUtils.propertiesValue("grouperClient.https.customSocketFactory", false);
        if (!GrouperClientUtils.isBlank(httpsSocketFactoryName)) {
            Class httpsSocketFactoryClass = GrouperClientUtils.forName(httpsSocketFactoryName);
            SecureProtocolSocketFactory httpsSocketFactoryInstance = (SecureProtocolSocketFactory)GrouperClientUtils.newInstance(httpsSocketFactoryClass);
            Protocol easyhttps = new Protocol("https", httpsSocketFactoryInstance, 443);
            Protocol.registerProtocol("https", easyhttps);
        }
        HttpClient httpClient = new HttpClient();
        DefaultHttpParams.getDefaultParams().setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler(0, false));
        httpClient.getParams().setAuthenticationPreemptive(true);
        int soTimeoutMillis = GrouperClientUtils.propertiesValueInt("grouperClient.webService.httpSocketTimeoutMillis", 90000, true);
        httpClient.getParams().setSoTimeout(soTimeoutMillis);
        httpClient.getParams().setParameter("http.protocol.head-body-timeout", soTimeoutMillis);
        int connectionManagerMillis = GrouperClientUtils.propertiesValueInt("grouperClient.webService.httpConnectionManagerTimeoutMillis", 90000, true);
        httpClient.getParams().setConnectionManagerTimeout(connectionManagerMillis);
        String userLabel = GrouperClientUtils.propertiesValue("grouperClient.webService.user.label", true);
        String user = GrouperClientUtils.propertiesValue("grouperClient.webService." + userLabel, true);
        LOG.debug("WebService: connecting as user: '" + user + "'");
        boolean disableExternalFileLookup = GrouperClientUtils.propertiesValueBoolean("encrypt.disableExternalFileLookup", false, true);
        String wsPass = GrouperClientUtils.propertiesValue("grouperClient.webService.password", true);
        String wsPassFromFile = GrouperClientUtils.readFromFileIfFile(wsPass, disableExternalFileLookup);
        String passPrefix = null;
        if (!GrouperClientUtils.equals(wsPass, wsPassFromFile)) {
            passPrefix = "WebService pass: reading encrypted value from file: " + wsPass;
            String encryptKey = GrouperClientUtils.encryptKey();
            wsPass = new Crypto(encryptKey).decrypt(wsPassFromFile);
        } else {
            passPrefix = "WebService pass: reading scalar value from grouper.client.properties";
        }
        if (GrouperClientUtils.propertiesValueBoolean("grouperClient.logging.logMaskedPassword", false, false)) {
            LOG.debug(passPrefix + ": " + GrouperClientUtils.repeat("*", wsPass.length()));
        }
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(user, wsPass);
        httpClient.getState().setCredentials(new AuthScope(null, -1), defaultcreds);
        return httpClient;
    }

    private PostMethod postMethod(String url, String suffix, String clientVersion) {
        url = GrouperClientUtils.stripEnd(url, "/");
        String webServiceVersion = GrouperClientUtils.propertiesValue("grouperClient.webService.client.version", true);
        if (!GrouperClientUtils.isBlank(clientVersion)) {
            webServiceVersion = clientVersion;
        }
        webServiceVersion = GrouperClientUtils.stripStart(webServiceVersion, "/");
        webServiceVersion = GrouperClientUtils.stripEnd(webServiceVersion, "/");
        url = url + "/" + webServiceVersion + "/" + suffix;
        LOG.debug("WebService: connecting to URL: '" + url + "'");
        PostMethod postMethod = new PostMethod(url);
        postMethod.setRequestHeader("Connection", "close");
        return postMethod;
    }

    private PostMethod postMethod(String url, XStream theXstream, String urlSuffix, Object objectToMarshall, File logFile, int[] responseCode, String clientVersion) {
        try {
            String theContentType = GrouperClientUtils.defaultIfBlank(this.contentType, "text/xml");
            HttpClient httpClient = GrouperClientWs.httpClient();
            PostMethod postMethod = this.postMethod(url, urlSuffix, clientVersion);
            String requestDocument = objectToMarshall instanceof String ? (String)objectToMarshall : GrouperClientWs.marshalObject(theXstream, objectToMarshall);
            postMethod.setRequestEntity(new StringRequestEntity(requestDocument, theContentType, "UTF-8"));
            if (logFile != null || GrouperClientLog.debugToConsole()) {
                if (logFile != null) {
                    LOG.debug("WebService: logging request to: " + GrouperClientUtils.fileCanonicalPath(logFile));
                }
                String theRequestDocument = requestDocument;
                Exception indentException = null;
                boolean isIndent = GrouperClientUtils.propertiesValueBoolean("grouperClient.logging.webService.indent", true, true);
                if (isIndent) {
                    try {
                        theRequestDocument = GrouperClientUtils.indent(theRequestDocument, true);
                    }
                    catch (Exception e) {
                        indentException = e;
                    }
                }
                StringBuilder headers = new StringBuilder();
                headers.append("POST ").append(postMethod.getURI().getPathQuery()).append(" HTTP/1.1\n");
                headers.append("Connection: close\n");
                headers.append("Authorization: Basic xxxxxxxxxxxxxxxx\n");
                headers.append("User-Agent: Jakarta Commons-HttpClient/3.1\n");
                headers.append("Host: ").append(postMethod.getURI().getHost()).append(":").append(postMethod.getURI().getPort()).append("\n");
                headers.append("Content-Length: ").append(postMethod.getRequestEntity().getContentLength()).append("\n");
                headers.append("Content-Type: ").append(postMethod.getRequestEntity().getContentType()).append("\n");
                headers.append("\n");
                String theRequest = headers + theRequestDocument;
                if (logFile != null) {
                    GrouperClientUtils.saveStringIntoFile(logFile, theRequest);
                }
                if (GrouperClientLog.debugToConsole()) {
                    System.err.println("\n################ REQUEST START " + (isIndent ? "(indented) " : "") + "###############\n");
                    System.err.println(theRequest);
                    System.err.println("\n################ REQUEST END ###############\n\n");
                }
                if (indentException != null) {
                    throw new RuntimeException("Problems indenting xml (is it valid?), turn off the indenting in the grouper.client.properties: grouperClient.logging.webService.indent", indentException);
                }
            }
            mostRecentRequest = requestDocument;
            int responseCodeInt = httpClient.executeMethod(postMethod);
            if (responseCode != null && responseCode.length > 0) {
                responseCode[0] = responseCodeInt;
            }
            return postMethod;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Problem in url: " + url, e);
        }
    }

    private static String marshalObject(XStream xStream, Object object) {
        StringWriter stringWriter = new StringWriter();
        xStream.marshal(object, new CompactWriter(stringWriter));
        String requestDocument = stringWriter.toString();
        return requestDocument;
    }
}

