CREATE MEMORY TABLE PUBLIC.ABSTRACTENTITY(ID BIGINT NOT NULL PRIMARY KEY,CREATIONDATE TIMESTAMP,MODIFICATIONDATE TIMESTAMP,DTYPE VARCHAR(255));
CREATE INDEX I_BSTRTTY_DTYPE ON PUBLIC.ABSTRACTENTITY(DTYPE);
CREATE MEMORY TABLE PUBLIC.ACCESSTOKEN(ID BIGINT NOT NULL PRIMARY KEY,CREATIONDATE TIMESTAMP,MODIFICATIONDATE TIMESTAMP,ENCODEDPRINCIPAL VARCHAR(16384),EXPIRES BIGINT,REFRESHTOKEN VARCHAR(255),RESOURCEOWNERID VARCHAR(255),TOKEN VARCHAR(255),CLIENT_ID BIGINT NOT NULL,CONSTRAINT U_CCSSTKN_REFRESHTOKEN UNIQUE(REFRESHTOKEN),CONSTRAINT U_CCSSTKN_TOKEN UNIQUE(TOKEN));
CREATE INDEX I_CCSSTKN_CLIENT ON PUBLIC.ACCESSTOKEN(CLIENT_ID);
CREATE MEMORY TABLE PUBLIC.ACCESSTOKEN_SCOPES(ACCESSTOKEN_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_CCSSCPS_ACCESSTOKEN_ID ON PUBLIC.ACCESSTOKEN_SCOPES(ACCESSTOKEN_ID);
CREATE MEMORY TABLE PUBLIC.AUTHORIZATIONREQUEST(ID BIGINT NOT NULL PRIMARY KEY,CREATIONDATE TIMESTAMP,MODIFICATIONDATE TIMESTAMP,AUTHSTATE VARCHAR(255),AUTHORIZATIONCODE VARCHAR(255),ENCODEDPRINCIPAL VARCHAR(16384),REDIRECTURI VARCHAR(255),RESPONSETYPE VARCHAR(255),STATE VARCHAR(255),CLIENT_ID BIGINT NOT NULL);
CREATE INDEX I_THRZQST_CLIENT ON PUBLIC.AUTHORIZATIONREQUEST(CLIENT_ID);
CREATE MEMORY TABLE PUBLIC.AUTHORIZATIONREQUEST_GRANTEDSCOPES(AUTHORIZATIONREQUEST_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_THRZCPS_AUTHORIZATIONREQUEST_ID ON PUBLIC.AUTHORIZATIONREQUEST_GRANTEDSCOPES(AUTHORIZATIONREQUEST_ID);
CREATE MEMORY TABLE PUBLIC.AUTHORIZATIONREQUEST_REQUESTEDSCOPES(AUTHORIZATIONREQUEST_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_THRZCPS_AUTHORIZATIONREQUEST_ID1 ON PUBLIC.AUTHORIZATIONREQUEST_REQUESTEDSCOPES(AUTHORIZATIONREQUEST_ID);
CREATE MEMORY TABLE PUBLIC.CLIENT(ID BIGINT NOT NULL PRIMARY KEY,CREATIONDATE TIMESTAMP,MODIFICATIONDATE TIMESTAMP,CLIENTID VARCHAR(255),CONTACTEMAIL VARCHAR(255),CONTACTNAME VARCHAR(255),DESCRIPTION VARCHAR(255),EXPIREDURATION BIGINT,CLIENTNAME VARCHAR(255),ALLOWEDIMPLICITGRANT BIT(1),ALLOWEDCLIENTCREDENTIALS BIT(1),SECRET VARCHAR(255),SKIPCONSENT BIT(1),INCLUDEPRINCIPAL BIT(1), THUMBNAILURL VARCHAR(255),USEREFRESHTOKENS BIT(1),RESOURCESERVER_ID BIGINT NOT NULL,CONSTRAINT U_CLIENT_CLIENTID UNIQUE(CLIENTID));
CREATE INDEX I_CLIENT_RESOURCESERVER ON PUBLIC.CLIENT(RESOURCESERVER_ID);
CREATE MEMORY TABLE PUBLIC.CLIENT_ATTRIBUTES(CLIENT_ID BIGINT,ATTRIBUTE_NAME VARCHAR(255) NOT NULL,ATTRIBUTE_VALUE VARCHAR(255));
CREATE INDEX I_CLNTBTS_CLIENT_ID ON PUBLIC.CLIENT_ATTRIBUTES(CLIENT_ID);
CREATE MEMORY TABLE PUBLIC.CLIENT_REDIRECTURIS(CLIENT_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_CLNTTRS_CLIENT_ID ON PUBLIC.CLIENT_REDIRECTURIS(CLIENT_ID);
CREATE MEMORY TABLE PUBLIC.CLIENT_SCOPES(CLIENT_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_CLNTCPS_CLIENT_ID ON PUBLIC.CLIENT_SCOPES(CLIENT_ID);
CREATE MEMORY TABLE PUBLIC.OPENJPA_SEQUENCE_TABLE(ID TINYINT NOT NULL PRIMARY KEY,SEQUENCE_VALUE BIGINT);
CREATE MEMORY TABLE PUBLIC.RESOURCESERVER(ID BIGINT NOT NULL PRIMARY KEY,CREATIONDATE TIMESTAMP,MODIFICATIONDATE TIMESTAMP,CONTACTEMAIL VARCHAR(255),CONTACTNAME VARCHAR(255) NOT NULL,DESCRIPTION VARCHAR(255),RESOURCESERVERKEY VARCHAR(255),RESOURCESERVERNAME VARCHAR(255),OWNER VARCHAR(255),SECRET VARCHAR(255) NOT NULL,THUMBNAILURL VARCHAR(255),CONSTRAINT U_RSRCRVR_KEY UNIQUE(RESOURCESERVERKEY),CONSTRAINT U_RSRCRVR_OWNER UNIQUE(OWNER,RESOURCESERVERNAME));
CREATE MEMORY TABLE PUBLIC.RESOURCESERVER_SCOPES(RESOURCESERVER_ID BIGINT,ELEMENT VARCHAR(255));
CREATE INDEX I_RSRCCPS_RESOURCESERVER_ID ON PUBLIC.RESOURCESERVER_SCOPES(RESOURCESERVER_ID);
