/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.surfnet.oaaas.auth.ObjectMapperProvider;
import org.surfnet.oaaas.model.VerifyTokenResponse;

public class AuthorizationServerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationServerFilter.class);
    private String authorizationServerUrl;
    private String authorizationValue;
    private Client client;
    private static final String BEARER = "bearer";
    public static final String VERIFY_TOKEN_RESPONSE = "VERIFY_TOKEN_RESPONSE";
    private Cache<String, VerifyTokenResponse> cache;
    private String resourceServerKey;
    private String resourceServerSecret;
    private ObjectMapper objectMapper;

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassPathResource res = new ClassPathResource("apis.application.properties");
        if (res.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(res.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Error in reading the apis.application.properties file", e);
            }
            this.resourceServerKey = prop.getProperty("adminService.resourceServerKey");
            this.resourceServerSecret = prop.getProperty("adminService.resourceServerSecret");
            this.authorizationServerUrl = prop.getProperty("adminService.tokenVerificationUrl");
        } else if (filterConfig.getInitParameter("resource-server-key") != null) {
            this.resourceServerKey = filterConfig.getInitParameter("resource-server-key");
            this.resourceServerSecret = filterConfig.getInitParameter("resource-server-secret");
            this.authorizationServerUrl = filterConfig.getInitParameter("authorization-server-url");
        }
        Assert.hasText((String)this.resourceServerKey, (String)"Must provide a resource server key");
        Assert.hasText((String)this.resourceServerSecret, (String)"Must provide a resource server secret");
        Assert.hasText((String)this.authorizationServerUrl, (String)"Must provide a authorization server url");
        this.authorizationValue = new String(Base64.encodeBase64((byte[])this.resourceServerKey.concat(":").concat(this.resourceServerSecret).getBytes()));
        if (this.cacheAccessTokens()) {
            this.cache = this.buildCache(false);
        }
        this.client = this.createClient();
        this.objectMapper = this.createObjectMapper();
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapperProvider().getContext(ObjectMapper.class);
    }

    protected Client createClient() {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(ObjectMapperProvider.class);
        return Client.create((ClientConfig)cc);
    }

    protected Cache<String, VerifyTokenResponse> buildCache(boolean recordStats) {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(10L, TimeUnit.MINUTES);
        return recordStats ? cacheBuilder.recordStats().build() : cacheBuilder.build();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        String accessToken = this.getAccessToken(request);
        if (accessToken == null) {
            LOG.warn("No accesstoken on request. Will respond with error response");
            this.sendError(response, 403, "OAuth2 endpoint requires valid access token");
            return;
        }
        VerifyTokenResponse tokenResponse = null;
        try {
            Callable<VerifyTokenResponse> verifyCall = this.getCallable(accessToken, response);
            tokenResponse = this.cacheAccessTokens() ? (VerifyTokenResponse)this.cache.get((Object)accessToken, verifyCall) : verifyCall.call();
        }
        catch (Exception e) {
            LOG.error("While validating access token", (Throwable)e);
            this.sendError(response, 500, "Cannot verify access token");
            return;
        }
        if (tokenResponse != null && tokenResponse.getPrincipal() != null) {
            request.setAttribute(VERIFY_TOKEN_RESPONSE, (Object)tokenResponse);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.sendError(response, 403, "OAuth2 endpoint");
    }

    private Callable<VerifyTokenResponse> getCallable(final String accessToken, final HttpServletResponse response) {
        return new Callable<VerifyTokenResponse>(){

            @Override
            public VerifyTokenResponse call() throws Exception {
                return AuthorizationServerFilter.this.getVerifyTokenResponse(accessToken, response);
            }
        };
    }

    protected VerifyTokenResponse getVerifyTokenResponse(String accessToken, HttpServletResponse response) {
        ClientResponse res = (ClientResponse)((WebResource.Builder)this.client.resource(String.format("%s?access_token=%s", this.authorizationServerUrl, accessToken)).header("Authorization", (Object)("Basic " + this.authorizationValue)).accept(new String[]{"application/json"})).get(ClientResponse.class);
        try {
            String responseString = (String)res.getEntity(String.class);
            LOG.debug("Got verify token response (status: {}): '{}'", (Object)res.getClientResponseStatus().getStatusCode(), (Object)responseString);
            return (VerifyTokenResponse)this.objectMapper.readValue(responseString, VerifyTokenResponse.class);
        }
        catch (Exception e) {
            LOG.warn("Could not parse the Verify Token Response", (Throwable)e);
            this.sendError(response, 500, "Cannot parse result");
            return new VerifyTokenResponse(e.getMessage());
        }
    }

    protected void sendError(HttpServletResponse response, int statusCode, String reason) {
        try {
            response.sendError(statusCode, reason);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(reason, e);
        }
    }

    protected boolean cacheAccessTokens() {
        return false;
    }

    private String getAccessToken(HttpServletRequest request) {
        String method;
        int space;
        String accessToken = null;
        String header = request.getHeader("Authorization");
        if (header != null && (space = header.indexOf(32)) > 0 && BEARER.equalsIgnoreCase(method = header.substring(0, space))) {
            accessToken = header.substring(space + 1);
        }
        return accessToken;
    }

    public void destroy() {
    }

    public Cache<String, VerifyTokenResponse> getCache() {
        return this.cache;
    }

    public void setAuthorizationServerUrl(String authorizationServerUrl) {
        this.authorizationServerUrl = authorizationServerUrl;
    }

    public void setResourceServerSecret(String resourceServerSecret) {
        this.resourceServerSecret = resourceServerSecret;
    }

    public void setResourceServerKey(String resourceServerKey) {
        this.resourceServerKey = resourceServerKey;
    }
}

