/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityExistsException;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.auth.OAuth2Validator;
import org.surfnet.oaaas.model.ErrorResponse;
import org.surfnet.oaaas.model.ValidationErrorResponse;
import org.surfnet.oaaas.model.VerifyTokenResponse;
import org.surfnet.oaaas.repository.ExceptionTranslator;

public class AbstractResource {
    public static final String SCOPE_READ = "read";
    public static final String SCOPE_WRITE = "write";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractResource.class);
    @Inject
    private ExceptionTranslator exceptionTranslator;
    @Inject
    protected Validator validator;

    public Response buildErrorResponse(Exception e) {
        String reason;
        Response.Status s;
        Exception jpaException = this.exceptionTranslator.translate(e);
        if (jpaException instanceof EntityExistsException) {
            s = Response.Status.BAD_REQUEST;
            reason = "Violating unique constraints";
        } else if (jpaException instanceof ConstraintViolationException) {
            s = Response.Status.BAD_REQUEST;
            reason = "Constraint violation " + jpaException.getMessage();
        } else {
            s = Response.Status.INTERNAL_SERVER_ERROR;
            reason = "Internal server error";
        }
        LOG.info("Responding with error '" + s + "', '" + reason + "'. Cause attached.", (Throwable)e);
        return Response.status((Response.Status)s).entity((Object)reason).build();
    }

    protected Response buildViolationErrorResponse(Set<ConstraintViolation> violations) {
        ValidationErrorResponse responseBody = new ValidationErrorResponse(violations);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)responseBody).build();
    }

    protected String getUserId(HttpServletRequest request) {
        return ((VerifyTokenResponse)request.getAttribute("VERIFY_TOKEN_RESPONSE")).getPrincipal().getName();
    }

    public String generateRandom() {
        return UUID.randomUUID().toString();
    }

    public Response validateScope(HttpServletRequest request, List<String> requiredScopes) {
        VerifyTokenResponse verifyTokenResponse = (VerifyTokenResponse)request.getAttribute("VERIFY_TOKEN_RESPONSE");
        List<String> grantedScopes = verifyTokenResponse.getScopes();
        for (String requiredScope : requiredScopes) {
            if (grantedScopes.contains(requiredScope)) continue;
            LOG.debug("Resource required scopes ({}) which the client has not been granted ({})", requiredScopes, grantedScopes);
            return Response.status((int)400).entity((Object)new ErrorResponse(OAuth2Validator.ValidationResponse.SCOPE_NOT_VALID.getValue(), OAuth2Validator.ValidationResponse.SCOPE_NOT_VALID.getDescription())).build();
        }
        return null;
    }
}

