/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.resource.AbstractResource;

@Named
@Path(value="/accessToken")
@Produces(value={"application/json"})
public class AccessTokenResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenResource.class);
    @Inject
    private AccessTokenRepository accessTokenRepository;

    @GET
    public Response getAll(@Context HttpServletRequest request) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        List<AccessToken> tokens = this.accessTokenRepository.findByResourceOwnerId(owner);
        LOG.debug("About to return all access tokens ({}) for owner {}", (Object)tokens.size(), (Object)owner);
        return Response.ok(tokens).build();
    }

    @GET
    @Path(value="/{accessTokenId}")
    public Response getById(@Context HttpServletRequest request, @PathParam(value="accessTokenId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        AccessToken token = this.accessTokenRepository.findByIdAndResourceOwnerId(id, owner);
        Response.ResponseBuilder responseBuilder = token == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)token);
        LOG.debug("About to return one accessToken with id {}: {}", (Object)id, (Object)token);
        return responseBuilder.build();
    }

    @DELETE
    @Path(value="/{accessTokenId}")
    public Response delete(@Context HttpServletRequest request, @PathParam(value="accessTokenId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        if (this.accessTokenRepository.findByIdAndResourceOwnerId(id, owner) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LOG.debug("About to delete accessToken {}", (Object)id);
        this.accessTokenRepository.delete(id);
        return Response.noContent().build();
    }
}

