/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.surfnet.oaaas.auth.AuthenticationFilter;
import org.surfnet.oaaas.auth.OAuth2Validator;
import org.surfnet.oaaas.auth.ValidationResponseException;
import org.surfnet.oaaas.model.AccessTokenRequest;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.repository.ClientRepository;

@Named
public class OAuth2ValidatorImpl
implements OAuth2Validator {
    private static final Set<String> RESPONSE_TYPES = new HashSet<String>();
    private static final Set<String> GRANT_TYPES = new HashSet<String>();
    @Inject
    private ClientRepository clientRepository;

    @Override
    public OAuth2Validator.ValidationResponse validate(AuthorizationRequest authorizationRequest) {
        try {
            this.validateAuthorizationRequest(authorizationRequest);
            String responseType = this.validateResponseType(authorizationRequest);
            Client client = this.validateClient(authorizationRequest);
            authorizationRequest.setClient(client);
            String redirectUri = this.determineRedirectUri(authorizationRequest, responseType, client);
            authorizationRequest.setRedirectUri(redirectUri);
            List<String> scopes = this.determineScopes(authorizationRequest, client);
            authorizationRequest.setRequestedScopes(scopes);
        }
        catch (ValidationResponseException e) {
            return e.v;
        }
        return OAuth2Validator.ValidationResponse.VALID;
    }

    protected List<String> determineScopes(AuthorizationRequest authorizationRequest, Client client) {
        if (CollectionUtils.isEmpty(authorizationRequest.getRequestedScopes())) {
            return null;
        }
        List<String> scopes = authorizationRequest.getRequestedScopes();
        List<String> clientScopes = client.getScopes();
        for (String scope : scopes) {
            if (clientScopes.contains(scope)) continue;
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.SCOPE_NOT_VALID);
        }
        return authorizationRequest.getRequestedScopes();
    }

    protected String determineRedirectUri(AuthorizationRequest authorizationRequest, String responseType, Client client) {
        List<String> uris = client.getRedirectUris();
        String redirectUri = authorizationRequest.getRedirectUri();
        if (StringUtils.isBlank((String)redirectUri)) {
            if (responseType.equals("token")) {
                throw new ValidationResponseException(OAuth2Validator.ValidationResponse.IMPLICIT_GRANT_REDIRECT_URI);
            }
            if (uris == null || uris.isEmpty()) {
                throw new ValidationResponseException(OAuth2Validator.ValidationResponse.REDIRECT_URI_REQUIRED);
            }
            return uris.get(0);
        }
        if (!AuthenticationFilter.isValidUrl(redirectUri)) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.REDIRCT_URI_NOT_URI);
        }
        if (redirectUri.contains("#")) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.REDIRECT_URI_FRAGMENT_COMPONENT);
        }
        if (uris != null && uris.size() > 0 && !uris.contains(redirectUri.contains("?") ? redirectUri.substring(0, redirectUri.indexOf("?")) : redirectUri)) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.REDIRCT_URI_NOT_VALID);
        }
        return redirectUri;
    }

    protected Client validateClient(AuthorizationRequest authorizationRequest) {
        Client client;
        String clientId = authorizationRequest.getClientId();
        Client client2 = client = StringUtils.isBlank((String)clientId) ? null : this.clientRepository.findByClientId(clientId);
        if (client == null) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.UNKNOWN_CLIENT_ID);
        }
        if (client.isNotAllowedImplicitGrant() && authorizationRequest.getResponseType().equals("token")) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.IMPLICIT_GRANT_NOT_PERMITTED);
        }
        return client;
    }

    protected String validateResponseType(AuthorizationRequest authorizationRequest) {
        String responseType = authorizationRequest.getResponseType();
        if (StringUtils.isBlank((String)responseType) || !RESPONSE_TYPES.contains(responseType)) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.UNSUPPORTED_RESPONSE_TYPE);
        }
        return responseType;
    }

    protected void validateAuthorizationRequest(AuthorizationRequest authorizationRequest) {
    }

    @Override
    public OAuth2Validator.ValidationResponse validate(AccessTokenRequest request) {
        try {
            this.validateGrantType(request);
            this.validateAttributes(request);
            this.validateAccessTokenRequest(request);
        }
        catch (ValidationResponseException e) {
            return e.v;
        }
        return OAuth2Validator.ValidationResponse.VALID;
    }

    protected void validateGrantType(AccessTokenRequest request) {
        String grantType = request.getGrantType();
        if (StringUtils.isBlank((String)grantType) || !GRANT_TYPES.contains(grantType)) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.UNSUPPORTED_GRANT_TYPE);
        }
    }

    protected void validateAttributes(AccessTokenRequest request) {
        String grantType = request.getGrantType();
        if ("authorization_code".equals(grantType)) {
            if (StringUtils.isBlank((String)request.getCode())) {
                throw new ValidationResponseException(OAuth2Validator.ValidationResponse.INVALID_GRANT_AUTHORIZATION_CODE);
            }
        } else if ("refresh_token".equals(grantType) && StringUtils.isBlank((String)request.getRefreshToken())) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.INVALID_GRANT_REFRESH_TOKEN);
        }
    }

    protected void validateAccessTokenRequest(AccessTokenRequest accessTokenRequest) {
    }

    static {
        RESPONSE_TYPES.add("token");
        RESPONSE_TYPES.add("code");
        GRANT_TYPES.add("authorization_code");
        GRANT_TYPES.add("refresh_token");
    }
}

