/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.surfnet.oaaas.auth.AbstractUserConsentHandler;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.repository.AuthorizationRequestRepository;

@Named
public class UserConsentFilter
implements Filter {
    private static final String RETURN_URI = "/oauth2/consent";
    @Inject
    private AuthorizationRequestRepository authorizationRequestRepository;
    private AbstractUserConsentHandler userConsentHandler;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        AuthorizationRequest authorizationRequest = this.findAuthorizationRequest(request);
        if (authorizationRequest == null) {
            response.sendError(400, "No valid AbstractAuthenticator.AUTH_STATE on the Request");
        }
        if (this.initialRequest(request)) {
            this.storePrincipal(request, response, authorizationRequest);
            request.setAttribute("RETURN_URI", (Object)RETURN_URI);
            request.setAttribute("CLIENT", (Object)authorizationRequest.getClient());
            if (!authorizationRequest.getClient().isSkipConsent()) {
                this.userConsentHandler.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            this.userConsentHandler.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
    }

    private AuthorizationRequest findAuthorizationRequest(HttpServletRequest request) {
        String authState = (String)request.getAttribute("AUTH_STATE");
        if (StringUtils.isBlank((String)authState)) {
            authState = request.getParameter("AUTH_STATE");
        }
        return this.authorizationRequestRepository.findByAuthState(authState);
    }

    private void storePrincipal(HttpServletRequest request, HttpServletResponse response, AuthorizationRequest authorizationRequest) throws IOException {
        AuthenticatedPrincipal principal = (AuthenticatedPrincipal)request.getAttribute("PRINCIPAL");
        if (principal == null) {
            response.sendError(400, "No valid AbstractAuthenticator.PRINCIPAL on the Request");
        }
        authorizationRequest.setPrincipal(principal);
        this.authorizationRequestRepository.save(authorizationRequest);
    }

    private boolean initialRequest(HttpServletRequest request) {
        return (AuthenticatedPrincipal)request.getAttribute("PRINCIPAL") != null;
    }

    public void setAuthorizationRequestRepository(AuthorizationRequestRepository authorizationRequestRepository) {
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public void setUserConsentHandler(AbstractUserConsentHandler userConsentHandler) {
        this.userConsentHandler = userConsentHandler;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

