/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth.principal;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class UserPassCredentials {
    private static final char SEMI_COLON = ':';
    private static final int BASIC_AUTH_PREFIX_LENGTH = "Basic ".length();
    private String username;
    private String password;

    public UserPassCredentials(String authorizationHeader) {
        if (authorizationHeader == null || authorizationHeader.length() < BASIC_AUTH_PREFIX_LENGTH) {
            this.noValidAuthHeader();
            return;
        }
        String authPart = authorizationHeader.substring(BASIC_AUTH_PREFIX_LENGTH);
        String userpass = new String(Base64.decodeBase64((String)authPart));
        if (userpass.indexOf(58) < 1) {
            this.noValidAuthHeader();
            return;
        }
        this.username = userpass.substring(0, userpass.indexOf(58));
        this.password = userpass.substring(userpass.indexOf(58) + 1);
    }

    public UserPassCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private void noValidAuthHeader() {
        this.username = null;
        this.password = null;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "UserPassCredentials [username=" + this.username + "]";
    }
}

