/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.springframework.util.Assert;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.model.AbstractEntity;
import org.surfnet.oaaas.model.Client;

@Entity
@Table(name="accesstoken")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class AccessToken
extends AbstractEntity
implements PersistenceCapable {
    @Column(unique=true)
    @NotNull
    private String token;
    @Column(unique=true, nullable=true)
    private String refreshToken;
    @Transient
    @XmlTransient
    private AuthenticatedPrincipal principal;
    @Column(length=1024)
    @NotNull
    @XmlTransient
    private String encodedPrincipal;
    @ManyToOne(optional=false)
    @JoinColumn(name="client_id", nullable=false, updatable=false)
    @XmlTransient
    private Client client;
    @Column
    private long expires;
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> scopes;
    @Column
    @NotNull
    private String resourceOwnerId;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AbstractEntity;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$Client;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AccessToken;
    private static final long serialVersionUID;

    public AccessToken() {
    }

    public AccessToken(String token, AuthenticatedPrincipal principal, Client client, long expires, List<String> scopes) {
        this(token, principal, client, expires, scopes, null);
    }

    public AccessToken(String token, AuthenticatedPrincipal principal, Client client, long expires, List<String> scopes, String refreshToken) {
        this.token = token;
        this.principal = principal;
        this.encodePrincipal();
        this.resourceOwnerId = principal.getName();
        this.client = client;
        this.expires = expires;
        this.scopes = scopes;
        this.refreshToken = refreshToken;
        this.invariant();
    }

    private void invariant() {
        Assert.notNull((Object)AccessToken.pcGettoken(this), (String)"Token may not be null");
        Assert.notNull((Object)AccessToken.pcGetclient(this), (String)"Client may not be null");
        Assert.notNull((Object)this.principal, (String)"AuthenticatedPrincipal may not be null");
        Assert.isTrue((boolean)StringUtils.isNotBlank((String)this.principal.getName()), (String)"AuthenticatedPrincipal#name may not be null");
    }

    @PreUpdate
    @PrePersist
    public void encodePrincipal() {
        if (this.principal != null) {
            byte[] binaryData = SerializationUtils.serialize((Serializable)this.principal);
            AccessToken.pcSetencodedPrincipal(this, new String(Base64.encodeBase64((byte[])binaryData)));
        }
    }

    @PostLoad
    @PostPersist
    @PostUpdate
    public void decodePrincipal() {
        if (StringUtils.isNotBlank((String)AccessToken.pcGetencodedPrincipal(this))) {
            byte[] objectData = Base64.decodeBase64((String)AccessToken.pcGetencodedPrincipal(this));
            this.principal = (AuthenticatedPrincipal)SerializationUtils.deserialize((byte[])objectData);
        }
    }

    public String getToken() {
        return AccessToken.pcGettoken(this);
    }

    public void setToken(String token) {
        AccessToken.pcSettoken(this, token);
    }

    public Client getClient() {
        return AccessToken.pcGetclient(this);
    }

    public void setClient(Client client) {
        AccessToken.pcSetclient(this, client);
    }

    public long getExpires() {
        return AccessToken.pcGetexpires(this);
    }

    public void setExpires(long expires) {
        AccessToken.pcSetexpires(this, expires);
    }

    public List<String> getScopes() {
        return AccessToken.pcGetscopes(this);
    }

    public void setScopes(List<String> scopes) {
        AccessToken.pcSetscopes(this, scopes);
    }

    public AuthenticatedPrincipal getPrincipal() {
        return this.principal;
    }

    public String getEncodedPrincipal() {
        return AccessToken.pcGetencodedPrincipal(this);
    }

    public String getRefreshToken() {
        return AccessToken.pcGetrefreshToken(this);
    }

    public void setRefreshToken(String refreshToken) {
        AccessToken.pcSetrefreshToken(this, refreshToken);
    }

    public String getResourceOwnerId() {
        return AccessToken.pcGetresourceOwnerId(this);
    }

    @XmlElement
    public String getClientId() {
        return AccessToken.pcGetclient(this).getClientId();
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        serialVersionUID = -4492901611266273580L;
        pcInheritedFieldCount = AbstractEntity.pcGetManagedFieldCount();
        Class clazz = class$Lorg$surfnet$oaaas$model$AbstractEntity != null ? class$Lorg$surfnet$oaaas$model$AbstractEntity : (class$Lorg$surfnet$oaaas$model$AbstractEntity = AccessToken.class$("org.surfnet.oaaas.model.AbstractEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"client", "encodedPrincipal", "expires", "refreshToken", "resourceOwnerId", "scopes", "token"};
        Class[] classArray = new Class[7];
        Class clazz2 = class$Lorg$surfnet$oaaas$model$Client != null ? class$Lorg$surfnet$oaaas$model$Client : (class$Lorg$surfnet$oaaas$model$Client = AccessToken.class$("org.surfnet.oaaas.model.Client"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AccessToken.class$("java.lang.String"));
        classArray[1] = clazz3;
        classArray[2] = Long.TYPE;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AccessToken.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AccessToken.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AccessToken.class$("java.util.List"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AccessToken.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 10, 26};
        Class clazz5 = class$Lorg$surfnet$oaaas$model$AccessToken != null ? class$Lorg$surfnet$oaaas$model$AccessToken : (class$Lorg$surfnet$oaaas$model$AccessToken = AccessToken.class$("org.surfnet.oaaas.model.AccessToken"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AccessToken", (PersistenceCapable)new AccessToken());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.client = null;
        this.encodedPrincipal = null;
        this.expires = 0L;
        this.refreshToken = null;
        this.resourceOwnerId = null;
        this.scopes = null;
        this.token = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AccessToken accessToken = new AccessToken();
        if (bl) {
            accessToken.pcClearFields();
        }
        accessToken.pcStateManager = stateManager;
        accessToken.pcCopyKeyFieldsFromObjectId(object);
        return accessToken;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AccessToken accessToken = new AccessToken();
        if (bl) {
            accessToken.pcClearFields();
        }
        accessToken.pcStateManager = stateManager;
        return accessToken;
    }

    protected static int pcGetManagedFieldCount() {
        return 7 + AbstractEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.client = (Client)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.encodedPrincipal = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.expires = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.refreshToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.resourceOwnerId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.scopes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.token = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.client);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.encodedPrincipal);
                return;
            }
            case 2: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.expires);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.refreshToken);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.resourceOwnerId);
                return;
            }
            case 5: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.scopes);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.token);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AccessToken accessToken, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(accessToken, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.client = accessToken.client;
                return;
            }
            case 1: {
                this.encodedPrincipal = accessToken.encodedPrincipal;
                return;
            }
            case 2: {
                this.expires = accessToken.expires;
                return;
            }
            case 3: {
                this.refreshToken = accessToken.refreshToken;
                return;
            }
            case 4: {
                this.resourceOwnerId = accessToken.resourceOwnerId;
                return;
            }
            case 5: {
                this.scopes = accessToken.scopes;
                return;
            }
            case 6: {
                this.token = accessToken.token;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        AccessToken accessToken = (AccessToken)object;
        if (accessToken.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(accessToken, nArray[n]);
            ++n;
        }
    }

    private static final Client pcGetclient(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.client;
        }
        int n = pcInheritedFieldCount + 0;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.client;
    }

    private static final void pcSetclient(AccessToken accessToken, Client client) {
        if (accessToken.pcStateManager == null) {
            accessToken.client = client;
            return;
        }
        accessToken.pcStateManager.settingObjectField((PersistenceCapable)accessToken, pcInheritedFieldCount + 0, (Object)accessToken.client, (Object)client, 0);
    }

    private static final String pcGetencodedPrincipal(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.encodedPrincipal;
        }
        int n = pcInheritedFieldCount + 1;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.encodedPrincipal;
    }

    private static final void pcSetencodedPrincipal(AccessToken accessToken, String string) {
        if (accessToken.pcStateManager == null) {
            accessToken.encodedPrincipal = string;
            return;
        }
        accessToken.pcStateManager.settingStringField((PersistenceCapable)accessToken, pcInheritedFieldCount + 1, accessToken.encodedPrincipal, string, 0);
    }

    private static final long pcGetexpires(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.expires;
        }
        int n = pcInheritedFieldCount + 2;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.expires;
    }

    private static final void pcSetexpires(AccessToken accessToken, long l) {
        if (accessToken.pcStateManager == null) {
            accessToken.expires = l;
            return;
        }
        accessToken.pcStateManager.settingLongField((PersistenceCapable)accessToken, pcInheritedFieldCount + 2, accessToken.expires, l, 0);
    }

    private static final String pcGetrefreshToken(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.refreshToken;
        }
        int n = pcInheritedFieldCount + 3;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.refreshToken;
    }

    private static final void pcSetrefreshToken(AccessToken accessToken, String string) {
        if (accessToken.pcStateManager == null) {
            accessToken.refreshToken = string;
            return;
        }
        accessToken.pcStateManager.settingStringField((PersistenceCapable)accessToken, pcInheritedFieldCount + 3, accessToken.refreshToken, string, 0);
    }

    private static final String pcGetresourceOwnerId(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.resourceOwnerId;
        }
        int n = pcInheritedFieldCount + 4;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.resourceOwnerId;
    }

    private static final void pcSetresourceOwnerId(AccessToken accessToken, String string) {
        if (accessToken.pcStateManager == null) {
            accessToken.resourceOwnerId = string;
            return;
        }
        accessToken.pcStateManager.settingStringField((PersistenceCapable)accessToken, pcInheritedFieldCount + 4, accessToken.resourceOwnerId, string, 0);
    }

    private static final List pcGetscopes(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.scopes;
        }
        int n = pcInheritedFieldCount + 5;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.scopes;
    }

    private static final void pcSetscopes(AccessToken accessToken, List list) {
        if (accessToken.pcStateManager == null) {
            accessToken.scopes = list;
            return;
        }
        accessToken.pcStateManager.settingObjectField((PersistenceCapable)accessToken, pcInheritedFieldCount + 5, accessToken.scopes, (Object)list, 0);
    }

    private static final String pcGettoken(AccessToken accessToken) {
        if (accessToken.pcStateManager == null) {
            return accessToken.token;
        }
        int n = pcInheritedFieldCount + 6;
        accessToken.pcStateManager.accessingField(n);
        return accessToken.token;
    }

    private static final void pcSettoken(AccessToken accessToken, String string) {
        if (accessToken.pcStateManager == null) {
            accessToken.token = string;
            return;
        }
        accessToken.pcStateManager.settingStringField((PersistenceCapable)accessToken, pcInheritedFieldCount + 6, accessToken.token, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

