/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource;

import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.auth.principal.UserPassCredentials;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.model.ResourceServer;
import org.surfnet.oaaas.model.VerifyTokenResponse;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.repository.ResourceServerRepository;

@Named
@Path(value="/tokeninfo")
@Produces(value={"application/json"})
public class VerifyResource {
    private static final Logger LOG = LoggerFactory.getLogger(VerifyResource.class);
    @Inject
    private AccessTokenRepository accessTokenRepository;
    @Inject
    private ResourceServerRepository resourceServerRepository;

    @GET
    public Response verifyToken(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="access_token") String accessToken) {
        UserPassCredentials credentials = new UserPassCredentials(authorization);
        ResourceServer resourceServer = this.getResourceServer(credentials);
        if (resourceServer == null || !resourceServer.getSecret().equals(credentials.getPassword())) {
            LOG.warn("Responding with 401 in VerifyResource#verifyToken for user {}", (Object)credentials);
            return this.unauthorized();
        }
        AccessToken token = this.accessTokenRepository.findByToken(accessToken);
        if (token == null || !resourceServer.containsClient(token.getClient())) {
            LOG.warn("Responding with 404 in VerifyResource#verifyToken for user {}", (Object)credentials);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)new VerifyTokenResponse("not_found")).build();
        }
        if (this.tokenExpired(token)) {
            LOG.warn("Responding with 410 in VerifyResource#verifyToken for user {}", (Object)credentials);
            return Response.status((Response.Status)Response.Status.GONE).entity((Object)new VerifyTokenResponse("token_expired")).build();
        }
        VerifyTokenResponse verifyTokenResponse = new VerifyTokenResponse(token.getClient().getName(), token.getScopes(), token.getPrincipal(), token.getExpires());
        LOG.debug("Responding with 200 in VerifyResource#verifyToken for user {}", (Object)credentials);
        return Response.ok((Object)verifyTokenResponse).build();
    }

    private boolean tokenExpired(AccessToken token) {
        return token.getExpires() != 0L && token.getExpires() < System.currentTimeMillis();
    }

    private ResourceServer getResourceServer(UserPassCredentials credentials) {
        String key = credentials.getUsername();
        return this.resourceServerRepository.findByKey(key);
    }

    protected Response unauthorized() {
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"OAuth2 Secure\"").build();
    }

    public void setAccessTokenRepository(AccessTokenRepository accessTokenRepository) {
        this.accessTokenRepository = accessTokenRepository;
    }

    public void setResourceServerRepository(ResourceServerRepository resourceServerRepository) {
        this.resourceServerRepository = resourceServerRepository;
    }
}

