/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Unique;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.model.AbstractEntity;
import org.surfnet.oaaas.model.Client;

@Entity
@Table(name="authorizationrequest")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AuthorizationRequest
extends AbstractEntity
implements PersistenceCapable {
    @Column
    @NotNull
    private String responseType;
    @Transient
    private String clientId;
    @Transient
    private AuthenticatedPrincipal principal;
    @Lob
    @Column(length=16384)
    private String encodedPrincipal;
    @ManyToOne(optional=false)
    @JoinColumn(name="client_id", nullable=false, updatable=false)
    private Client client;
    @Column
    @NotNull
    private String redirectUri;
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> requestedScopes = new ArrayList<String>();
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> grantedScopes = new ArrayList<String>();
    @Column
    private String state;
    @Column
    @NotNull
    @Unique
    private String authState;
    @Column
    @Unique
    private String authorizationCode;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AbstractEntity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$Client;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AuthorizationRequest;
    private static final long serialVersionUID;

    public AuthorizationRequest() {
    }

    public AuthorizationRequest(String responseType, String clientId, String redirectUri, List<String> requestedScopes, String state, String authState) {
        this.responseType = responseType;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.requestedScopes = requestedScopes;
        this.state = state;
        this.authState = authState;
    }

    @PreUpdate
    @PrePersist
    public void encodePrincipal() {
        if (this.principal != null) {
            AuthorizationRequest.pcSetencodedPrincipal(this, this.principal.serialize());
        }
    }

    @PostLoad
    @PostPersist
    @PostUpdate
    public void decodePrincipal() {
        if (StringUtils.isNotBlank((String)AuthorizationRequest.pcGetencodedPrincipal(this))) {
            this.principal = AuthenticatedPrincipal.deserialize((String)AuthorizationRequest.pcGetencodedPrincipal(this));
        }
    }

    public String getResponseType() {
        return AuthorizationRequest.pcGetresponseType(this);
    }

    public void setResponseType(String responseType) {
        AuthorizationRequest.pcSetresponseType(this, responseType);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return AuthorizationRequest.pcGetredirectUri(this);
    }

    public void setRedirectUri(String redirectUri) {
        AuthorizationRequest.pcSetredirectUri(this, redirectUri);
    }

    public List<String> getRequestedScopes() {
        return AuthorizationRequest.pcGetrequestedScopes(this);
    }

    public void setRequestedScopes(List<String> requestedScopes) {
        AuthorizationRequest.pcSetrequestedScopes(this, requestedScopes);
    }

    public List<String> getGrantedScopes() {
        return AuthorizationRequest.pcGetgrantedScopes(this);
    }

    public void setGrantedScopes(List<String> grantedScopes) {
        AuthorizationRequest.pcSetgrantedScopes(this, grantedScopes);
    }

    public String getState() {
        return AuthorizationRequest.pcGetstate(this);
    }

    public void setState(String state) {
        AuthorizationRequest.pcSetstate(this, state);
    }

    public String getAuthState() {
        return AuthorizationRequest.pcGetauthState(this);
    }

    public void setAuthState(String authState) {
        AuthorizationRequest.pcSetauthState(this, authState);
    }

    public Client getClient() {
        return AuthorizationRequest.pcGetclient(this);
    }

    public void setClient(Client client) {
        AuthorizationRequest.pcSetclient(this, client);
    }

    public String getAuthorizationCode() {
        return AuthorizationRequest.pcGetauthorizationCode(this);
    }

    public void setAuthorizationCode(String authorizationCode) {
        AuthorizationRequest.pcSetauthorizationCode(this, authorizationCode);
    }

    public AuthenticatedPrincipal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(AuthenticatedPrincipal principal) {
        this.principal = principal;
        this.encodePrincipal();
    }

    public String getEncodedPrincipal() {
        return AuthorizationRequest.pcGetencodedPrincipal(this);
    }

    @Override
    public boolean validate(ConstraintValidatorContext context) {
        if (StringUtils.isNotBlank((String)AuthorizationRequest.pcGetredirectUri(this)) && AuthorizationRequest.pcGetredirectUri(this).contains("#")) {
            context.buildConstraintViolationWithTemplate("Fragment component is not allowed in redirectUri").addConstraintViolation();
            return false;
        }
        return true;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        serialVersionUID = -3740274101438581520L;
        pcInheritedFieldCount = AbstractEntity.pcGetManagedFieldCount();
        Class clazz = class$Lorg$surfnet$oaaas$model$AbstractEntity != null ? class$Lorg$surfnet$oaaas$model$AbstractEntity : (class$Lorg$surfnet$oaaas$model$AbstractEntity = AuthorizationRequest.class$("org.surfnet.oaaas.model.AbstractEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"authState", "authorizationCode", "client", "encodedPrincipal", "grantedScopes", "redirectUri", "requestedScopes", "responseType", "state"};
        Class[] classArray = new Class[9];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        Class clazz3 = class$Lorg$surfnet$oaaas$model$Client != null ? class$Lorg$surfnet$oaaas$model$Client : (class$Lorg$surfnet$oaaas$model$Client = AuthorizationRequest.class$("org.surfnet.oaaas.model.Client"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AuthorizationRequest.class$("java.util.List"));
        classArray[4] = clazz4;
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        classArray[6] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = AuthorizationRequest.class$("java.util.List"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = AuthorizationRequest.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 10, 26, 10, 26, 26};
        Class clazz5 = class$Lorg$surfnet$oaaas$model$AuthorizationRequest != null ? class$Lorg$surfnet$oaaas$model$AuthorizationRequest : (class$Lorg$surfnet$oaaas$model$AuthorizationRequest = AuthorizationRequest.class$("org.surfnet.oaaas.model.AuthorizationRequest"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"AuthorizationRequest", (PersistenceCapable)new AuthorizationRequest());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authState = null;
        this.authorizationCode = null;
        this.client = null;
        this.encodedPrincipal = null;
        this.grantedScopes = null;
        this.redirectUri = null;
        this.requestedScopes = null;
        this.responseType = null;
        this.state = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest();
        if (bl) {
            authorizationRequest.pcClearFields();
        }
        authorizationRequest.pcStateManager = stateManager;
        authorizationRequest.pcCopyKeyFieldsFromObjectId(object);
        return authorizationRequest;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        AuthorizationRequest authorizationRequest = new AuthorizationRequest();
        if (bl) {
            authorizationRequest.pcClearFields();
        }
        authorizationRequest.pcStateManager = stateManager;
        return authorizationRequest;
    }

    protected static int pcGetManagedFieldCount() {
        return 9 + AbstractEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authState = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.authorizationCode = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.client = (Client)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.encodedPrincipal = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.grantedScopes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.redirectUri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.requestedScopes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.responseType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.state = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authState);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authorizationCode);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.client);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.encodedPrincipal);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.grantedScopes);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.redirectUri);
                return;
            }
            case 6: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.requestedScopes);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.responseType);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.state);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(AuthorizationRequest authorizationRequest, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(authorizationRequest, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authState = authorizationRequest.authState;
                return;
            }
            case 1: {
                this.authorizationCode = authorizationRequest.authorizationCode;
                return;
            }
            case 2: {
                this.client = authorizationRequest.client;
                return;
            }
            case 3: {
                this.encodedPrincipal = authorizationRequest.encodedPrincipal;
                return;
            }
            case 4: {
                this.grantedScopes = authorizationRequest.grantedScopes;
                return;
            }
            case 5: {
                this.redirectUri = authorizationRequest.redirectUri;
                return;
            }
            case 6: {
                this.requestedScopes = authorizationRequest.requestedScopes;
                return;
            }
            case 7: {
                this.responseType = authorizationRequest.responseType;
                return;
            }
            case 8: {
                this.state = authorizationRequest.state;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        AuthorizationRequest authorizationRequest = (AuthorizationRequest)object;
        if (authorizationRequest.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(authorizationRequest, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetauthState(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.authState;
        }
        int n = pcInheritedFieldCount + 0;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.authState;
    }

    private static final void pcSetauthState(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.authState = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 0, authorizationRequest.authState, string, 0);
    }

    private static final String pcGetauthorizationCode(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.authorizationCode;
        }
        int n = pcInheritedFieldCount + 1;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.authorizationCode;
    }

    private static final void pcSetauthorizationCode(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.authorizationCode = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 1, authorizationRequest.authorizationCode, string, 0);
    }

    private static final Client pcGetclient(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.client;
        }
        int n = pcInheritedFieldCount + 2;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.client;
    }

    private static final void pcSetclient(AuthorizationRequest authorizationRequest, Client client) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.client = client;
            return;
        }
        authorizationRequest.pcStateManager.settingObjectField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 2, (Object)authorizationRequest.client, (Object)client, 0);
    }

    private static final String pcGetencodedPrincipal(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.encodedPrincipal;
        }
        int n = pcInheritedFieldCount + 3;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.encodedPrincipal;
    }

    private static final void pcSetencodedPrincipal(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.encodedPrincipal = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 3, authorizationRequest.encodedPrincipal, string, 0);
    }

    private static final List pcGetgrantedScopes(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.grantedScopes;
        }
        int n = pcInheritedFieldCount + 4;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.grantedScopes;
    }

    private static final void pcSetgrantedScopes(AuthorizationRequest authorizationRequest, List list) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.grantedScopes = list;
            return;
        }
        authorizationRequest.pcStateManager.settingObjectField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 4, authorizationRequest.grantedScopes, (Object)list, 0);
    }

    private static final String pcGetredirectUri(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.redirectUri;
        }
        int n = pcInheritedFieldCount + 5;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.redirectUri;
    }

    private static final void pcSetredirectUri(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.redirectUri = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 5, authorizationRequest.redirectUri, string, 0);
    }

    private static final List pcGetrequestedScopes(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.requestedScopes;
        }
        int n = pcInheritedFieldCount + 6;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.requestedScopes;
    }

    private static final void pcSetrequestedScopes(AuthorizationRequest authorizationRequest, List list) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.requestedScopes = list;
            return;
        }
        authorizationRequest.pcStateManager.settingObjectField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 6, authorizationRequest.requestedScopes, (Object)list, 0);
    }

    private static final String pcGetresponseType(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.responseType;
        }
        int n = pcInheritedFieldCount + 7;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.responseType;
    }

    private static final void pcSetresponseType(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.responseType = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 7, authorizationRequest.responseType, string, 0);
    }

    private static final String pcGetstate(AuthorizationRequest authorizationRequest) {
        if (authorizationRequest.pcStateManager == null) {
            return authorizationRequest.state;
        }
        int n = pcInheritedFieldCount + 8;
        authorizationRequest.pcStateManager.accessingField(n);
        return authorizationRequest.state;
    }

    private static final void pcSetstate(AuthorizationRequest authorizationRequest, String string) {
        if (authorizationRequest.pcStateManager == null) {
            authorizationRequest.state = string;
            return;
        }
        authorizationRequest.pcStateManager.settingStringField((PersistenceCapable)authorizationRequest, pcInheritedFieldCount + 8, authorizationRequest.state, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

