/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.collections.CollectionUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.validator.constraints.Email;
import org.surfnet.oaaas.model.AbstractEntity;
import org.surfnet.oaaas.model.Client;

@Entity
@Table(name="resourceserver", uniqueConstraints={@UniqueConstraint(columnNames={"owner", "resourceServerName"})})
@XmlRootElement
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class ResourceServer
extends AbstractEntity
implements PersistenceCapable {
    public static final String SCOPE_PATTERN = "^[^,]+$";
    @Column(name="resourceServerName")
    @NotNull
    private String name;
    @Column(unique=true, name="resourceServerKey")
    @NotNull
    private String key;
    @Column
    private String description;
    @ElementCollection(fetch=FetchType.EAGER)
    @NotNull
    private List<String> scopes = new ArrayList<String>();
    @Column
    @NotNull
    private String secret;
    @Column(nullable=false, updatable=false)
    @NotNull
    private String contactName;
    @Column
    @JsonIgnore
    private String owner;
    @Column
    @Email
    private String contactEmail;
    @JsonIgnore
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="resourceserver_id", nullable=false)
    @Valid
    private Set<Client> clients;
    @Column
    private String thumbNailUrl;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AbstractEntity;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$ResourceServer;
    private static final long serialVersionUID;

    public String getName() {
        return ResourceServer.pcGetname(this);
    }

    public void setName(String name) {
        ResourceServer.pcSetname(this, name);
    }

    public List<String> getScopes() {
        return ResourceServer.pcGetscopes(this);
    }

    public void setScopes(List<String> scopes) {
        ResourceServer.pcSetscopes(this, scopes);
    }

    public String getSecret() {
        return ResourceServer.pcGetsecret(this);
    }

    public void setSecret(String secret) {
        ResourceServer.pcSetsecret(this, secret);
    }

    public String getContactName() {
        return ResourceServer.pcGetcontactName(this);
    }

    public void setContactName(String contactName) {
        ResourceServer.pcSetcontactName(this, contactName);
    }

    public String getContactEmail() {
        return ResourceServer.pcGetcontactEmail(this);
    }

    public void setContactEmail(String contactEmail) {
        ResourceServer.pcSetcontactEmail(this, contactEmail);
    }

    public String getThumbNailUrl() {
        return ResourceServer.pcGetthumbNailUrl(this);
    }

    public void setThumbNailUrl(String thumbNailUrl) {
        ResourceServer.pcSetthumbNailUrl(this, thumbNailUrl);
    }

    public void setOwner(String owner) {
        ResourceServer.pcSetowner(this, owner);
    }

    public String getOwner() {
        return ResourceServer.pcGetowner(this);
    }

    public String getKey() {
        return ResourceServer.pcGetkey(this);
    }

    public void setKey(String key) {
        ResourceServer.pcSetkey(this, key);
    }

    public Set<Client> getClients() {
        return ResourceServer.pcGetclients(this);
    }

    public void setClients(Set<Client> clients) {
        ResourceServer.pcSetclients(this, clients);
    }

    public String getDescription() {
        return ResourceServer.pcGetdescription(this);
    }

    public void setDescription(String description) {
        ResourceServer.pcSetdescription(this, description);
    }

    public boolean containsClient(Client client) {
        this.getClients();
        return CollectionUtils.isEmpty((Collection)ResourceServer.pcGetclients(this)) ? false : ResourceServer.pcGetclients(this).contains(client);
    }

    @Override
    public boolean validate(ConstraintValidatorContext context) {
        boolean isValid = true;
        for (String scope : ResourceServer.pcGetscopes(this)) {
            if (scope.matches(SCOPE_PATTERN)) continue;
            this.violation(context, "Scope '" + scope + "' contains invalid characters");
            isValid = false;
        }
        return isValid;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        serialVersionUID = -3571840078134263170L;
        pcInheritedFieldCount = AbstractEntity.pcGetManagedFieldCount();
        Class clazz = class$Lorg$surfnet$oaaas$model$AbstractEntity != null ? class$Lorg$surfnet$oaaas$model$AbstractEntity : (class$Lorg$surfnet$oaaas$model$AbstractEntity = ResourceServer.class$("org.surfnet.oaaas.model.AbstractEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"clients", "contactEmail", "contactName", "description", "key", "name", "owner", "scopes", "secret", "thumbNailUrl"};
        Class[] classArray = new Class[10];
        Class clazz2 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = ResourceServer.class$("java.util.Set"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[1] = clazz3;
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        Class clazz4 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = ResourceServer.class$("java.util.List"));
        classArray[7] = clazz4;
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ResourceServer.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{10, 26, 26, 26, 26, 26, 26, 10, 26, 26};
        Class clazz5 = class$Lorg$surfnet$oaaas$model$ResourceServer != null ? class$Lorg$surfnet$oaaas$model$ResourceServer : (class$Lorg$surfnet$oaaas$model$ResourceServer = ResourceServer.class$("org.surfnet.oaaas.model.ResourceServer"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"ResourceServer", (PersistenceCapable)new ResourceServer());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.clients = null;
        this.contactEmail = null;
        this.contactName = null;
        this.description = null;
        this.key = null;
        this.name = null;
        this.owner = null;
        this.scopes = null;
        this.secret = null;
        this.thumbNailUrl = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        ResourceServer resourceServer = new ResourceServer();
        if (bl) {
            resourceServer.pcClearFields();
        }
        resourceServer.pcStateManager = stateManager;
        resourceServer.pcCopyKeyFieldsFromObjectId(object);
        return resourceServer;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        ResourceServer resourceServer = new ResourceServer();
        if (bl) {
            resourceServer.pcClearFields();
        }
        resourceServer.pcStateManager = stateManager;
        return resourceServer;
    }

    protected static int pcGetManagedFieldCount() {
        return 10 + AbstractEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.clients = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.contactEmail = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.contactName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.key = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.owner = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.scopes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.secret = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.thumbNailUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.clients);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.contactEmail);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.contactName);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.key);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.owner);
                return;
            }
            case 7: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.scopes);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.secret);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.thumbNailUrl);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(ResourceServer resourceServer, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(resourceServer, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.clients = resourceServer.clients;
                return;
            }
            case 1: {
                this.contactEmail = resourceServer.contactEmail;
                return;
            }
            case 2: {
                this.contactName = resourceServer.contactName;
                return;
            }
            case 3: {
                this.description = resourceServer.description;
                return;
            }
            case 4: {
                this.key = resourceServer.key;
                return;
            }
            case 5: {
                this.name = resourceServer.name;
                return;
            }
            case 6: {
                this.owner = resourceServer.owner;
                return;
            }
            case 7: {
                this.scopes = resourceServer.scopes;
                return;
            }
            case 8: {
                this.secret = resourceServer.secret;
                return;
            }
            case 9: {
                this.thumbNailUrl = resourceServer.thumbNailUrl;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        ResourceServer resourceServer = (ResourceServer)object;
        if (resourceServer.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(resourceServer, nArray[n]);
            ++n;
        }
    }

    private static final Set pcGetclients(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.clients;
        }
        int n = pcInheritedFieldCount + 0;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.clients;
    }

    private static final void pcSetclients(ResourceServer resourceServer, Set set) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.clients = set;
            return;
        }
        resourceServer.pcStateManager.settingObjectField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 0, resourceServer.clients, (Object)set, 0);
    }

    private static final String pcGetcontactEmail(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.contactEmail;
        }
        int n = pcInheritedFieldCount + 1;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.contactEmail;
    }

    private static final void pcSetcontactEmail(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.contactEmail = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 1, resourceServer.contactEmail, string, 0);
    }

    private static final String pcGetcontactName(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.contactName;
        }
        int n = pcInheritedFieldCount + 2;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.contactName;
    }

    private static final void pcSetcontactName(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.contactName = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 2, resourceServer.contactName, string, 0);
    }

    private static final String pcGetdescription(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.description;
        }
        int n = pcInheritedFieldCount + 3;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.description;
    }

    private static final void pcSetdescription(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.description = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 3, resourceServer.description, string, 0);
    }

    private static final String pcGetkey(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.key;
        }
        int n = pcInheritedFieldCount + 4;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.key;
    }

    private static final void pcSetkey(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.key = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 4, resourceServer.key, string, 0);
    }

    private static final String pcGetname(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.name;
        }
        int n = pcInheritedFieldCount + 5;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.name;
    }

    private static final void pcSetname(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.name = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 5, resourceServer.name, string, 0);
    }

    private static final String pcGetowner(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.owner;
        }
        int n = pcInheritedFieldCount + 6;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.owner;
    }

    private static final void pcSetowner(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.owner = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 6, resourceServer.owner, string, 0);
    }

    private static final List pcGetscopes(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.scopes;
        }
        int n = pcInheritedFieldCount + 7;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.scopes;
    }

    private static final void pcSetscopes(ResourceServer resourceServer, List list) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.scopes = list;
            return;
        }
        resourceServer.pcStateManager.settingObjectField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 7, resourceServer.scopes, (Object)list, 0);
    }

    private static final String pcGetsecret(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.secret;
        }
        int n = pcInheritedFieldCount + 8;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.secret;
    }

    private static final void pcSetsecret(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.secret = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 8, resourceServer.secret, string, 0);
    }

    private static final String pcGetthumbNailUrl(ResourceServer resourceServer) {
        if (resourceServer.pcStateManager == null) {
            return resourceServer.thumbNailUrl;
        }
        int n = pcInheritedFieldCount + 9;
        resourceServer.pcStateManager.accessingField(n);
        return resourceServer.thumbNailUrl;
    }

    private static final void pcSetthumbNailUrl(ResourceServer resourceServer, String string) {
        if (resourceServer.pcStateManager == null) {
            resourceServer.thumbNailUrl = string;
            return;
        }
        resourceServer.pcStateManager.settingStringField((PersistenceCapable)resourceServer, pcInheritedFieldCount + 9, resourceServer.thumbNailUrl, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

