/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.repository;

import javax.persistence.EntityExistsException;
import javax.persistence.PersistenceException;
import javax.validation.ConstraintViolationException;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.repository.ExceptionTranslator;

public class OpenJPAExceptionTranslator
implements ExceptionTranslator {
    private static final Logger LOG = LoggerFactory.getLogger(OpenJPAExceptionTranslator.class);

    @Override
    public Exception translate(Throwable e) {
        if (e.getCause() != null && this.isRelevantCause(e.getCause())) {
            return this.translate(e.getCause());
        }
        Class<?> c = e.getClass();
        if (c.equals(org.apache.openjpa.persistence.EntityExistsException.class)) {
            return new EntityExistsException(e.getMessage(), e);
        }
        if (c.equals(ConstraintViolationException.class)) {
            return (Exception)e;
        }
        LOG.info("Cannot translate '{}' to specific subtype, will return generic PersistenceException", (Object)e.getClass().getName());
        return new PersistenceException(e);
    }

    private boolean isRelevantCause(Throwable cause) {
        return !(cause instanceof ReportingSQLException);
    }
}

