/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource.resourceserver;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.model.ResourceServer;
import org.surfnet.oaaas.repository.ClientRepository;
import org.surfnet.oaaas.repository.ResourceServerRepository;
import org.surfnet.oaaas.resource.AbstractResource;

@Named
@Path(value="/resourceServer/{resourceServerId}/client")
@Produces(value={"application/json"})
public class ClientResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(ClientResource.class);
    private static final String FILTERED_CLIENT_ID_CHARS = "[^a-z0-9_\\x2D]";
    @Inject
    private ClientRepository clientRepository;
    @Inject
    private ResourceServerRepository resourceServerRepository;

    @GET
    public Response getAll(@Context HttpServletRequest request, @PathParam(value="resourceServerId") Long resourceServerId) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(resourceServerId, owner);
        List<Client> clients = this.clientRepository.findByResourceServer(resourceServer);
        Response.ResponseBuilder responseBuilder = clients == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok(clients);
        return responseBuilder.build();
    }

    @GET
    @Path(value="/{clientId}")
    public Response getById(@Context HttpServletRequest request, @PathParam(value="resourceServerId") Long resourceServerId, @PathParam(value="clientId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(resourceServerId, owner);
        Client client = this.clientRepository.findByIdAndResourceServer(id, resourceServer);
        Response.ResponseBuilder responseBuilder = client == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)client);
        return responseBuilder.build();
    }

    @PUT
    public Response put(@Context HttpServletRequest request, @PathParam(value="resourceServerId") Long resourceServerId, Client client) {
        Client clientSaved;
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(resourceServerId, owner);
        client.setResourceServer(resourceServer);
        client.setClientId(this.generateClientId(client));
        client.setSecret(client.isAllowedImplicitGrant() ? null : this.generateSecret());
        try {
            clientSaved = (Client)this.clientRepository.save(client);
        }
        catch (RuntimeException e) {
            return this.buildErrorResponse(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saved client: {}", (Object)clientSaved);
        }
        URI uri = UriBuilder.fromPath((String)"{clientId}.json").build(new Object[]{clientSaved.getId()});
        return Response.created((URI)uri).entity((Object)clientSaved).build();
    }

    protected String generateSecret() {
        return super.generateRandom();
    }

    @DELETE
    @Path(value="/{clientId}")
    public Response delete(@Context HttpServletRequest request, @PathParam(value="clientId") Long id, @PathParam(value="resourceServerId") Long resourceServerId) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(resourceServerId, owner);
        Client client = this.clientRepository.findByIdAndResourceServer(id, resourceServer);
        if (client == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting client: {}", (Object)client);
        }
        this.clientRepository.delete(id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{clientId}")
    public Response post(@Valid Client newOne, @PathParam(value="clientId") Long id, @Context HttpServletRequest request, @PathParam(value="resourceServerId") Long resourceServerId) {
        Client savedInstance;
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(resourceServerId, owner);
        Client clientFromStore = this.clientRepository.findByIdAndResourceServer(id, resourceServer);
        if (clientFromStore == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        newOne.setResourceServer(resourceServer);
        newOne.setClientId(clientFromStore.getClientId());
        newOne.setSecret(newOne.isAllowedImplicitGrant() ? null : clientFromStore.getSecret());
        try {
            savedInstance = (Client)this.clientRepository.save(newOne);
        }
        catch (RuntimeException e) {
            return this.buildErrorResponse(e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Saving client: {}", (Object)savedInstance);
        }
        return Response.ok((Object)savedInstance).build();
    }

    protected String generateClientId(Client client) {
        String clientId = this.sanitizeClientName(client.getName());
        if (this.clientRepository.findByClientId(clientId) != null) {
            String baseClientId = clientId;
            int i = 2;
            while (this.clientRepository.findByClientId(clientId = baseClientId + i++) != null) {
            }
        }
        return clientId;
    }

    protected String sanitizeClientName(String name) {
        return name.toLowerCase().replaceAll(" ", "-").replaceAll(FILTERED_CLIENT_ID_CHARS, "");
    }
}

