/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource.resourceserver;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.model.ResourceServer;
import org.surfnet.oaaas.model.StatisticsResponse;
import org.surfnet.oaaas.model.VerifyTokenResponse;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.repository.ClientRepository;
import org.surfnet.oaaas.repository.ResourceServerRepository;
import org.surfnet.oaaas.resource.AbstractResource;

@Named
@Path(value="/resourceServer")
@Produces(value={"application/json"})
@Transactional
public class ResourceServerResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceServerResource.class);
    @Inject
    private ResourceServerRepository resourceServerRepository;
    @Inject
    private AccessTokenRepository accessTokenRepository;
    @Inject
    private ClientRepository clientRepository;

    @GET
    public Response getAll(@Context HttpServletRequest request) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        List<ResourceServer> resourceServers = this.resourceServerRepository.findByOwner(owner);
        LOG.debug("About to return all resource servers ({}) for owner {}", (Object)resourceServers.size(), (Object)owner);
        return Response.ok(resourceServers).build();
    }

    @GET
    @Path(value="/{resourceServerId}")
    public Response getById(@Context HttpServletRequest request, @PathParam(value="resourceServerId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer resourceServer = this.resourceServerRepository.findByIdAndOwner(id, owner);
        Response.ResponseBuilder responseBuilder = resourceServer == null ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok((Object)resourceServer);
        LOG.debug("About to return one resourceServer with id {}: {}", (Object)id, (Object)resourceServer);
        return responseBuilder.build();
    }

    @GET
    @Path(value="/stats")
    public Response stats(@Context HttpServletRequest request) {
        String owner = this.getUserId(request);
        List<ResourceServer> resourceServers = this.resourceServerRepository.findByOwner(owner);
        ArrayList<StatisticsResponse.ResourceServerStat> resourceServerStats = new ArrayList<StatisticsResponse.ResourceServerStat>();
        for (ResourceServer resourceServer : resourceServers) {
            ArrayList<StatisticsResponse.ClientStat> clientStats = new ArrayList<StatisticsResponse.ClientStat>();
            Set<Client> clients = resourceServer.getClients();
            for (Client client : clients) {
                clientStats.add(new StatisticsResponse.ClientStat(client.getName(), client.getDescription(), this.accessTokenRepository.countByUniqueResourceOwnerIdAndClientId(client.getId())));
            }
            resourceServerStats.add(new StatisticsResponse.ResourceServerStat(resourceServer.getName(), resourceServer.getDescription(), clientStats));
        }
        return Response.ok((Object)new StatisticsResponse(resourceServerStats)).build();
    }

    @GET
    @Path(value="/principal")
    public Response principal(@Context HttpServletRequest request) {
        VerifyTokenResponse verifyTokenResponse = (VerifyTokenResponse)request.getAttribute("VERIFY_TOKEN_RESPONSE");
        return Response.ok((Object)verifyTokenResponse.getPrincipal()).build();
    }

    @PUT
    public Response put(@Context HttpServletRequest request, @Valid ResourceServer newOne) {
        ResourceServer resourceServerSaved;
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        newOne.setKey(this.generateKey());
        newOne.setSecret(this.generateSecret());
        newOne.setOwner(owner);
        try {
            this.validate(newOne);
            resourceServerSaved = (ResourceServer)this.resourceServerRepository.save(newOne);
        }
        catch (Exception e) {
            return this.buildErrorResponse(e);
        }
        LOG.debug("New resourceServer has been saved: {}. ", (Object)resourceServerSaved);
        URI uri = UriBuilder.fromPath((String)"{resourceServerId}.json").build(new Object[]{resourceServerSaved.getId()});
        return Response.created((URI)uri).entity((Object)resourceServerSaved).build();
    }

    @DELETE
    @Path(value="/{resourceServerId}")
    public Response delete(@Context HttpServletRequest request, @PathParam(value="resourceServerId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        if (this.resourceServerRepository.findByIdAndOwner(id, owner) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LOG.debug("About to delete resourceServer {}", (Object)id);
        this.resourceServerRepository.delete(id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/{resourceServerId}")
    public Response post(@Valid ResourceServer resourceServer, @Context HttpServletRequest request, @PathParam(value="resourceServerId") Long id) {
        ResourceServer savedInstance;
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        String owner = this.getUserId(request);
        ResourceServer persistedResourceServer = this.resourceServerRepository.findByIdAndOwner(id, owner);
        if (persistedResourceServer == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        resourceServer.setSecret(persistedResourceServer.getSecret());
        resourceServer.setKey(persistedResourceServer.getKey());
        resourceServer.setOwner(owner);
        this.pruneClientScopes(resourceServer.getScopes(), persistedResourceServer.getScopes(), persistedResourceServer.getClients());
        LOG.debug("About to update existing resourceServer {} with new properties: {}", (Object)persistedResourceServer, (Object)resourceServer);
        try {
            this.validate(resourceServer);
            savedInstance = (ResourceServer)this.resourceServerRepository.save(resourceServer);
        }
        catch (Exception e) {
            return this.buildErrorResponse(e);
        }
        return Response.ok((Object)savedInstance).build();
    }

    protected void pruneClientScopes(List<String> newScopes, List<String> oldScopes, Set<Client> clients) {
        if (!newScopes.containsAll(oldScopes)) {
            CollectionUtils.subtract(oldScopes, newScopes);
            Collection outdatedScopes = CollectionUtils.subtract(oldScopes, newScopes);
            LOG.info("Resource server has updated scopes. Will remove all outdated scopes from clients: {}", (Object)outdatedScopes);
            for (Client c : clients) {
                List<String> clientScopes = c.getScopes();
                if (!CollectionUtils.containsAny(clientScopes, (Collection)outdatedScopes)) continue;
                ArrayList<String> prunedScopes = new ArrayList<String>(CollectionUtils.subtract(clientScopes, (Collection)outdatedScopes));
                LOG.info("Client scopes of client {} were: {}. After pruning (because resourceServer has new scopes): {}", new Object[]{c.getClientId(), c.getScopes(), prunedScopes});
                c.setScopes(prunedScopes);
            }
        }
    }

    protected String generateKey() {
        return super.generateRandom();
    }

    protected String generateSecret() {
        return super.generateRandom();
    }
}

