/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.validation.ConstraintValidatorContext;
import javax.validation.constraints.NotNull;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.surfnet.oaaas.auth.principal.UserPassCredentials;
import org.surfnet.oaaas.model.AbstractEntity;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.model.ResourceServer;

@Entity
@XmlRootElement
@Table(name="client")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Client
extends AbstractEntity
implements PersistenceCapable {
    @Column(name="clientName")
    @NotNull
    private String name;
    @Column(unique=true)
    private String clientId;
    @Column
    private String secret;
    @Column
    private String description;
    @Column
    private String contactName;
    @Column
    private String contactEmail;
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> scopes;
    @ManyToOne(optional=false)
    @JsonIgnore
    @JoinColumn(name="resourceserver_id", nullable=false, updatable=false)
    private ResourceServer resourceServer;
    @ElementCollection(fetch=FetchType.EAGER)
    @MapKeyColumn(name="attribute_name")
    @Column(name="attribute_value")
    @CollectionTable(name="client_attributes", joinColumns={@JoinColumn(name="client_id")})
    private Map<String, String> attributes = new HashMap<String, String>();
    @Column
    private String thumbNailUrl;
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> redirectUris = new ArrayList<String>();
    @Column
    private boolean skipConsent;
    @Column
    private boolean includePrincipal;
    @Column
    private long expireDuration;
    @Column
    private boolean useRefreshTokens;
    @Column
    private boolean allowedImplicitGrant;
    @Column
    private boolean allowedClientCredentials;
    @OneToMany(mappedBy="client", cascade={CascadeType.ALL})
    private List<AccessToken> accessTokens;
    @OneToMany(mappedBy="client", cascade={CascadeType.ALL})
    private List<AuthorizationRequest> authorizationRequests;
    private static int pcInheritedFieldCount;
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$AbstractEntity;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Map;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$ResourceServer;
    static /* synthetic */ Class class$Lorg$surfnet$oaaas$model$Client;
    private static final long serialVersionUID;

    public String getName() {
        return Client.pcGetname(this);
    }

    public void setName(String name) {
        Client.pcSetname(this, name);
    }

    public String getDescription() {
        return Client.pcGetdescription(this);
    }

    public void setDescription(String description) {
        Client.pcSetdescription(this, description);
    }

    public String getContactName() {
        return Client.pcGetcontactName(this);
    }

    public void setContactName(String contactName) {
        Client.pcSetcontactName(this, contactName);
    }

    public String getContactEmail() {
        return Client.pcGetcontactEmail(this);
    }

    public void setContactEmail(String contactEmail) {
        Client.pcSetcontactEmail(this, contactEmail);
    }

    public List<String> getScopes() {
        return Client.pcGetscopes(this);
    }

    public void setScopes(List<String> scopes) {
        Client.pcSetscopes(this, scopes);
    }

    public ResourceServer getResourceServer() {
        return Client.pcGetresourceServer(this);
    }

    public void setResourceServer(ResourceServer resourceServer) {
        Client.pcSetresourceServer(this, resourceServer);
    }

    public String getThumbNailUrl() {
        return Client.pcGetthumbNailUrl(this);
    }

    public void setThumbNailUrl(String thumbNailUrl) {
        Client.pcSetthumbNailUrl(this, thumbNailUrl);
    }

    public boolean isSkipConsent() {
        return Client.pcGetskipConsent(this);
    }

    public void setSkipConsent(boolean skipConsent) {
        Client.pcSetskipConsent(this, skipConsent);
    }

    public String getClientId() {
        return Client.pcGetclientId(this);
    }

    public void setClientId(String clientId) {
        Client.pcSetclientId(this, clientId);
    }

    public String getSecret() {
        return Client.pcGetsecret(this);
    }

    public void setSecret(String secret) {
        Client.pcSetsecret(this, secret);
    }

    public List<String> getRedirectUris() {
        return Client.pcGetredirectUris(this);
    }

    public void setRedirectUris(List<String> redirectUris) {
        Client.pcSetredirectUris(this, redirectUris);
    }

    public boolean isUseRefreshTokens() {
        return Client.pcGetuseRefreshTokens(this);
    }

    public void setUseRefreshTokens(boolean useRefreshTokens) {
        Client.pcSetuseRefreshTokens(this, useRefreshTokens);
    }

    public long getExpireDuration() {
        return Client.pcGetexpireDuration(this);
    }

    public void setExpireDuration(long expireDuration) {
        Client.pcSetexpireDuration(this, expireDuration);
    }

    public boolean isExactMatch(UserPassCredentials credentials) {
        return credentials != null && credentials.isValid() && credentials.getUsername().equals(Client.pcGetclientId(this)) && credentials.getPassword().equals(Client.pcGetsecret(this));
    }

    public Map<String, String> getAttributes() {
        return Client.pcGetattributes(this);
    }

    public void setAttributes(Map<String, String> attributes) {
        Client.pcSetattributes(this, attributes);
    }

    public boolean isAllowedImplicitGrant() {
        return Client.pcGetallowedImplicitGrant(this);
    }

    public void setAllowedImplicitGrant(boolean allowedImplicitGrant) {
        Client.pcSetallowedImplicitGrant(this, allowedImplicitGrant);
    }

    public boolean isIncludePrincipal() {
        return Client.pcGetincludePrincipal(this);
    }

    public void setIncludePrincipal(boolean includePrincipal) {
        Client.pcSetincludePrincipal(this, includePrincipal);
    }

    public boolean isAllowedClientCredentials() {
        return Client.pcGetallowedClientCredentials(this);
    }

    public void setAllowedClientCredentials(boolean allowedClientCredentials) {
        Client.pcSetallowedClientCredentials(this, allowedClientCredentials);
    }

    @Override
    public boolean validate(ConstraintValidatorContext context) {
        boolean isValid = true;
        if (this.isUseRefreshTokens() && this.getExpireDuration() == 0L) {
            this.violation(context, "If refresh tokens are to be used then the expiry duration must be greater then 0");
            isValid = false;
        }
        if (this.isAllowedClientCredentials() && this.isAllowedImplicitGrant()) {
            this.violation(context, "A Client can not be issued the client credentials grant AND the implicit grant as client credentials requires a secret.");
            isValid = false;
        }
        if (Client.pcGetscopes(this) != null && !Client.pcGetresourceServer(this).getScopes().containsAll(Client.pcGetscopes(this))) {
            String message = "Client should only contain scopes that its resource server defines. Client scopes: " + Client.pcGetscopes(this) + ". Resource server scopes: " + Client.pcGetresourceServer(this).getScopes();
            this.violation(context, message);
            isValid = false;
        }
        for (String redirectUri : Client.pcGetredirectUris(this)) {
            try {
                new URL(redirectUri);
            }
            catch (MalformedURLException e) {
                this.violation(context, "redirectUri '" + redirectUri + "' is not a valid URI");
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1241207;
    }

    static {
        serialVersionUID = -8590838425315924122L;
        pcInheritedFieldCount = AbstractEntity.pcGetManagedFieldCount();
        Class clazz = class$Lorg$surfnet$oaaas$model$AbstractEntity != null ? class$Lorg$surfnet$oaaas$model$AbstractEntity : (class$Lorg$surfnet$oaaas$model$AbstractEntity = Client.class$("org.surfnet.oaaas.model.AbstractEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"accessTokens", "allowedClientCredentials", "allowedImplicitGrant", "attributes", "authorizationRequests", "clientId", "contactEmail", "contactName", "description", "expireDuration", "includePrincipal", "name", "redirectUris", "resourceServer", "scopes", "secret", "skipConsent", "thumbNailUrl", "useRefreshTokens"};
        Class[] classArray = new Class[19];
        Class clazz2 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Client.class$("java.util.List"));
        classArray[0] = clazz2;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Boolean.TYPE;
        Class clazz3 = class$Ljava$util$Map != null ? class$Ljava$util$Map : (class$Ljava$util$Map = Client.class$("java.util.Map"));
        classArray[3] = clazz3;
        classArray[4] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Client.class$("java.util.List"));
        Class clazz4 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[5] = clazz4;
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[8] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[9] = Long.TYPE;
        classArray[10] = Boolean.TYPE;
        classArray[11] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[12] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Client.class$("java.util.List"));
        Class clazz5 = class$Lorg$surfnet$oaaas$model$ResourceServer != null ? class$Lorg$surfnet$oaaas$model$ResourceServer : (class$Lorg$surfnet$oaaas$model$ResourceServer = Client.class$("org.surfnet.oaaas.model.ResourceServer"));
        classArray[13] = clazz5;
        classArray[14] = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = Client.class$("java.util.List"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[16] = Boolean.TYPE;
        classArray[17] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = Client.class$("java.lang.String"));
        classArray[18] = Boolean.TYPE;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{5, 26, 26, 10, 5, 26, 26, 26, 26, 26, 26, 26, 10, 26, 10, 26, 26, 26, 26};
        Class clazz6 = class$Lorg$surfnet$oaaas$model$Client != null ? class$Lorg$surfnet$oaaas$model$Client : (class$Lorg$surfnet$oaaas$model$Client = Client.class$("org.surfnet.oaaas.model.Client"));
        PCRegistry.register((Class)clazz6, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"Client", (PersistenceCapable)new Client());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.accessTokens = null;
        this.allowedClientCredentials = false;
        this.allowedImplicitGrant = false;
        this.attributes = null;
        this.authorizationRequests = null;
        this.clientId = null;
        this.contactEmail = null;
        this.contactName = null;
        this.description = null;
        this.expireDuration = 0L;
        this.includePrincipal = false;
        this.name = null;
        this.redirectUris = null;
        this.resourceServer = null;
        this.scopes = null;
        this.secret = null;
        this.skipConsent = false;
        this.thumbNailUrl = null;
        this.useRefreshTokens = false;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        Client client = new Client();
        if (bl) {
            client.pcClearFields();
        }
        client.pcStateManager = stateManager;
        client.pcCopyKeyFieldsFromObjectId(object);
        return client;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        Client client = new Client();
        if (bl) {
            client.pcClearFields();
        }
        client.pcStateManager = stateManager;
        return client;
    }

    protected static int pcGetManagedFieldCount() {
        return 19 + AbstractEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accessTokens = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.allowedClientCredentials = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.allowedImplicitGrant = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.attributes = (Map)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.authorizationRequests = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.clientId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.contactEmail = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.contactName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.description = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.expireDuration = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.includePrincipal = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.name = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.redirectUris = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.resourceServer = (ResourceServer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.scopes = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.secret = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.skipConsent = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.thumbNailUrl = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.useRefreshTokens = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.accessTokens);
                return;
            }
            case 1: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowedClientCredentials);
                return;
            }
            case 2: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.allowedImplicitGrant);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.attributes);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.authorizationRequests);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.clientId);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.contactEmail);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.contactName);
                return;
            }
            case 8: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.description);
                return;
            }
            case 9: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.expireDuration);
                return;
            }
            case 10: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.includePrincipal);
                return;
            }
            case 11: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.name);
                return;
            }
            case 12: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.redirectUris);
                return;
            }
            case 13: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.resourceServer);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.scopes);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.secret);
                return;
            }
            case 16: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.skipConsent);
                return;
            }
            case 17: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.thumbNailUrl);
                return;
            }
            case 18: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.useRefreshTokens);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(Client client, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(client, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.accessTokens = client.accessTokens;
                return;
            }
            case 1: {
                this.allowedClientCredentials = client.allowedClientCredentials;
                return;
            }
            case 2: {
                this.allowedImplicitGrant = client.allowedImplicitGrant;
                return;
            }
            case 3: {
                this.attributes = client.attributes;
                return;
            }
            case 4: {
                this.authorizationRequests = client.authorizationRequests;
                return;
            }
            case 5: {
                this.clientId = client.clientId;
                return;
            }
            case 6: {
                this.contactEmail = client.contactEmail;
                return;
            }
            case 7: {
                this.contactName = client.contactName;
                return;
            }
            case 8: {
                this.description = client.description;
                return;
            }
            case 9: {
                this.expireDuration = client.expireDuration;
                return;
            }
            case 10: {
                this.includePrincipal = client.includePrincipal;
                return;
            }
            case 11: {
                this.name = client.name;
                return;
            }
            case 12: {
                this.redirectUris = client.redirectUris;
                return;
            }
            case 13: {
                this.resourceServer = client.resourceServer;
                return;
            }
            case 14: {
                this.scopes = client.scopes;
                return;
            }
            case 15: {
                this.secret = client.secret;
                return;
            }
            case 16: {
                this.skipConsent = client.skipConsent;
                return;
            }
            case 17: {
                this.thumbNailUrl = client.thumbNailUrl;
                return;
            }
            case 18: {
                this.useRefreshTokens = client.useRefreshTokens;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        Client client = (Client)object;
        if (client.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(client, nArray[n]);
            ++n;
        }
    }

    private static final List pcGetaccessTokens(Client client) {
        if (client.pcStateManager == null) {
            return client.accessTokens;
        }
        int n = pcInheritedFieldCount + 0;
        client.pcStateManager.accessingField(n);
        return client.accessTokens;
    }

    private static final void pcSetaccessTokens(Client client, List list) {
        if (client.pcStateManager == null) {
            client.accessTokens = list;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 0, client.accessTokens, (Object)list, 0);
    }

    private static final boolean pcGetallowedClientCredentials(Client client) {
        if (client.pcStateManager == null) {
            return client.allowedClientCredentials;
        }
        int n = pcInheritedFieldCount + 1;
        client.pcStateManager.accessingField(n);
        return client.allowedClientCredentials;
    }

    private static final void pcSetallowedClientCredentials(Client client, boolean bl) {
        if (client.pcStateManager == null) {
            client.allowedClientCredentials = bl;
            return;
        }
        client.pcStateManager.settingBooleanField((PersistenceCapable)client, pcInheritedFieldCount + 1, client.allowedClientCredentials, bl, 0);
    }

    private static final boolean pcGetallowedImplicitGrant(Client client) {
        if (client.pcStateManager == null) {
            return client.allowedImplicitGrant;
        }
        int n = pcInheritedFieldCount + 2;
        client.pcStateManager.accessingField(n);
        return client.allowedImplicitGrant;
    }

    private static final void pcSetallowedImplicitGrant(Client client, boolean bl) {
        if (client.pcStateManager == null) {
            client.allowedImplicitGrant = bl;
            return;
        }
        client.pcStateManager.settingBooleanField((PersistenceCapable)client, pcInheritedFieldCount + 2, client.allowedImplicitGrant, bl, 0);
    }

    private static final Map pcGetattributes(Client client) {
        if (client.pcStateManager == null) {
            return client.attributes;
        }
        int n = pcInheritedFieldCount + 3;
        client.pcStateManager.accessingField(n);
        return client.attributes;
    }

    private static final void pcSetattributes(Client client, Map map) {
        if (client.pcStateManager == null) {
            client.attributes = map;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 3, client.attributes, (Object)map, 0);
    }

    private static final List pcGetauthorizationRequests(Client client) {
        if (client.pcStateManager == null) {
            return client.authorizationRequests;
        }
        int n = pcInheritedFieldCount + 4;
        client.pcStateManager.accessingField(n);
        return client.authorizationRequests;
    }

    private static final void pcSetauthorizationRequests(Client client, List list) {
        if (client.pcStateManager == null) {
            client.authorizationRequests = list;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 4, client.authorizationRequests, (Object)list, 0);
    }

    private static final String pcGetclientId(Client client) {
        if (client.pcStateManager == null) {
            return client.clientId;
        }
        int n = pcInheritedFieldCount + 5;
        client.pcStateManager.accessingField(n);
        return client.clientId;
    }

    private static final void pcSetclientId(Client client, String string) {
        if (client.pcStateManager == null) {
            client.clientId = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 5, client.clientId, string, 0);
    }

    private static final String pcGetcontactEmail(Client client) {
        if (client.pcStateManager == null) {
            return client.contactEmail;
        }
        int n = pcInheritedFieldCount + 6;
        client.pcStateManager.accessingField(n);
        return client.contactEmail;
    }

    private static final void pcSetcontactEmail(Client client, String string) {
        if (client.pcStateManager == null) {
            client.contactEmail = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 6, client.contactEmail, string, 0);
    }

    private static final String pcGetcontactName(Client client) {
        if (client.pcStateManager == null) {
            return client.contactName;
        }
        int n = pcInheritedFieldCount + 7;
        client.pcStateManager.accessingField(n);
        return client.contactName;
    }

    private static final void pcSetcontactName(Client client, String string) {
        if (client.pcStateManager == null) {
            client.contactName = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 7, client.contactName, string, 0);
    }

    private static final String pcGetdescription(Client client) {
        if (client.pcStateManager == null) {
            return client.description;
        }
        int n = pcInheritedFieldCount + 8;
        client.pcStateManager.accessingField(n);
        return client.description;
    }

    private static final void pcSetdescription(Client client, String string) {
        if (client.pcStateManager == null) {
            client.description = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 8, client.description, string, 0);
    }

    private static final long pcGetexpireDuration(Client client) {
        if (client.pcStateManager == null) {
            return client.expireDuration;
        }
        int n = pcInheritedFieldCount + 9;
        client.pcStateManager.accessingField(n);
        return client.expireDuration;
    }

    private static final void pcSetexpireDuration(Client client, long l) {
        if (client.pcStateManager == null) {
            client.expireDuration = l;
            return;
        }
        client.pcStateManager.settingLongField((PersistenceCapable)client, pcInheritedFieldCount + 9, client.expireDuration, l, 0);
    }

    private static final boolean pcGetincludePrincipal(Client client) {
        if (client.pcStateManager == null) {
            return client.includePrincipal;
        }
        int n = pcInheritedFieldCount + 10;
        client.pcStateManager.accessingField(n);
        return client.includePrincipal;
    }

    private static final void pcSetincludePrincipal(Client client, boolean bl) {
        if (client.pcStateManager == null) {
            client.includePrincipal = bl;
            return;
        }
        client.pcStateManager.settingBooleanField((PersistenceCapable)client, pcInheritedFieldCount + 10, client.includePrincipal, bl, 0);
    }

    private static final String pcGetname(Client client) {
        if (client.pcStateManager == null) {
            return client.name;
        }
        int n = pcInheritedFieldCount + 11;
        client.pcStateManager.accessingField(n);
        return client.name;
    }

    private static final void pcSetname(Client client, String string) {
        if (client.pcStateManager == null) {
            client.name = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 11, client.name, string, 0);
    }

    private static final List pcGetredirectUris(Client client) {
        if (client.pcStateManager == null) {
            return client.redirectUris;
        }
        int n = pcInheritedFieldCount + 12;
        client.pcStateManager.accessingField(n);
        return client.redirectUris;
    }

    private static final void pcSetredirectUris(Client client, List list) {
        if (client.pcStateManager == null) {
            client.redirectUris = list;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 12, client.redirectUris, (Object)list, 0);
    }

    private static final ResourceServer pcGetresourceServer(Client client) {
        if (client.pcStateManager == null) {
            return client.resourceServer;
        }
        int n = pcInheritedFieldCount + 13;
        client.pcStateManager.accessingField(n);
        return client.resourceServer;
    }

    private static final void pcSetresourceServer(Client client, ResourceServer resourceServer) {
        if (client.pcStateManager == null) {
            client.resourceServer = resourceServer;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 13, (Object)client.resourceServer, (Object)resourceServer, 0);
    }

    private static final List pcGetscopes(Client client) {
        if (client.pcStateManager == null) {
            return client.scopes;
        }
        int n = pcInheritedFieldCount + 14;
        client.pcStateManager.accessingField(n);
        return client.scopes;
    }

    private static final void pcSetscopes(Client client, List list) {
        if (client.pcStateManager == null) {
            client.scopes = list;
            return;
        }
        client.pcStateManager.settingObjectField((PersistenceCapable)client, pcInheritedFieldCount + 14, client.scopes, (Object)list, 0);
    }

    private static final String pcGetsecret(Client client) {
        if (client.pcStateManager == null) {
            return client.secret;
        }
        int n = pcInheritedFieldCount + 15;
        client.pcStateManager.accessingField(n);
        return client.secret;
    }

    private static final void pcSetsecret(Client client, String string) {
        if (client.pcStateManager == null) {
            client.secret = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 15, client.secret, string, 0);
    }

    private static final boolean pcGetskipConsent(Client client) {
        if (client.pcStateManager == null) {
            return client.skipConsent;
        }
        int n = pcInheritedFieldCount + 16;
        client.pcStateManager.accessingField(n);
        return client.skipConsent;
    }

    private static final void pcSetskipConsent(Client client, boolean bl) {
        if (client.pcStateManager == null) {
            client.skipConsent = bl;
            return;
        }
        client.pcStateManager.settingBooleanField((PersistenceCapable)client, pcInheritedFieldCount + 16, client.skipConsent, bl, 0);
    }

    private static final String pcGetthumbNailUrl(Client client) {
        if (client.pcStateManager == null) {
            return client.thumbNailUrl;
        }
        int n = pcInheritedFieldCount + 17;
        client.pcStateManager.accessingField(n);
        return client.thumbNailUrl;
    }

    private static final void pcSetthumbNailUrl(Client client, String string) {
        if (client.pcStateManager == null) {
            client.thumbNailUrl = string;
            return;
        }
        client.pcStateManager.settingStringField((PersistenceCapable)client, pcInheritedFieldCount + 17, client.thumbNailUrl, string, 0);
    }

    private static final boolean pcGetuseRefreshTokens(Client client) {
        if (client.pcStateManager == null) {
            return client.useRefreshTokens;
        }
        int n = pcInheritedFieldCount + 18;
        client.pcStateManager.accessingField(n);
        return client.useRefreshTokens;
    }

    private static final void pcSetuseRefreshTokens(Client client, boolean bl) {
        if (client.pcStateManager == null) {
            client.useRefreshTokens = bl;
            return;
        }
        client.pcStateManager.settingBooleanField((PersistenceCapable)client, pcInheritedFieldCount + 18, client.useRefreshTokens, bl, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

