/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.auth.OAuth2Validator;
import org.surfnet.oaaas.auth.ValidationResponseException;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.auth.principal.UserPassCredentials;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.model.AccessTokenRequest;
import org.surfnet.oaaas.model.AccessTokenResponse;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.model.ErrorResponse;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.repository.AuthorizationRequestRepository;

@Named
@Path(value="/")
public class TokenResource {
    public static final String BASIC_REALM = "Basic realm=\"OAuth2 Secure\"";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    @Inject
    private AuthorizationRequestRepository authorizationRequestRepository;
    @Inject
    private AccessTokenRepository accessTokenRepository;
    @Inject
    private OAuth2Validator oAuth2Validator;
    private static final Logger LOG = LoggerFactory.getLogger(TokenResource.class);

    @GET
    @Path(value="/authorize")
    public Response authorizeCallbackGet(@Context HttpServletRequest request) {
        return this.authorizeCallback(request);
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="/authorize")
    public Response authorizeCallback(@Context HttpServletRequest request) {
        return this.doProcess(request);
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="/consent")
    public Response consentCallback(@Context HttpServletRequest request) {
        return this.doProcess(request);
    }

    private Response doProcess(HttpServletRequest request) {
        AuthorizationRequest authReq = this.findAuthorizationRequest(request);
        if (authReq == null) {
            return this.serverError("Not a valid AbstractAuthenticator.AUTH_STATE on the Request");
        }
        this.processScopes(authReq, request);
        if (authReq.getResponseType().equals("token")) {
            AccessToken token = this.createAccessToken(authReq, true);
            return this.sendImplicitGrantResponse(authReq, token);
        }
        return this.sendAuthorizationCodeResponse(authReq);
    }

    private void processScopes(AuthorizationRequest authReq, HttpServletRequest request) {
        if (authReq.getClient().isSkipConsent()) {
            authReq.setGrantedScopes(authReq.getRequestedScopes());
        } else {
            Object[] scopes = (String[])request.getAttribute("GRANTED_SCOPES");
            if (!ArrayUtils.isEmpty((Object[])scopes)) {
                authReq.setGrantedScopes(Arrays.asList(scopes));
            } else {
                authReq.setGrantedScopes(null);
            }
        }
    }

    private AccessToken createAccessToken(AuthorizationRequest request, boolean isImplicitGrant) {
        Client client = request.getClient();
        long expireDuration = client.getExpireDuration();
        long expires = expireDuration == 0L ? 0L : System.currentTimeMillis() + 1000L * expireDuration;
        String refreshToken = client.isUseRefreshTokens() && !isImplicitGrant ? this.getTokenValue(true) : null;
        AuthenticatedPrincipal principal = request.getPrincipal();
        AccessToken token = new AccessToken(this.getTokenValue(false), principal, client, expires, request.getGrantedScopes(), refreshToken);
        return (AccessToken)this.accessTokenRepository.save(token);
    }

    private AuthorizationRequest findAuthorizationRequest(HttpServletRequest request) {
        String authState = (String)request.getAttribute("AUTH_STATE");
        return this.authorizationRequestRepository.findByAuthState(authState);
    }

    @POST
    @Path(value="/token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response token(@HeaderParam(value="Authorization") String authorization, MultivaluedMap<String, String> formParameters) {
        AuthorizationRequest request;
        UserPassCredentials credentials;
        block8: {
            OAuth2Validator.ValidationResponse vr;
            AccessTokenRequest accessTokenRequest = AccessTokenRequest.fromMultiValuedFormParameters(formParameters);
            credentials = this.getUserPassCredentials(authorization, accessTokenRequest);
            String grantType = accessTokenRequest.getGrantType();
            if ("client_credentials".equals(grantType)) {
                accessTokenRequest.setClientId(credentials.getUsername());
            }
            if (!(vr = this.oAuth2Validator.validate(accessTokenRequest)).valid()) {
                return this.sendErrorResponse(vr);
            }
            try {
                if ("authorization_code".equals(grantType)) {
                    request = this.authorizationCodeToken(accessTokenRequest);
                    break block8;
                }
                if ("refresh_token".equals(grantType)) {
                    request = this.refreshTokenToken(accessTokenRequest);
                    break block8;
                }
                if ("client_credentials".equals(grantType)) {
                    request = new AuthorizationRequest();
                    request.setClient(accessTokenRequest.getClient());
                    request.setPrincipal(new AuthenticatedPrincipal(request.getClient().getClientId()));
                    request.setGrantedScopes(request.getClient().getScopes());
                    break block8;
                }
                return this.sendErrorResponse(OAuth2Validator.ValidationResponse.UNSUPPORTED_GRANT_TYPE);
            }
            catch (ValidationResponseException e) {
                return this.sendErrorResponse(e.v);
            }
        }
        if (!request.getClient().isExactMatch(credentials)) {
            return Response.status((Response.StatusType)ClientResponse.Status.UNAUTHORIZED).header(WWW_AUTHENTICATE, (Object)BASIC_REALM).build();
        }
        AccessToken token = this.createAccessToken(request, false);
        AccessTokenResponse response = new AccessTokenResponse(token.getToken(), "bearer", request.getClient().getExpireDuration(), token.getRefreshToken(), StringUtils.join(token.getScopes(), (char)','));
        return Response.ok().entity((Object)response).build();
    }

    private AuthorizationRequest authorizationCodeToken(AccessTokenRequest accessTokenRequest) {
        AuthorizationRequest authReq = this.authorizationRequestRepository.findByAuthorizationCode(accessTokenRequest.getCode());
        if (authReq == null) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.INVALID_GRANT_AUTHORIZATION_CODE);
        }
        String uri = accessTokenRequest.getRedirectUri();
        if (!authReq.getRedirectUri().equalsIgnoreCase(uri)) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.REDIRECT_URI_DIFFERENT);
        }
        this.authorizationRequestRepository.delete(authReq);
        return authReq;
    }

    private AuthorizationRequest refreshTokenToken(AccessTokenRequest accessTokenRequest) {
        AccessToken accessToken = this.accessTokenRepository.findByRefreshToken(accessTokenRequest.getRefreshToken());
        if (accessToken == null) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.INVALID_GRANT_REFRESH_TOKEN);
        }
        AuthorizationRequest request = new AuthorizationRequest();
        request.setClient(accessToken.getClient());
        request.setPrincipal(accessToken.getPrincipal());
        request.setGrantedScopes(accessToken.getScopes());
        this.accessTokenRepository.delete(accessToken);
        return request;
    }

    private UserPassCredentials getUserPassCredentials(String authorization, AccessTokenRequest accessTokenRequest) {
        return StringUtils.isBlank((String)authorization) ? new UserPassCredentials(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret()) : new UserPassCredentials(authorization);
    }

    private Response sendAuthorizationCodeResponse(AuthorizationRequest authReq) {
        String uri = authReq.getRedirectUri();
        String authorizationCode = this.getAuthorizationCodeValue();
        authReq.setAuthorizationCode(authorizationCode);
        this.authorizationRequestRepository.save(authReq);
        uri = uri + this.appendQueryMark(uri) + "code=" + authorizationCode + this.appendStateParameter(authReq);
        return Response.seeOther((URI)UriBuilder.fromUri((String)uri).build(new Object[0])).build();
    }

    protected String getTokenValue(boolean isRefreshToken) {
        return UUID.randomUUID().toString();
    }

    protected String getAuthorizationCodeValue() {
        return this.getTokenValue(false);
    }

    private Response sendErrorResponse(String error, String description) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)new ErrorResponse(error, description)).build();
    }

    private Response sendErrorResponse(OAuth2Validator.ValidationResponse response) {
        return this.sendErrorResponse(response.getValue(), response.getDescription());
    }

    private Response sendImplicitGrantResponse(AuthorizationRequest authReq, AccessToken accessToken) {
        String uri = authReq.getRedirectUri();
        String fragment = String.format("access_token=%s&token_type=bearer&expires_in=%s&scope=%s" + this.appendStateParameter(authReq), accessToken.getToken(), accessToken.getExpires(), StringUtils.join(authReq.getGrantedScopes(), (char)','));
        if (authReq.getClient().isIncludePrincipal()) {
            fragment = fragment + String.format("&principal=%s", authReq.getPrincipal().getDisplayName());
        }
        return Response.seeOther((URI)UriBuilder.fromUri((String)uri).fragment(fragment).build(new Object[0])).build();
    }

    private String appendQueryMark(String uri) {
        return uri.contains("?") ? "&" : "?";
    }

    private String appendStateParameter(AuthorizationRequest authReq) {
        String state = authReq.getState();
        return StringUtils.isBlank((String)state) ? "" : "&state=".concat(state);
    }

    private Response serverError(String msg) {
        LOG.warn(msg);
        return Response.serverError().build();
    }

    public void setAuthorizationRequestRepository(AuthorizationRequestRepository authorizationRequestRepository) {
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public void setAccessTokenRepository(AccessTokenRepository accessTokenRepository) {
        this.accessTokenRepository = accessTokenRepository;
    }

    public void setoAuth2Validator(OAuth2Validator oAuth2Validator) {
        this.oAuth2Validator = oAuth2Validator;
    }
}

