/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource.resourceserver;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.resource.resourceserver.AbstractResource;

@Named
@Path(value="/accessToken")
@Produces(value={"application/json"})
public class AccessTokenResource
extends AbstractResource {
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenResource.class);
    @Inject
    private AccessTokenRepository accessTokenRepository;

    @GET
    public Response getAll(@Context HttpServletRequest request) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        List<AccessToken> tokens = this.getAllAccessTokens(request);
        return Response.ok(tokens).build();
    }

    @GET
    @Path(value="/{accessTokenId}")
    public Response getById(@Context HttpServletRequest request, @PathParam(value="accessTokenId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("read"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        return this.response(this.getAccessToken(request, id));
    }

    @DELETE
    @Path(value="/{accessTokenId}")
    public Response delete(@Context HttpServletRequest request, @PathParam(value="accessTokenId") Long id) {
        Response validateScopeResponse = this.validateScope(request, Collections.singletonList("write"));
        if (validateScopeResponse != null) {
            return validateScopeResponse;
        }
        AccessToken accessToken = this.getAccessToken(request, id);
        if (accessToken == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        LOG.debug("About to delete accessToken {}", (Object)id);
        this.accessTokenRepository.delete(id);
        return Response.noContent().build();
    }

    private AccessToken getAccessToken(HttpServletRequest request, Long id) {
        AccessToken accessToken;
        if (this.isAdminPrincipal(request)) {
            accessToken = (AccessToken)this.accessTokenRepository.findOne(id);
        } else {
            String owner = this.getUserId(request);
            accessToken = this.accessTokenRepository.findByIdAndResourceOwnerId(id, owner);
        }
        LOG.debug("About to return one accessToken with id {}: {}", (Object)id, (Object)accessToken);
        return accessToken;
    }

    private List<AccessToken> getAllAccessTokens(HttpServletRequest request) {
        List<Object> accessTokens;
        if (this.isAdminPrincipal(request)) {
            accessTokens = this.addAll(this.accessTokenRepository.findAll().iterator());
            LOG.debug("About to return all resource servers ({}) for adminPrincipal", (Object)accessTokens.size());
        } else {
            String owner = this.getUserId(request);
            accessTokens = this.accessTokenRepository.findByResourceOwnerId(owner);
            LOG.debug("About to return all resource servers ({}) for owner {}", (Object)accessTokens.size(), (Object)owner);
        }
        return accessTokens;
    }
}

