/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import org.surfnet.oaaas.model.AccessTokenRequest;
import org.surfnet.oaaas.model.AuthorizationRequest;

public interface OAuth2Validator {
    public static final String GRANT_TYPE_AUTHORIZATION_CODE = "authorization_code";
    public static final String GRANT_TYPE_REFRESH_TOKEN = "refresh_token";
    public static final String GRANT_TYPE_CLIENT_CREDENTIALS = "client_credentials";
    public static final String IMPLICIT_GRANT_RESPONSE_TYPE = "token";
    public static final String AUTHORIZATION_CODE_GRANT_RESPONSE_TYPE = "code";
    public static final String CLIENT_CREDENTIALS_GRANT_RESPONSE_TYPE = "client_credentials";
    public static final String BEARER = "bearer";

    public ValidationResponse validate(AuthorizationRequest var1);

    public ValidationResponse validate(AccessTokenRequest var1);

    public static enum ValidationResponse {
        VALID("valid", "valid"),
        UNSUPPORTED_RESPONSE_TYPE("unsupported_response_type", String.format("The supported response_type values are '%s' and '%s'", "token", "code")),
        UNKNOWN_CLIENT_ID("unauthorized_client", "The client_id is unknown"),
        IMPLICIT_GRANT_REDIRECT_URI("invalid_request", "For Implicit Grant the redirect_uri parameter is required"),
        REDIRECT_URI_REQUIRED("invalid_request", "Client has no registered redirect_uri, must provide run-time redirect_uri"),
        REDIRCT_URI_NOT_VALID("invalid_request", "The redirect_uri does not equal any of the registered redirect_uri values"),
        REDIRCT_URI_NOT_URI("invalid_request", "The redirect_uri is not a valid URL"),
        REDIRECT_URI_DIFFERENT("invaid_request", "The redirect_uri does not match the initial authorization request"),
        SCOPE_NOT_VALID("invalid_scope", "The requested scope is invalid, unknown, malformed, or exceeds the scope granted by the resource owner."),
        IMPLICIT_GRANT_NOT_PERMITTED("unsupported_response_type", "The client has no permisssion for implicit grant"),
        CLIENT_CREDENTIALS_NOT_PERMITTED("unauthorized_client", "The client has no permisssion for client credentials"),
        REDIRECT_URI_FRAGMENT_COMPONENT("invalid_request", "The redirect_uri endpoint must not include a fragment component"),
        UNSUPPORTED_GRANT_TYPE("unsupported_grant_type", String.format("The supported grant_type values are '%s' and '%s'", "authorization_code", "refresh_token")),
        INVALID_GRANT_AUTHORIZATION_CODE("invalid_grant", "The authorization code is invalid"),
        INVALID_GRANT_REFRESH_TOKEN("invalid_grant", "The refresh token is invalid");

        private String value;
        private String description;

        private ValidationResponse(String value, String description) {
            this.value = value;
            this.description = description;
        }

        public boolean valid() {
            return this.equals((Object)VALID);
        }

        public String getValue() {
            return this.value;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

