/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.auth.AbstractAuthenticator;
import org.surfnet.oaaas.auth.OAuth2Validator;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.repository.AuthorizationRequestRepository;

@Named
public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    private AbstractAuthenticator authenticator;
    @Inject
    private AuthorizationRequestRepository authorizationRequestRepository;
    @Inject
    private OAuth2Validator oAuth2Validator;

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        AuthorizationRequest authorizationRequest = this.extractAuthorizationRequest(request);
        OAuth2Validator.ValidationResponse validationResponse = this.oAuth2Validator.validate(authorizationRequest);
        if (this.authenticator.canCommence(request)) {
            this.authenticator.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        } else if (validationResponse.valid()) {
            this.handleInitialRequest(authorizationRequest, request);
            this.authenticator.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        } else {
            this.sendError(response, authorizationRequest, validationResponse);
        }
    }

    protected AuthorizationRequest extractAuthorizationRequest(HttpServletRequest request) {
        String responseType = request.getParameter("response_type");
        String clientId = request.getParameter("client_id");
        String redirectUri = request.getParameter("redirect_uri");
        List<String> requestedScopes = null;
        if (StringUtils.isNotBlank((String)request.getParameter("scope"))) {
            requestedScopes = Arrays.asList(request.getParameter("scope").split(","));
        }
        String state = request.getParameter("state");
        String authState = this.getAuthStateValue();
        return new AuthorizationRequest(responseType, clientId, redirectUri, requestedScopes, state, authState);
    }

    private boolean handleInitialRequest(AuthorizationRequest authReq, HttpServletRequest request) throws ServletException {
        try {
            this.authorizationRequestRepository.save(authReq);
        }
        catch (Exception e) {
            LOG.error("while saving authorization request", (Throwable)e);
            throw new ServletException("Cannot save authorization request");
        }
        request.setAttribute("AUTH_STATE", (Object)authReq.getAuthState());
        request.setAttribute("RETURN_URI", (Object)request.getRequestURI());
        return true;
    }

    protected String getAuthStateValue() {
        return UUID.randomUUID().toString();
    }

    private void sendError(HttpServletResponse response, AuthorizationRequest authReq, OAuth2Validator.ValidationResponse validate) throws IOException {
        LOG.info("Will send error response for authorization request '{}', validation result: {}", (Object)authReq, (Object)validate);
        String redirectUri = authReq.getRedirectUri();
        String state = authReq.getState();
        if (AuthenticationFilter.isValidUrl(redirectUri)) {
            redirectUri = redirectUri.concat(redirectUri.contains("?") ? "&" : "?");
            redirectUri = redirectUri.concat("error=").concat(validate.getValue()).concat("&error_description=").concat(validate.getDescription()).concat(StringUtils.isBlank((String)state) ? "" : "&state=".concat(state));
            LOG.info("Sending error response, a redirect to: {}", (Object)redirectUri);
            response.sendRedirect(redirectUri);
        } else {
            LOG.info("Sending error response 'bad request': {}", (Object)validate.getDescription());
            response.sendError(400, validate.getDescription());
        }
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void setAuthenticator(AbstractAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public static boolean isValidUrl(String redirectUri) {
        try {
            new URL(redirectUri);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public void setAuthorizationRequestRepository(AuthorizationRequestRepository authorizationRequestRepository) {
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public void setOAuth2Validator(OAuth2Validator oAuth2Validator) {
        this.oAuth2Validator = oAuth2Validator;
    }
}

