/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.resource;

import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.surfnet.oaaas.auth.OAuth2Validator;
import org.surfnet.oaaas.auth.ValidationResponseException;
import org.surfnet.oaaas.auth.principal.UserPassCredentials;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.model.AccessTokenRequest;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.model.ErrorResponse;
import org.surfnet.oaaas.repository.AccessTokenRepository;
import org.surfnet.oaaas.repository.ClientRepository;

@Named
@Path(value="/revoke")
@Produces(value={"application/json"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class RevokeResource {
    private static final Logger LOG = LoggerFactory.getLogger(RevokeResource.class);
    @Inject
    private AccessTokenRepository accessTokenRepository;
    @Inject
    private ClientRepository clientRepository;

    @POST
    public Response revokeAccessToken(@HeaderParam(value="Authorization") String authorization, MultivaluedMap<String, String> formParameters) {
        String accessToken;
        Client client;
        AccessTokenRequest accessTokenRequest = AccessTokenRequest.fromMultiValuedFormParameters(formParameters);
        UserPassCredentials credentials = this.getClientCredentials(authorization, accessTokenRequest);
        try {
            client = this.validateClient(credentials);
            if (!client.isExactMatch(credentials)) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"OAuth2 Secure\"").build();
            }
            List params = (List)formParameters.get((Object)"token");
            accessToken = CollectionUtils.isEmpty((Collection)params) ? null : (String)params.get(0);
        }
        catch (ValidationResponseException e) {
            OAuth2Validator.ValidationResponse validationResponse = e.v;
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new ErrorResponse(validationResponse.getValue(), validationResponse.getDescription())).build();
        }
        AccessToken token = this.accessTokenRepository.findByTokenAndClient(accessToken, client);
        if (token == null) {
            LOG.info("Access token {} not found for client '{}'. Will return OK however.", (Object)accessToken, (Object)client.getClientId());
            return Response.ok().build();
        }
        this.accessTokenRepository.delete(token);
        return Response.ok().build();
    }

    protected Client validateClient(UserPassCredentials credentials) {
        Client client;
        String clientId = credentials.getUsername();
        Client client2 = client = StringUtils.isBlank((String)clientId) ? null : this.clientRepository.findByClientId(clientId);
        if (client == null) {
            throw new ValidationResponseException(OAuth2Validator.ValidationResponse.UNKNOWN_CLIENT_ID);
        }
        return client;
    }

    private UserPassCredentials getClientCredentials(String authorization, AccessTokenRequest accessTokenRequest) {
        return StringUtils.isBlank((String)authorization) ? new UserPassCredentials(accessTokenRequest.getClientId(), accessTokenRequest.getClientSecret()) : new UserPassCredentials(authorization);
    }
}

