/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.support;

import java.util.Date;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.surfnet.oaaas.model.AccessToken;
import org.surfnet.oaaas.repository.AccessTokenRepository;

public class Cleaner {
    private static final Logger LOG = LoggerFactory.getLogger(Cleaner.class);
    @Inject
    private AccessTokenRepository accessTokenRepository;
    private static final long CLEANUP_INTERVAL = 3600000L;
    private static final long EXPIRED_TOKEN_CLEANUP_AGE = 2592000000L;

    @Scheduled(fixedDelay=3600000L)
    public void cleanupExpiredAccessTokens() {
        LOG.debug("Cleaning up expired access tokens");
        for (AccessToken at : this.accessTokenRepository.findByMaxExpires(System.currentTimeMillis() - 2592000000L)) {
            LOG.debug("Deleting expired access token {} (created: {}, expired: {})", new Object[]{at.getToken(), at.getCreationDate(), new Date(at.getExpires())});
            this.accessTokenRepository.delete(at);
        }
    }
}

