/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth.principal;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.util.CollectionUtils;

public class AuthenticatedPrincipal
implements Serializable,
Principal {
    private static final long serialVersionUID = 1L;
    @JsonIgnore
    private static final ObjectMapper mapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL).setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
    private String name;
    private Collection<String> roles;
    private Collection<String> groups;
    private Map<String, String> attributes;

    public AuthenticatedPrincipal() {
    }

    public AuthenticatedPrincipal(String username) {
        this(username, new ArrayList<String>());
    }

    public AuthenticatedPrincipal(String username, Collection<String> roles) {
        this(username, roles, new HashMap<String, String>());
    }

    public AuthenticatedPrincipal(String username, Collection<String> roles, Map<String, String> attributes) {
        this(username, roles, attributes, new ArrayList<String>());
    }

    public AuthenticatedPrincipal(String username, Collection<String> roles, Map<String, String> attributes, Collection<String> groups) {
        this.name = username;
        this.roles = roles;
        this.attributes = attributes;
        this.groups = groups;
    }

    public Collection<String> getRoles() {
        return this.roles;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, value);
    }

    public void addGroup(String name) {
        if (this.groups == null) {
            this.groups = new ArrayList<String>();
        }
        this.groups.add(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public String getDisplayName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " [name=" + this.name + ", roles=" + this.roles + ", attributes=" + this.attributes + "]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoles(Collection<String> roles) {
        this.roles = roles;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public Collection<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        this.groups = groups;
    }

    @JsonIgnore
    public boolean isGroupAware() {
        return !CollectionUtils.isEmpty(this.groups);
    }

    @JsonIgnore
    public String serialize() {
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize Principal:" + this.toString(), e);
        }
    }

    @JsonIgnore
    public static AuthenticatedPrincipal deserialize(String json) {
        try {
            return (AuthenticatedPrincipal)mapper.readValue(json, AuthenticatedPrincipal.class);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize Principal:" + json, e);
        }
    }
}

