/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;
import org.surfnet.oaaas.auth.ObjectMapperProvider;
import org.surfnet.oaaas.model.TokenResponseCache;
import org.surfnet.oaaas.model.TokenResponseCacheImpl;
import org.surfnet.oaaas.model.VerifyTokenResponse;

public class AuthorizationServerFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationServerFilter.class);
    private String authorizationServerUrl;
    private String authorizationValue;
    private Client client;
    private static final String BEARER = "bearer";
    public static final String VERIFY_TOKEN_RESPONSE = "VERIFY_TOKEN_RESPONSE";
    private boolean cacheEnabled;
    private TokenResponseCache cache;
    private boolean allowCorsRequests = true;
    private String resourceServerKey;
    private String resourceServerSecret;
    private ObjectMapper objectMapper;

    public void init(FilterConfig filterConfig) throws ServletException {
        ClassPathResource res = null;
        String propertiesFile = filterConfig.getInitParameter("apis.application.properties.file");
        if (StringUtils.isNotEmpty((String)propertiesFile)) {
            res = new ClassPathResource(propertiesFile);
        }
        if (res == null || !res.exists()) {
            res = new ClassPathResource("apis.application.properties");
        }
        if (res != null && res.exists()) {
            Properties prop = new Properties();
            try {
                prop.load(res.getInputStream());
            }
            catch (IOException e) {
                throw new RuntimeException("Error in reading the apis.application.properties file", e);
            }
            this.resourceServerKey = prop.getProperty("adminService.resourceServerKey");
            this.resourceServerSecret = prop.getProperty("adminService.resourceServerSecret");
            this.authorizationServerUrl = prop.getProperty("adminService.tokenVerificationUrl");
            this.cacheEnabled = Boolean.valueOf(prop.getProperty("adminService.cacheEnabled"));
            String allowCorsRequestsProperty = prop.getProperty("adminService.allowCorsRequests");
            if (StringUtils.isNotEmpty((String)allowCorsRequestsProperty)) {
                this.allowCorsRequests = Boolean.valueOf(allowCorsRequestsProperty);
            }
        } else if (filterConfig.getInitParameter("resource-server-key") != null) {
            this.resourceServerKey = filterConfig.getInitParameter("resource-server-key");
            this.resourceServerSecret = filterConfig.getInitParameter("resource-server-secret");
            this.authorizationServerUrl = filterConfig.getInitParameter("authorization-server-url");
        }
        Assert.hasText((String)this.resourceServerKey, (String)"Must provide a resource server key");
        Assert.hasText((String)this.resourceServerSecret, (String)"Must provide a resource server secret");
        Assert.hasText((String)this.authorizationServerUrl, (String)"Must provide a authorization server url");
        this.authorizationValue = new String(Base64.encodeBase64((byte[])this.resourceServerKey.concat(":").concat(this.resourceServerSecret).getBytes()));
        if (this.cacheAccessTokens()) {
            this.cache = this.buildCache();
            Assert.notNull((Object)this.cache);
        }
        this.client = this.createClient();
        this.objectMapper = this.createObjectMapper();
    }

    protected ObjectMapper createObjectMapper() {
        return new ObjectMapperProvider().getContext(ObjectMapper.class);
    }

    protected Client createClient() {
        DefaultClientConfig cc = new DefaultClientConfig();
        cc.getClasses().add(ObjectMapperProvider.class);
        return Client.create((ClientConfig)cc);
    }

    protected TokenResponseCache buildCache() {
        return new TokenResponseCacheImpl(1000, 300L);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        VerifyTokenResponse tokenResponse;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.handledCorsPreflightRequest(request, response)) {
            return;
        }
        String accessToken = this.getAccessToken(request);
        if (accessToken != null && this.isValidResponse(tokenResponse = this.getVerifyTokenResponse(accessToken))) {
            request.setAttribute(VERIFY_TOKEN_RESPONSE, (Object)tokenResponse);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.sendError(response, 403, "OAuth2 endpoint");
    }

    protected VerifyTokenResponse getVerifyTokenResponse(String accessToken) {
        VerifyTokenResponse verifyTokenResponse = null;
        if (this.cacheAccessTokens() && (verifyTokenResponse = this.cache.getVerifyToken(accessToken)) != null) {
            return verifyTokenResponse;
        }
        if (verifyTokenResponse == null) {
            ClientResponse res = (ClientResponse)((WebResource.Builder)this.client.resource(String.format("%s?access_token=%s", this.authorizationServerUrl, accessToken)).header("Authorization", (Object)("Basic " + this.authorizationValue)).accept(new String[]{"application/json"})).get(ClientResponse.class);
            try {
                String responseString = (String)res.getEntity(String.class);
                int statusCode = res.getClientResponseStatus().getStatusCode();
                LOG.debug("Got verify token response (status: {}): '{}'", (Object)statusCode, (Object)responseString);
                if (statusCode == 200) {
                    verifyTokenResponse = (VerifyTokenResponse)this.objectMapper.readValue(responseString, VerifyTokenResponse.class);
                }
            }
            catch (Exception e) {
                LOG.error("Exception in reading result from AuthorizationServer", (Throwable)e);
            }
        }
        if (this.isValidResponse(verifyTokenResponse) && this.cacheAccessTokens()) {
            this.cache.storeVerifyToken(accessToken, verifyTokenResponse);
        }
        return verifyTokenResponse;
    }

    protected void sendError(HttpServletResponse response, int statusCode, String reason) {
        LOG.warn("No valid access-token on request. Will respond with error response");
        try {
            response.sendError(statusCode, reason);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException(reason, e);
        }
    }

    protected boolean cacheAccessTokens() {
        return this.cacheEnabled;
    }

    protected boolean handledCorsPreflightRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.allowCorsRequests || StringUtils.isBlank((String)request.getHeader("Origin"))) {
            return false;
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        if (StringUtils.isNotBlank((String)request.getHeader("Access-Control-Request-Method")) && request.getMethod().equalsIgnoreCase("OPTIONS")) {
            response.setHeader("Access-Control-Allow-Methods", this.getAccessControlAllowedMethods());
            String requestHeaders = request.getHeader("Access-Control-Request-Headers");
            if (StringUtils.isNotBlank((String)requestHeaders)) {
                response.setHeader("Access-Control-Allow-Headers", this.getAllowedHeaders(requestHeaders));
            }
            response.setHeader("Access-Control-Max-Age", this.getAccessControlMaxAge());
            response.setStatus(200);
            response.flushBuffer();
            return true;
        }
        return false;
    }

    protected String getAllowedHeaders(String requestHeaders) {
        return requestHeaders;
    }

    protected String getAccessControlMaxAge() {
        return "86400";
    }

    protected String getAccessControlAllowedMethods() {
        return "GET, OPTIONS, HEAD, PUT, PATCH, POST, DELETE";
    }

    private boolean isValidResponse(VerifyTokenResponse tokenResponse) {
        return tokenResponse != null && tokenResponse.getPrincipal() != null && tokenResponse.getError() == null;
    }

    private String getAccessToken(HttpServletRequest request) {
        String method;
        int space;
        String accessToken = null;
        String header = request.getHeader("Authorization");
        if (header != null && (space = header.indexOf(32)) > 0 && BEARER.equalsIgnoreCase(method = header.substring(0, space))) {
            accessToken = header.substring(space + 1);
        }
        return accessToken;
    }

    public void destroy() {
    }

    public void setAuthorizationServerUrl(String authorizationServerUrl) {
        this.authorizationServerUrl = authorizationServerUrl;
    }

    public void setResourceServerSecret(String resourceServerSecret) {
        this.resourceServerSecret = resourceServerSecret;
    }

    public void setResourceServerKey(String resourceServerKey) {
        this.resourceServerKey = resourceServerKey;
    }
}

