/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.auth.principal;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class UserPassCredentials {
    private static final char SEMI_COLON = ':';
    private static final int BASIC_AUTH_PREFIX_LENGTH = "Basic ".length();
    private String username;
    private String password;

    public UserPassCredentials(String authorizationHeader) {
        if (authorizationHeader == null || authorizationHeader.length() < BASIC_AUTH_PREFIX_LENGTH) {
            this.noValidAuthHeader();
            return;
        }
        String authPart = authorizationHeader.substring(BASIC_AUTH_PREFIX_LENGTH);
        String userpass = new String(Base64.decodeBase64((byte[])authPart.getBytes()));
        int index = userpass.indexOf(58);
        if (index < 1) {
            this.noValidAuthHeader();
            return;
        }
        this.username = userpass.substring(0, index);
        this.password = userpass.substring(index + 1);
    }

    public UserPassCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    private void noValidAuthHeader() {
        this.username = null;
        this.password = null;
    }

    public boolean isValid() {
        return !StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "UserPassCredentials [username=" + this.username + "]";
    }

    public String getAuthorizationHeaderValue() {
        String result = null;
        if (!StringUtils.isBlank((String)this.username) && !StringUtils.isBlank((String)this.password)) {
            String value = this.username + ":" + this.password;
            result = "Basic " + new String(Base64.encodeBase64((byte[])value.getBytes()));
        }
        return result;
    }
}

