/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.model;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;
import org.surfnet.oaaas.model.TokenResponseCache;
import org.surfnet.oaaas.model.VerifyTokenResponse;

public class TokenResponseCacheImpl
implements TokenResponseCache {
    private Map<String, CacheEntry> cache = new ConcurrentHashMap<String, CacheEntry>();
    private int maxSize;
    private long expireTime;

    public TokenResponseCacheImpl(int maxSize, long expireTimeSeconds) {
        this.maxSize = maxSize;
        this.expireTime = expireTimeSeconds * 1000L;
        this.invariant();
    }

    private void invariant() {
        Assert.isTrue((this.maxSize > 0 ? 1 : 0) != 0, (String)"Maxsize must be greater then 0");
        Assert.isTrue((this.expireTime < 86400001L ? 1 : 0) != 0, (String)"Maximal expireTime is one day");
        Assert.isTrue((this.expireTime > 0L ? 1 : 0) != 0, (String)"ExpireTimeMilliseconds must be greater then 0");
    }

    @Override
    public VerifyTokenResponse getVerifyToken(String accessToken) {
        CacheEntry cacheEntry;
        VerifyTokenResponse response = null;
        if (accessToken != null && (cacheEntry = this.cache.get(accessToken)) != null) {
            if (this.isExpired(cacheEntry)) {
                this.cache.remove(accessToken);
            } else {
                response = cacheEntry.value;
            }
        }
        return response;
    }

    private boolean isExpired(CacheEntry cacheEntry) {
        return cacheEntry.expireBy < System.currentTimeMillis();
    }

    @Override
    public void storeVerifyToken(String accessToken, VerifyTokenResponse tokenResponse) {
        if (accessToken != null && tokenResponse != null) {
            if (this.cache.size() == this.maxSize) {
                this.cleanUpCache();
            }
            this.cache.put(accessToken, new CacheEntry(tokenResponse, System.currentTimeMillis() + this.expireTime));
        }
    }

    private void cleanUpCache() {
        Set<Map.Entry<String, CacheEntry>> entries = this.cache.entrySet();
        long ago = Long.MAX_VALUE;
        String oldestKey = null;
        for (Map.Entry<String, CacheEntry> entry : entries) {
            if (this.isExpired(entry.getValue())) {
                this.cache.remove(entry.getKey());
                continue;
            }
            if (entry.getValue().expireBy >= ago) continue;
            oldestKey = entry.getKey();
            ago = entry.getValue().expireBy;
        }
        if (oldestKey != null) {
            this.cache.remove(oldestKey);
        }
    }

    private class CacheEntry {
        private VerifyTokenResponse value;
        private long expireBy;

        CacheEntry(VerifyTokenResponse verifyTokenResponse, long expireBy) {
            this.value = verifyTokenResponse;
            this.expireBy = expireBy;
        }
    }
}

