/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.spring.security.opensaml.AuthnRequestGenerator;
import nl.surfnet.spring.security.opensaml.Provisioner;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import nl.surfnet.spring.security.opensaml.ServiceProviderAuthenticationException;
import nl.surfnet.spring.security.opensaml.util.IDService;
import nl.surfnet.spring.security.opensaml.util.TimeService;
import nl.surfnet.spring.security.opensaml.xml.EndpointGenerator;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.surfnet.oaaas.auth.AbstractAuthenticator;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.conext.OpenSAMLContext;
import org.surfnet.oaaas.conext.SAMLProvisioner;

@Component
public class SAMLAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLAuthenticator.class);
    private TimeService timeService = new TimeService();
    private IDService idService = new IDService();
    private OpenSAMLContext openSAMLContext;
    private String ssoUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        try {
            Properties properties = PropertiesLoaderUtils.loadAllProperties((String)"surfconext.authn.properties");
            this.openSAMLContext = this.createOpenSAMLContext(properties);
            this.ssoUrl = properties.getProperty("ssoUrl", "no-property-named-ssoUrl");
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected OpenSAMLContext createOpenSAMLContext(Properties properties) {
        return new OpenSAMLContext(properties, this.createProvisioner());
    }

    protected Provisioner createProvisioner() {
        return new SAMLProvisioner();
    }

    public boolean canCommence(HttpServletRequest request) {
        return this.isSAMLResponse(request);
    }

    public void authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String authStateValue, String returnUri) throws IOException, ServletException {
        LOG.debug("Hitting SAML Authenticator filter");
        if (this.isSAMLResponse(request)) {
            Response samlResponse = this.extractSamlResponse(request);
            if (samlResponse == null) {
                LOG.info("Invalid response gotten from SAML IdP");
                return;
            }
            UserDetails ud = this.authenticate(samlResponse);
            if (ud == null) {
                LOG.info("Cannot get UserDetails from SAML response");
            } else {
                super.setPrincipal((ServletRequest)request, this.convertToPrincipal(ud));
                super.setAuthStateValue((ServletRequest)request, this.getSAMLRelayState(request));
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        this.sendAuthnRequest(response, authStateValue, this.getReturnUri((ServletRequest)request));
    }

    private AuthenticatedPrincipal convertToPrincipal(UserDetails ud) {
        Collection authorities = ud.getAuthorities();
        HashSet<String> roles = new HashSet<String>();
        if (authorities != null) {
            for (GrantedAuthority authority : authorities) {
                roles.add(authority.getAuthority());
            }
        }
        Map<String, Object> attributes = this.getPrincipalAttributes(ud);
        return new AuthenticatedPrincipal(ud.getUsername(), roles, attributes);
    }

    protected Map<String, Object> getPrincipalAttributes(UserDetails ud) {
        return Collections.emptyMap();
    }

    protected String getSAMLRelayState(HttpServletRequest request) {
        return request.getParameter("RelayState");
    }

    protected boolean isSAMLResponse(HttpServletRequest request) {
        return request.getParameter("SAMLResponse") != null;
    }

    private UserDetails authenticate(Response samlResponse) {
        try {
            return this.openSAMLContext.assertionConsumer().consume(samlResponse);
        }
        catch (AuthenticationException e) {
            LOG.info("When authenticating SAML response", (Throwable)e);
            return null;
        }
    }

    private Response extractSamlResponse(HttpServletRequest request) {
        SAMLMessageContext messageContext;
        SAMLMessageHandler samlMessageHandler = this.openSAMLContext.samlMessageHandler();
        try {
            messageContext = samlMessageHandler.extractSAMLMessageContext(request);
        }
        catch (MessageDecodingException me) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", (Throwable)me);
        }
        catch (SecurityException se) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", (Throwable)se);
        }
        LOG.debug("Message received from issuer: " + messageContext.getInboundMessageIssuer());
        if (!(messageContext.getInboundSAMLMessage() instanceof Response)) {
            throw new ServiceProviderAuthenticationException("SAML Message was not a Response.");
        }
        Response inboundSAMLMessage = (Response)messageContext.getInboundSAMLMessage();
        try {
            this.openSAMLContext.validatorSuite().validate((XMLObject)inboundSAMLMessage);
            return inboundSAMLMessage;
        }
        catch (ValidationException ve) {
            LOG.warn("Response Message failed Validation", (Throwable)ve);
            throw new RuntimeException("Invalid SAML Response Message", ve);
        }
    }

    private void sendAuthnRequest(HttpServletResponse response, String authState, String returnUri) throws IOException {
        AuthnRequestGenerator authnRequestGenerator = new AuthnRequestGenerator(this.openSAMLContext.entityId(), this.timeService, this.idService);
        EndpointGenerator endpointGenerator = new EndpointGenerator();
        String target = this.ssoUrl;
        Endpoint endpoint = endpointGenerator.generateEndpoint(SingleSignOnService.DEFAULT_ELEMENT_NAME, target, this.openSAMLContext.assertionConsumerUri());
        AuthnRequest authnRequest = authnRequestGenerator.generateAuthnRequest(target, this.openSAMLContext.assertionConsumerUri());
        LOG.debug("Sending authnRequest to {}", (Object)target);
        String relayState = authState;
        try {
            this.openSAMLContext.samlMessageHandler().sendSAMLMessage((SignableSAMLObject)authnRequest, endpoint, response, relayState);
        }
        catch (MessageEncodingException mee) {
            LOG.error("Could not send authnRequest to Identity Provider.", (Throwable)mee);
            response.sendError(500);
        }
    }
}

