/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.util.Collections;
import java.util.List;
import nl.surfnet.spring.security.opensaml.Provisioner;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.xml.XMLObject;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

public class SAMLProvisioner
implements Provisioner {
    private static final String UID = "urn:oid:1.3.6.1.4.1.1076.20.40.40.1";

    public UserDetails provisionUser(Assertion assertion) {
        String userId = this.getValueFromAttributeStatements(assertion, UID);
        return new User(userId, "", Collections.singletonList(new SimpleAuthority("USER")));
    }

    private String getValueFromAttributeStatements(Assertion assertion, String name) {
        List attributeStatements = assertion.getAttributeStatements();
        for (AttributeStatement attributeStatement : attributeStatements) {
            List attributes = attributeStatement.getAttributes();
            for (Attribute attribute : attributes) {
                if (!name.equals(attribute.getName())) continue;
                return ((XMLObject)attribute.getAttributeValues().get(0)).getDOM().getTextContent();
            }
        }
        return "";
    }

    public static class SimpleAuthority
    implements GrantedAuthority {
        private static final long serialVersionUID = 1L;
        String name;

        public SimpleAuthority(String name) {
            this.name = name;
        }

        public String getAuthority() {
            return this.name;
        }
    }
}

