/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.coin.api.client.OpenConextOAuthClient;
import nl.surfnet.coin.api.client.domain.Group20;
import nl.surfnet.spring.security.opensaml.AuthnRequestGenerator;
import nl.surfnet.spring.security.opensaml.Provisioner;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import nl.surfnet.spring.security.opensaml.ServiceProviderAuthenticationException;
import nl.surfnet.spring.security.opensaml.util.IDService;
import nl.surfnet.spring.security.opensaml.util.TimeService;
import nl.surfnet.spring.security.opensaml.xml.EndpointGenerator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.RequesterID;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.Scoping;
import org.opensaml.saml2.core.impl.RequesterIDBuilder;
import org.opensaml.saml2.core.impl.ScopingBuilder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.surfnet.oaaas.auth.AbstractAuthenticator;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;
import org.surfnet.oaaas.conext.OpenSAMLContext;
import org.surfnet.oaaas.conext.SAMLProvisioner;
import org.surfnet.oaaas.model.AuthorizationRequest;
import org.surfnet.oaaas.model.Client;
import org.surfnet.oaaas.repository.AuthorizationRequestRepository;

@Component
public class SAMLAuthenticator
extends AbstractAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLAuthenticator.class);
    private static final String RELAY_STATE_FROM_SAML = "RELAY_STATE_FROM_SAML";
    private static final String PRINCIPAL_FROM_SAML = "PRINCIPAL_FROM_SAML";
    private static final String CLIENT_SAML_ENTITY_NAME = "CLIENT_SAML_ENTITY_NAME";
    private TimeService timeService = new TimeService();
    private IDService idService = new IDService();
    private ScopingBuilder scopingBuilder = new ScopingBuilder();
    private RequesterIDBuilder requesterIDBuilder = new RequesterIDBuilder();
    private OpenSAMLContext openSAMLContext;
    private OpenConextOAuthClient apiClient;
    private String callbackFlagParameter = "apiOauthCallback";
    private boolean enrichPricipal;
    @Inject
    private AuthorizationRequestRepository authorizationRequestRepository;
    private final Properties properties;

    public SAMLAuthenticator() {
        try {
            this.properties = PropertiesLoaderUtils.loadAllProperties((String)"surfconext.authn.properties");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            super.init(filterConfig);
            this.openSAMLContext = this.createOpenSAMLContext(this.properties);
            this.enrichPricipal = Boolean.valueOf(this.properties.getProperty("api-enrich-principal"));
            if (this.enrichPricipal) {
                this.apiClient = this.createOpenConextOAuthClient(this.properties);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected OpenConextOAuthClient createOpenConextOAuthClient(Properties properties) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        OpenConextOAuthClient apiClient = (OpenConextOAuthClient)((Object)((Object)this)).getClass().getClassLoader().loadClass(properties.getProperty("openConextApiClient")).newInstance();
        BeanUtils.setProperty((Object)apiClient, (String)"callbackUrl", (Object)properties.getProperty("api-callbackuri"));
        BeanUtils.setProperty((Object)apiClient, (String)"consumerSecret", (Object)properties.getProperty("api-consumersecret"));
        BeanUtils.setProperty((Object)apiClient, (String)"consumerKey", (Object)properties.getProperty("api-consumerkey"));
        BeanUtils.setProperty((Object)apiClient, (String)"endpointBaseUrl", (Object)properties.getProperty("api-baseurl"));
        return apiClient;
    }

    protected OpenSAMLContext createOpenSAMLContext(Properties properties) {
        return new OpenSAMLContext(properties, this.createProvisioner());
    }

    protected Provisioner createProvisioner() {
        SAMLProvisioner samlProvisioner = new SAMLProvisioner();
        samlProvisioner.setUuidAttribute((String)this.properties.get("samlUuidAttribute"));
        return samlProvisioner;
    }

    public boolean canCommence(HttpServletRequest request) {
        return this.isSAMLResponse(request) || this.isOAuthCallback(request);
    }

    public void authenticate(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String authStateValue, String returnUri) throws IOException, ServletException {
        LOG.debug("Hitting SAML Authenticator filter");
        if (this.isSAMLResponse(request)) {
            Response samlResponse = this.extractSamlResponse(request);
            AuthenticatedPrincipal principal = (AuthenticatedPrincipal)this.openSAMLContext.assertionConsumer().consume(samlResponse);
            if (this.enrichPricipal) {
                request.getSession().setAttribute(PRINCIPAL_FROM_SAML, (Object)principal);
                request.getSession().setAttribute(RELAY_STATE_FROM_SAML, (Object)this.getSAMLRelayState(request));
                response.sendRedirect(this.apiClient.getAuthorizationUrl());
            } else {
                this.proceedWithChain(request, response, chain, principal, this.getSAMLRelayState(request));
            }
        } else if (this.isOAuthCallback(request)) {
            AuthenticatedPrincipal principal = (AuthenticatedPrincipal)request.getSession().getAttribute(PRINCIPAL_FROM_SAML);
            String authState = (String)request.getSession().getAttribute(RELAY_STATE_FROM_SAML);
            if (principal == null) {
                throw new ServiceProviderAuthenticationException("No principal anymore in the session");
            }
            String userId = principal.getName();
            this.apiClient.oauthCallback(request, userId);
            List groups = this.apiClient.getGroups20(userId, userId);
            if (!CollectionUtils.isEmpty((Collection)groups)) {
                for (Group20 group : groups) {
                    principal.addGroup(group.getId());
                }
            }
            this.proceedWithChain(request, response, chain, principal, authState);
        } else {
            this.sendAuthnRequest(response, authStateValue, this.getReturnUri((ServletRequest)request));
        }
    }

    private void proceedWithChain(HttpServletRequest request, HttpServletResponse response, FilterChain chain, AuthenticatedPrincipal principal, String authStateValue) throws IOException, ServletException {
        super.setPrincipal((ServletRequest)request, principal);
        super.setAuthStateValue((ServletRequest)request, authStateValue);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean isOAuthCallback(HttpServletRequest request) {
        return request.getParameter(this.callbackFlagParameter) != null;
    }

    protected String getSAMLRelayState(HttpServletRequest request) {
        return request.getParameter("RelayState");
    }

    protected boolean isSAMLResponse(HttpServletRequest request) {
        return request.getParameter("SAMLResponse") != null;
    }

    private Response extractSamlResponse(HttpServletRequest request) {
        SAMLMessageContext messageContext;
        SAMLMessageHandler samlMessageHandler = this.openSAMLContext.samlMessageHandler();
        try {
            messageContext = samlMessageHandler.extractSAMLMessageContext(request);
        }
        catch (MessageDecodingException me) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", (Throwable)me);
        }
        catch (SecurityException se) {
            throw new ServiceProviderAuthenticationException("Could not decode SAML Response", (Throwable)se);
        }
        LOG.debug("Message received from issuer: " + messageContext.getInboundMessageIssuer());
        if (!(messageContext.getInboundSAMLMessage() instanceof Response)) {
            throw new ServiceProviderAuthenticationException("SAML Message was not a Response.");
        }
        Response inboundSAMLMessage = (Response)messageContext.getInboundSAMLMessage();
        try {
            this.openSAMLContext.validatorSuite().validate((XMLObject)inboundSAMLMessage);
            return inboundSAMLMessage;
        }
        catch (ValidationException ve) {
            LOG.warn("Response Message failed Validation", (Throwable)ve);
            throw new RuntimeException("Invalid SAML Response Message", ve);
        }
    }

    private void sendAuthnRequest(HttpServletResponse response, String authState, String returnUri) throws IOException {
        AuthnRequestGenerator authnRequestGenerator = new AuthnRequestGenerator(this.openSAMLContext.entityId(), this.timeService, this.idService);
        EndpointGenerator endpointGenerator = new EndpointGenerator();
        String target = this.openSAMLContext.getIdpUrl();
        Endpoint endpoint = endpointGenerator.generateEndpoint(SingleSignOnService.DEFAULT_ELEMENT_NAME, target, this.openSAMLContext.assertionConsumerUri());
        AuthnRequest authnRequest = authnRequestGenerator.generateAuthnRequest(target, this.openSAMLContext.assertionConsumerUri());
        Client client = this.getClientByRequest(authState);
        String spEntityIdBy = (String)client.getAttributes().get(CLIENT_SAML_ENTITY_NAME);
        if (StringUtils.isNotEmpty((String)spEntityIdBy)) {
            Scoping scoping = this.scopingBuilder.buildObject();
            scoping.getRequesterIDs().add(this.createRequesterID(spEntityIdBy));
            authnRequest.setScoping(scoping);
        } else {
            LOG.warn("For Client {} there is no key CLIENT_SAML_ENTITY_NAME configured to identify the SP entity name. NO SCOPING IS APPLIED", (Object)client.getClientId());
        }
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.openSAMLContext.entityId()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            Credential signingCredential = (Credential)this.openSAMLContext.keyStoreCredentialResolver().resolveSingle((Object)criteriaSet);
            String relayState = authState;
            LOG.debug("Sending authnRequest to {}", (Object)target);
            this.openSAMLContext.samlMessageHandler().sendSAMLMessage((SignableSAMLObject)authnRequest, endpoint, response, relayState, signingCredential);
        }
        catch (MessageEncodingException mee) {
            LOG.error("Could not send authnRequest to Identity Provider.", (Throwable)mee);
            response.sendError(500);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private RequesterID createRequesterID(String id) {
        RequesterID requesterID = this.requesterIDBuilder.buildObject();
        requesterID.setRequesterID(id);
        return requesterID;
    }

    protected Client getClientByRequest(String authState) {
        AuthorizationRequest authorizationRequest = this.authorizationRequestRepository.findByAuthState(authState);
        return authorizationRequest.getClient();
    }
}

