/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import nl.surfnet.spring.security.opensaml.AssertionConsumer;
import nl.surfnet.spring.security.opensaml.AssertionConsumerImpl;
import nl.surfnet.spring.security.opensaml.KeyStore;
import nl.surfnet.spring.security.opensaml.Provisioner;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandlerImpl;
import nl.surfnet.spring.security.opensaml.SecurityPolicyDelegate;
import nl.surfnet.spring.security.opensaml.SignatureSecurityPolicyRule;
import nl.surfnet.spring.security.opensaml.crypt.KeyStoreCredentialResolverDelegate;
import nl.surfnet.spring.security.opensaml.xml.SAML2ValidatorSuite;
import org.apache.velocity.app.VelocityEngine;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.binding.decoding.SAMLMessageDecoder;
import org.opensaml.common.binding.security.IssueInstantRule;
import org.opensaml.common.binding.security.MessageReplayRule;
import org.opensaml.saml2.binding.decoding.HTTPPostSimpleSignDecoder;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.util.storage.MapBasedStorageService;
import org.opensaml.util.storage.ReplayCache;
import org.opensaml.util.storage.StorageService;
import org.opensaml.ws.security.SecurityPolicy;
import org.opensaml.ws.security.SecurityPolicyResolver;
import org.opensaml.ws.security.provider.StaticSecurityPolicyResolver;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.springframework.ui.velocity.VelocityEngineFactoryBean;

public class OpenSAMLContext {
    private static final String DEFAULT_ASSERTION_CONSUMER_URI = "/assertionConsumerService";
    private long replayCacheDuration;
    private int maxParserPoolSize;
    private String entityId;
    private int clockSkew;
    private int newExpires;
    private String assertionConsumerURI;
    private String idpEntityId;
    private String idpCertificate;
    private Provisioner provisioner;
    private SAMLMessageHandlerImpl samlMessageHandler;
    private final SAML2ValidatorSuite validatorSuite;
    private String idpUrl;
    private String spPrivateKey;
    private String spCertificate;

    public OpenSAMLContext(Properties properties, Provisioner provisioner) {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.replayCacheDuration = Long.parseLong(properties.getProperty("replayCacheDuration", "14400000"));
        this.maxParserPoolSize = Integer.parseInt(properties.getProperty("maxParserPoolSize", "2"));
        this.entityId = properties.getProperty("entityId", "no-property-named-entityId");
        this.clockSkew = Integer.parseInt(properties.getProperty("clockSkew", "90"));
        this.newExpires = Integer.parseInt(properties.getProperty("newExpires", "300"));
        this.assertionConsumerURI = properties.getProperty("assertionConsumerURI", DEFAULT_ASSERTION_CONSUMER_URI);
        this.idpEntityId = properties.getProperty("idpEntityId", "no-property-named-idpEntityId");
        this.idpCertificate = properties.getProperty("idpCertificate", "no-property-named-idpCertificate");
        this.idpUrl = properties.getProperty("idpUrl", "no-property-named-idpUrl");
        this.spPrivateKey = properties.getProperty("spPrivateKey", "no-property-named-spPrivateKey");
        this.spCertificate = properties.getProperty("spCertificate", "no-property-named-spCertificate");
        this.provisioner = provisioner;
        this.samlMessageHandler = new SAMLMessageHandlerImpl(this.samlMessageDecoder(), this.securityPolicyResolver());
        this.samlMessageHandler.setEntityId(this.entityId);
        this.samlMessageHandler.setVelocityEngine(this.velocityEngine());
        this.samlMessageHandler.setNeedsSigning(true);
        this.validatorSuite = new SAML2ValidatorSuite();
    }

    protected VelocityEngine velocityEngine() {
        VelocityEngineFactoryBean velocityEngineFactoryBean = new VelocityEngineFactoryBean();
        velocityEngineFactoryBean.setPreferFileSystemAccess(false);
        Properties velocityEngineProperties = new Properties();
        velocityEngineProperties.setProperty("resource.loader", "classpath");
        velocityEngineProperties.setProperty("classpath.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        velocityEngineFactoryBean.setVelocityProperties(velocityEngineProperties);
        try {
            return velocityEngineFactoryBean.createVelocityEngine();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create velocity engine instance");
        }
    }

    public String assertionConsumerUri() {
        return this.assertionConsumerURI;
    }

    protected ReplayCache replayCache() {
        return new ReplayCache((StorageService)new MapBasedStorageService(), this.replayCacheDuration);
    }

    protected MessageReplayRule messageReplayRule() {
        return new MessageReplayRule(this.replayCache());
    }

    protected IssueInstantRule issueInstantRule() {
        return new IssueInstantRule(this.clockSkew, this.newExpires);
    }

    protected CredentialResolver keyStoreCredentialResolver() {
        KeyStoreCredentialResolverDelegate keyStoreCredentialResolverDelegate = new KeyStoreCredentialResolverDelegate();
        keyStoreCredentialResolverDelegate.setKeyStore(this.keyStore());
        return keyStoreCredentialResolverDelegate;
    }

    protected SignatureSecurityPolicyRule signatureBuilder() {
        SignatureSecurityPolicyRule signatureSecurityPolicyRule = new SignatureSecurityPolicyRule(new SAMLSignatureProfileValidator());
        signatureSecurityPolicyRule.setCredentialResolver(this.keyStoreCredentialResolver());
        try {
            signatureSecurityPolicyRule.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return signatureSecurityPolicyRule;
    }

    protected SecurityPolicyDelegate securityPolicy() {
        return new SecurityPolicyDelegate(Arrays.asList(this.signatureBuilder(), this.issueInstantRule(), this.messageReplayRule()));
    }

    protected SecurityPolicyResolver securityPolicyResolver() {
        return new StaticSecurityPolicyResolver((SecurityPolicy)this.securityPolicy());
    }

    protected SAMLMessageDecoder samlMessageDecoder() {
        BasicParserPool basicParserPool = new BasicParserPool();
        basicParserPool.setMaxPoolSize(this.maxParserPoolSize);
        return new HTTPPostSimpleSignDecoder((ParserPool)basicParserPool);
    }

    public SAMLMessageHandler samlMessageHandler() {
        return this.samlMessageHandler;
    }

    public AssertionConsumer assertionConsumer() {
        AssertionConsumerImpl assertionConsumer = new AssertionConsumerImpl();
        assertionConsumer.setProvisioner(this.provisioner);
        return assertionConsumer;
    }

    protected KeyStore keyStore() {
        KeyStore keyStore = new KeyStore();
        keyStore.addCertificate(this.idpEntityId, this.idpCertificate);
        keyStore.addPrivateKey(this.entityId(), this.spPrivateKey, this.spCertificate, "somepass");
        return keyStore;
    }

    public String entityId() {
        return this.entityId;
    }

    public SAML2ValidatorSuite validatorSuite() {
        return this.validatorSuite;
    }

    public String getIdpUrl() {
        return this.idpUrl;
    }
}

