/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.surfnet.spring.security.opensaml.Provisioner;
import org.apache.commons.lang.StringUtils;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.surfnet.oaaas.conext.SAMLAuthenticatedPrincipal;

public class SAMLProvisioner
implements Provisioner {
    private static final Logger LOG = LoggerFactory.getLogger(SAMLProvisioner.class);
    private String uuidAttribute = "urn:oid:1.3.6.1.4.1.1076.20.40.40.1";
    private static final String DISPLAY_NAME_ATTRIBUTE = "urn:mace:dir:attribute-def:displayName";

    public UserDetails provisionUser(Assertion assertion) {
        String userId = this.getValueFromAttributeStatements(assertion, this.uuidAttribute);
        String identityProvider = this.getAuthenticatingAuthority(assertion);
        if (identityProvider == null) {
            LOG.debug("No AuthenticatingAuthority present in the Assertion, cannot determine IdP. Will leave null in principal.");
        }
        String displayName = this.getValueFromAttributeStatements(assertion, DISPLAY_NAME_ATTRIBUTE);
        return new SAMLAuthenticatedPrincipal(userId, new ArrayList<String>(), new HashMap<String, String>(), new ArrayList<String>(), identityProvider, displayName);
    }

    private String getValueFromAttributeStatements(Assertion assertion, String name) {
        List attributeStatements = assertion.getAttributeStatements();
        for (AttributeStatement attributeStatement : attributeStatements) {
            List attributes = attributeStatement.getAttributes();
            for (Attribute attribute : attributes) {
                if (!name.equals(attribute.getName())) continue;
                return ((XMLObject)attribute.getAttributeValues().get(0)).getDOM().getTextContent();
            }
        }
        return "";
    }

    private String getAuthenticatingAuthority(Assertion assertion) {
        List authnStatements = assertion.getAuthnStatements();
        for (AuthnStatement as : authnStatements) {
            List authorities = as.getAuthnContext().getAuthenticatingAuthorities();
            for (AuthenticatingAuthority aa : authorities) {
                if (!StringUtils.isNotBlank((String)aa.getURI())) continue;
                return aa.getURI();
            }
        }
        return null;
    }

    public void setUuidAttribute(String uuidAttribute) {
        this.uuidAttribute = uuidAttribute;
    }
}

