/*
 * Decompiled with CFR 0.152.
 */
package org.surfnet.oaaas.conext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.CollectionUtils;
import org.surfnet.oaaas.auth.principal.AuthenticatedPrincipal;

public class SAMLAuthenticatedPrincipal
extends AuthenticatedPrincipal
implements UserDetails {
    @JsonIgnore
    private static final String IDENTITY_PROVIDER = "IDENTITY_PROVIDER";
    @JsonIgnore
    private static final String DISPLAY_NAME = "DISPLAY_NAME";

    public SAMLAuthenticatedPrincipal() {
    }

    public SAMLAuthenticatedPrincipal(String username, Collection<String> roles, Map<String, String> attributes, Collection<String> groups, String identityProvider, String displayName, boolean adminPrincipal) {
        super(username, roles, attributes, groups);
        this.addAttribute(IDENTITY_PROVIDER, identityProvider);
        this.addAttribute(DISPLAY_NAME, displayName);
        this.setAdminPrincipal(adminPrincipal);
    }

    @JsonIgnore
    public Collection<? extends GrantedAuthority> getAuthorities() {
        ArrayList<1> authorities = new ArrayList<1>();
        if (!CollectionUtils.isEmpty((Collection)this.getRoles())) {
            for (final String role : this.getRoles()) {
                authorities.add(new GrantedAuthority(){

                    public String getAuthority() {
                        return role;
                    }
                });
            }
        }
        return authorities;
    }

    @JsonIgnore
    public String getPassword() {
        throw new RuntimeException("SAML based authentication does not support passwords on the receiving end");
    }

    @JsonIgnore
    public String getUsername() {
        return this.getName();
    }

    public String getDisplayName() {
        return (String)this.getAttributes().get(DISPLAY_NAME);
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isEnabled() {
        return true;
    }

    @JsonIgnore
    public String getIdentityProvider() {
        return (String)this.getAttributes().get(IDENTITY_PROVIDER);
    }
}

