/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.xacml.api.Identifier;

public class CategoryContainer {
    private final Map<String, Object[]> attributeMap;
    private final Identifier categoryIdentifier;

    CategoryContainer(Identifier categoryIdentifier) {
        this.categoryIdentifier = categoryIdentifier;
        this.attributeMap = new HashMap<String, Object[]>();
    }

    private final void addToMap(String id, Object[] values) {
        if (values == null || values.length <= 0) {
            throw new IllegalArgumentException("Values cannot be null");
        }
        this.attributeMap.put(id, values);
    }

    public Identifier getCategoryIdentifier() {
        return this.categoryIdentifier;
    }

    public Map<String, Object[]> getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    public void addAttribute(String id, String ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, Long ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, Integer ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, Double ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, Boolean ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, Date ... values) {
        this.addToMap(id, values);
    }

    public void addAttribute(String id, URI ... values) {
        this.addToMap(id, values);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, Object[]> e : this.attributeMap.entrySet()) {
            builder.append("Attribute Id: " + e.getKey());
            builder.append(", Attribute Values: ");
            for (Object o : e.getValue()) {
                builder.append(o.toString() + ", ");
            }
            builder.append("\n");
        }
        return builder.toString();
    }
}

