/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.openaz.pepapi.Obligation;
import org.apache.openaz.pepapi.ObligationStore;

public final class ThreadLocalObligationStore
implements ObligationStore {
    private static final ThreadLocal<Map<Class<?>, Set<Obligation>>> obligationMapContainer = new ThreadLocal();

    private ThreadLocalObligationStore() {
    }

    public static ThreadLocalObligationStore newInstance() {
        return new ThreadLocalObligationStore();
    }

    void setObligations(Map<Class<?>, Set<Obligation>> obligationMap) {
        if (obligationMap != null && !obligationMap.isEmpty()) {
            obligationMapContainer.set(Collections.unmodifiableMap(obligationMap));
        } else {
            obligationMapContainer.set(null);
        }
    }

    public Set<Obligation> getAllObligations() {
        HashSet<Obligation> allObligations = new HashSet<Obligation>();
        Map<Class<?>, Set<Obligation>> obligationMap = obligationMapContainer.get();
        if (obligationMap != null) {
            for (Map.Entry<Class<?>, Set<Obligation>> e : obligationMap.entrySet()) {
                allObligations.addAll((Collection<Obligation>)e.getValue());
            }
        }
        return allObligations;
    }

    @Override
    public Set<Obligation> getHandlerObligations(Class<?> oHandlerClass) {
        HashSet<Obligation> obligations = new HashSet<Obligation>();
        Map<Class<?>, Set<Obligation>> obligationMap = obligationMapContainer.get();
        if (obligationMap != null && obligationMap.get(oHandlerClass) != null) {
            obligations.addAll((Collection<Obligation>)obligationMap.get(oHandlerClass));
        }
        return obligations;
    }

    @Override
    public Obligation getHandlerObligationById(Class<?> oHandlerClass, String obligationId) {
        Set<Obligation> obligations = this.getHandlerObligations(oHandlerClass);
        if (obligations != null) {
            for (Obligation obligation : obligations) {
                if (!obligation.getId().equals(obligationId)) continue;
                return obligation;
            }
        }
        return null;
    }

    void clear() {
        obligationMapContainer.remove();
    }
}

