/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.pepapi.std;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.pepapi.Action;
import org.apache.openaz.pepapi.MapperRegistry;
import org.apache.openaz.pepapi.ObjectMapper;
import org.apache.openaz.pepapi.ObligationHandlerRegistry;
import org.apache.openaz.pepapi.ObligationStoreAware;
import org.apache.openaz.pepapi.PepAgent;
import org.apache.openaz.pepapi.PepConfig;
import org.apache.openaz.pepapi.PepException;
import org.apache.openaz.pepapi.PepRequest;
import org.apache.openaz.pepapi.PepRequestFactory;
import org.apache.openaz.pepapi.PepResponse;
import org.apache.openaz.pepapi.PepResponseFactory;
import org.apache.openaz.pepapi.Resource;
import org.apache.openaz.pepapi.Subject;
import org.apache.openaz.pepapi.std.PepUtils;
import org.apache.openaz.pepapi.std.StdMapperRegistry;
import org.apache.openaz.pepapi.std.StdObligationHandlerRegistry;
import org.apache.openaz.pepapi.std.StdObligationRouter;
import org.apache.openaz.pepapi.std.StdPepRequestFactory;
import org.apache.openaz.pepapi.std.StdPepResponseFactory;
import org.apache.openaz.pepapi.std.ThreadLocalObligationStore;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.pdp.PDPEngine;
import org.apache.openaz.xacml.api.pdp.PDPEngineFactory;
import org.apache.openaz.xacml.api.pdp.PDPException;
import org.apache.openaz.xacml.std.json.JSONRequest;
import org.apache.openaz.xacml.std.json.JSONResponse;
import org.apache.openaz.xacml.std.json.JSONStructureException;
import org.apache.openaz.xacml.util.FactoryException;

final class StdPepAgent
implements PepAgent {
    private static final Log logger = LogFactory.getLog(StdPepAgent.class);
    private Properties xacmlProperties;
    private PepConfig pepConfig;
    private PDPEngine pdpEngine;
    private PDPEngineFactory pdpEngineFactory;
    private List<ObligationStoreAware> obligationHandlers = new ArrayList<ObligationStoreAware>();
    private PepRequestFactory pepRequestFactory;
    private PepResponseFactory pepResponseFactory;

    StdPepAgent() {
    }

    void initialize() {
        assert (this.pdpEngineFactory != null);
        if (this.pdpEngine == null) {
            try {
                this.pdpEngine = this.pdpEngineFactory.newEngine(this.xacmlProperties);
            }
            catch (FactoryException e) {
                throw new PepException(e);
            }
        }
        ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
        for (String mapperClassName : this.pepConfig.getMapperClassNames()) {
            Class<?> clazz = PepUtils.loadClass(mapperClassName);
            objectMappers.add((ObjectMapper)PepUtils.instantiateClass(clazz));
        }
        MapperRegistry mapperRegistry = StdMapperRegistry.newInstance(this.pepConfig, objectMappers);
        StdObligationRouter oRouter = null;
        if (!this.obligationHandlers.isEmpty()) {
            ObligationHandlerRegistry oHandlerRegistry = StdObligationHandlerRegistry.newInstance(this.obligationHandlers);
            ThreadLocalObligationStore oStore = ThreadLocalObligationStore.newInstance();
            for (ObligationStoreAware oHandler : this.obligationHandlers) {
                oHandler.setObligationStore(oStore);
            }
            oRouter = StdObligationRouter.newInstance(oHandlerRegistry, oStore);
        }
        this.pepRequestFactory = new StdPepRequestFactory(this.pepConfig, mapperRegistry);
        this.pepResponseFactory = new StdPepResponseFactory(this.pepConfig, oRouter);
    }

    @Override
    public PepResponse decide(Object ... objects) {
        return this.decide(this.pepRequestFactory.newPepRequest(objects)).get(0);
    }

    @Override
    public PepResponse simpleDecide(String subjectId, String actionId, String resourceId) {
        return this.decide(Subject.newInstance(subjectId), Action.newInstance(actionId), Resource.newInstance(resourceId));
    }

    @Override
    public List<PepResponse> bulkDecide(List<?> actionResourcePairs, Object ... objects) {
        return this.decide(this.pepRequestFactory.newBulkPepRequest(actionResourcePairs, objects));
    }

    private List<PepResponse> decide(PepRequest pepRequest) {
        Response response;
        ArrayList<PepResponse> pepResponses = new ArrayList<PepResponse>();
        Request request = pepRequest.getWrappedRequest();
        if (logger.isDebugEnabled()) {
            this.logRequest(request);
        }
        try {
            response = this.pdpEngine.decide(request);
        }
        catch (PDPException e) {
            logger.error((Object)e);
            throw new PepException(e);
        }
        if (logger.isDebugEnabled()) {
            this.logResponse(response);
        }
        for (Result result : response.getResults()) {
            pepResponses.add(this.pepResponseFactory.newPepResponse(result));
        }
        return pepResponses;
    }

    private void logRequest(Request request) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JSONRequest.convert((Request)request, (OutputStream)out);
            logger.debug((Object)out.toString("UTF-8"));
        }
        catch (IOException e) {
            logger.debug((Object)"Error printing XACML request in JSON", (Throwable)e);
        }
        catch (JSONStructureException e) {
            logger.debug((Object)"Error printing XACML request in JSON", (Throwable)e);
        }
    }

    private void logResponse(Response response) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JSONResponse.convert((Response)response, (OutputStream)out);
            logger.debug((Object)out.toString("UTF-8"));
        }
        catch (IOException e) {
            logger.debug((Object)"Error printing XACML response in JSON", (Throwable)e);
        }
        catch (JSONStructureException e) {
            logger.debug((Object)"Error printing XACML response in JSON", (Throwable)e);
        }
    }

    public PDPEngine getPdpEngine() {
        return this.pdpEngine;
    }

    public PepConfig getPepConfig() {
        return this.pepConfig;
    }

    void setPdpEngineFactory(PDPEngineFactory pdpEngineFactory) {
        this.pdpEngineFactory = pdpEngineFactory;
    }

    void setPepConfig(PepConfig pepConfig) {
        this.pepConfig = pepConfig;
    }

    void setXacmlProperties(Properties properties) {
        this.xacmlProperties = properties;
    }

    void setObligationHandlers(List<ObligationStoreAware> obligationHandlers) {
        if (obligationHandlers != null) {
            this.obligationHandlers = new ArrayList<ObligationStoreAware>();
            this.obligationHandlers.addAll(obligationHandlers);
        }
    }
}

